/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.secretsharing;

import java.math.BigInteger;
import java.util.Arrays;
import org.gnunet.construct.FixedSizeIntegerArray;
import org.gnunet.construct.Message;
import org.gnunet.secretsharing.Parameters;
import org.gnunet.util.BigIntegers;
import org.gnunet.util.Strings;

public class Ciphertext
implements Message {
    @FixedSizeIntegerArray(signed=true, bitSize=8, length=128)
    public byte[] c_1;
    @FixedSizeIntegerArray(signed=true, bitSize=8, length=128)
    public byte[] c_2;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ciphertext that = (Ciphertext)o;
        if (!Arrays.equals(this.c_1, that.c_1)) {
            return false;
        }
        return Arrays.equals(this.c_2, that.c_2);
    }

    public int hashCode() {
        int result = this.c_1 != null ? Arrays.hashCode(this.c_1) : 0;
        result = 31 * result + (this.c_2 != null ? Arrays.hashCode(this.c_2) : 0);
        return result;
    }

    public void allocate() {
        this.c_1 = new byte[128];
        this.c_2 = new byte[128];
    }

    public String toString() {
        byte[] allBytes = new byte[this.c_1.length + this.c_2.length];
        System.arraycopy(this.c_1, 0, allBytes, 0, this.c_1.length);
        System.arraycopy(this.c_2, 0, allBytes, this.c_1.length, this.c_2.length);
        return Strings.dataToString(allBytes);
    }

    public static Ciphertext fromString(String s) {
        byte[] allBytes = new byte[256];
        if (!Strings.stringToData(s, allBytes)) {
            return null;
        }
        Ciphertext ciphertext = new Ciphertext();
        ciphertext.allocate();
        System.arraycopy(allBytes, 0, ciphertext.c_1, 0, ciphertext.c_1.length);
        System.arraycopy(allBytes, ciphertext.c_1.length, ciphertext.c_2, 0, ciphertext.c_2.length);
        return ciphertext;
    }

    public Ciphertext multiply(Ciphertext v) {
        BigInteger xc_1 = new BigInteger(1, this.c_1);
        BigInteger xc_2 = new BigInteger(1, this.c_2);
        BigInteger yc_1 = new BigInteger(1, v.c_1);
        BigInteger yc_2 = new BigInteger(1, v.c_2);
        Ciphertext ciphertext = new Ciphertext();
        ciphertext.c_1 = BigIntegers.serializeUnsigned(xc_1.multiply(yc_1).mod(Parameters.elgamalP), 1024);
        ciphertext.c_2 = BigIntegers.serializeUnsigned(xc_2.multiply(yc_2).mod(Parameters.elgamalP), 1024);
        return ciphertext;
    }

    public static Ciphertext identity() {
        Ciphertext ciphertext = new Ciphertext();
        ciphertext.allocate();
        ciphertext.c_1 = BigIntegers.serializeUnsigned(BigInteger.ONE, 1024);
        ciphertext.c_2 = BigIntegers.serializeUnsigned(BigInteger.ONE, 1024);
        return ciphertext;
    }
}

