/* -*-C++-*-
*******************************************************************************
*
* File:         GrTestSink.cc
* Description:  
*
*******************************************************************************
*/

/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "GrTestSink.h"
#include <stdio.h>
#include <cppunit/TestAssert.h>

#define	OUTPUT_SIZE	 300L

// add code to handle output size and check values.

GrTestSink::GrTestSink (bool use_sync_mode)
{
  sync_mode_p = use_sync_mode;
  last = (VrSampleIndex) 0;
  setOutputSize (OUTPUT_SIZE);
}

int 
GrTestSink::forecast(VrSampleRange output, VrSampleRange inputs[])
{
  /* 1:1 ratio with no history */

  CppUnit::TestAssert::assertEquals (0, output.size % OUTPUT_SIZE, __LINE__, __FILE__);
  CppUnit::TestAssert::assertEquals (0, output.index % OUTPUT_SIZE, __LINE__, __FILE__);

  for(unsigned int i = 0; i < numberInputs; i++) {
    inputs[i].index = output.index; 	/* ! do not subtract history ! */
    inputs[i].size = output.size; 	/* + history */
  }

  return 0;
}

int
GrTestSink::work3 (VrSampleRange output, VrSampleRange inputs[], void *ai[])
{
  unsigned long **i = (unsigned long **)ai;
  unsigned long	n;
  unsigned long	size = output.size;
  unsigned long index = output.index;

  if ((size % OUTPUT_SIZE) != 0){
    fprintf (stderr, "GrTestSink: size %% OUTPUT_SIZE != 0: %ld %% %ld = %ld\n",
	     size, OUTPUT_SIZE, size % OUTPUT_SIZE);
    CppUnit::TestAssert::assertEquals (0, size % OUTPUT_SIZE, __LINE__, __FILE__);
  }

#if 0	// not required
  if ((index % OUTPUT_SIZE) != 0){
    fprintf (stderr, "GrTestSink: index %% OUTPUT_SIZE != 0: %ld %% %ld = %ld\n",
	     index, OUTPUT_SIZE, index % OUTPUT_SIZE);

    CppUnit::TestAssert::assertEquals (0, index % OUTPUT_SIZE, __LINE__, __FILE__);
  }
#endif
  
  if (sync_mode_p){
    sync (output.index);

    // check for contiguous output range
    if (last != output.index){
      fprintf (stderr, "GrTestSink: last != output.index: %lld != %lld\n", last, output.index);
      CppUnit::TestAssert::assertEquals (last, output.index, __LINE__, __FILE__);
    }
  }
  else {
    // check for monotonically increasing index
    if (output.index < last){
      fprintf (stderr, "GrTestSink: output.index < last: %lld < %lld\n", output.index, last);
      assert (output.index >= last);
    }
  }
  
  for (n = 0; n < size; n++){
    if (i[0][n] != index){
      fprintf (stderr, "GrTestSink: bad data at offset = %ld: got %ld, expected %ld\n",
	       index, i[0][n], index);
      CppUnit::TestAssert::assertEquals (index, i[0][n], __LINE__, __FILE__);
    }
    index++;
  }

  last = output.index + output.size;
  return output.size;
}
