/*
 * Decompiled with CFR 0.152.
 */
package org.domterm.util;

import java.io.PrintStream;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Node;

public class WTDebug {
    static PrintStream origErr;

    public static void init() {
        if (origErr == null) {
            origErr = System.err;
        }
    }

    public static PrintStream getErr() {
        return origErr;
    }

    public static void print(Object object) {
        origErr.print("" + object);
    }

    public static void println(Object object) {
        origErr.println("" + object);
    }

    public static String pnode(Node node) {
        if (node == null) {
            return "(null)";
        }
        if (node instanceof CharacterData) {
            return node.toString() + '\"' + WTDebug.toQuoted(((CharacterData)node).getData()) + '\"' + "@" + Integer.toHexString(System.identityHashCode(node));
        }
        return node + "/" + node.getNodeName() + "@" + Integer.toHexString(System.identityHashCode(node));
    }

    public static String toQuoted(String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\n') {
                stringBuilder.append("\\n");
                continue;
            }
            if (c == '\r') {
                stringBuilder.append("\\r");
                continue;
            }
            if (c == '\t') {
                stringBuilder.append("\\t");
                continue;
            }
            if (c == '\u001b') {
                stringBuilder.append("\\E");
                continue;
            }
            if (c < ' ' || c >= '\u007f') {
                stringBuilder.append("\\" + (char)((c >> 6 & 7) + 48) + (char)((c >> 3 & 7) + 48) + (char)((c & 7) + 48));
                continue;
            }
            if (c == '\"' || c == '\'' || c == '\\') {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    static {
        WTDebug.init();
    }
}

