#!/usr/bin/env ruby

# Unit test for cdtext.

require 'test/unit'
mypath  = File.expand_path(File.dirname(__FILE__))

%w(lib ext/cdio ext/iso9660).each do |d|
  $: << File.join(mypath, '..', d)
end
%w(cdio iso9660).each {|f| require f}

class CDTextTests < Test::Unit::TestCase
  
  # Test keywords
  def test_keyword
    assert_equal(Rubycdio.cdtext_is_keyword('PERFORMER'),
                 Rubycdio::CDTEXT_PERFORMER)
    assert_equal(Rubycdio.cdtext_is_keyword('IDONOTEXIST'),
                 Rubycdio::MAX_CDTEXT_FIELDS)
    
    assert_equal(Rubycdio.cdtext_field2str(Rubycdio::CDTEXT_PERFORMER),
                 "PERFORMER")
  end
  
  # Test getting and setting CDText
  def test_get_set
    tocpath = File.join(File.dirname(__FILE__), 'cdtext.toc')
    device = Cdio::Device.new(tocpath, Rubycdio::DRIVER_CDRDAO)
    
    disctext = device.track(0).cdtext()
    assert_equal(disctext.get(Rubycdio::CDTEXT_PERFORMER), 'Performer')
    assert_equal(disctext.get(Rubycdio::CDTEXT_TITLE), 'CD Title')
    assert_equal(disctext.get(Rubycdio::CDTEXT_DISCID), 'XY12345')
    
    track1text = device.track(1).cdtext()
    assert_equal(track1text.get(Rubycdio::CDTEXT_PERFORMER), 'Performer')
    assert_equal(track1text.get(Rubycdio::CDTEXT_TITLE), 'Track Title')
    
    track1text.set(Rubycdio::CDTEXT_PERFORMER, 'Someone')
    assert_equal(track1text.get(Rubycdio::CDTEXT_PERFORMER), 'Someone')
  end
end

