/* gibbs.h

   originally written by Frederic Bois
   
   Copyright (c) 1993.  Don Maszle, Frederic Bois.  All rights reserved.

   -- Revisions -----
     Logfile:  SCCS/s.gibbs.h
    Revision:  1.6
        Date:  18 Apr 1995
     Modtime:  03:19:06
      Author:  @a
   -- SCCS  ---------

   Header file for gibbs.c
*/

#ifndef _GIBBS_H_
#define _GIBBS_H_

/* -----------------------------------------------------------------------------
   Inclusions
*/

#include <float.h>  /* Floating point limits */

#include "sim.h"


/* -----------------------------------------------------------------------------
   Global/External variables
*/

extern BOOL bModelComputed;


/* -----------------------------------------------------------------------------
   Definitions
*/

#define MISSING_VALUE         (-DBL_MAX)
#define INPUT_MISSING_VALUE   -1
#define PI                    3.1415926535897932384626433
#define INV_SQRT_2PI          0.398942280401433


/* -----------------------------------------------------------------------------
   Prototypes
*/

int  CheckIfSubject (PVOID pData, PVOID pInfo);

void CloseMarkovFiles (PANALYSIS panal);

void DoMarkov (PANALYSIS panal);

int  Estimate_y (PANALYSIS panal, long iSubject, long *plSubjsIndex,
                 double *pdTheta, double *pdPred);

int  FindSubjects (PEXPERIMENT pexp);

void GetNSubjects (PANALYSIS panal, long *pnSubjs, long **plSubjsIndex);

void InitArrays (long lDim, long nSubjs, double ***pdSum, 
                 double ****prgdSumProd);

void InitData (PANALYSIS panal, double **pData, double **pdNewPred, 
               double **pPred, long *pnData);

void Init_theta (PANALYSIS panal, long nSubjs, long *plSubjsIndex, 
                 long nParms, double *pdMu, double *pdKsi, double ***pdTheta, 
                 double *pdPred);

double LnPrior (MCVAR *pmcvar, long nSubjs, double dTheta, double dMu, 
                double dKsi);

void OpenMarkovFiles (PANALYSIS panal);

void ReadChain (FILE *pfileRestart, long nSubjs, long nParms, double *pdMu, 
                double *pdKsi, double ***pdTheta, double **pdSigma, long nSigma,
                double **pdSum, double ***prgdSumProd, long nInitIter, 
                long *iter);

void Sample_theta (PANALYSIS panal, long nParms, double *pdData, 
                   double *pdNewPred, double *pdPred, long nSubjs, 
                   long *plSubjsIndex, long *plSigmaIndex, long nData, 
                   double *pdSigma, long nSigma, double *pdMu, double *pdKsi,
                   double **pdTheta, long iter);

void Sample_theta_by_vector (PANALYSIS panal, long nParms, double *pdData, 
                             double *pdNewPred, double *pdPred, long nSubjs, 
                             long *plSubjsIndex, long *plSigmaIndex, 
                             long nData, double *pdSigma, long nSigma, 
                             double *pdMu, double *pdKsi, double **pdTheta, 
                             double **pdSum, double ***prgdSumProd, long iter);

void SkipWhiteSpaceAndComments (FILE *pfile);

void UpdateArrays (long nParms, long nSubjs, double **pdTheta, 
                   double **pdSum, double ***prgdSumProd);

void WriteMarkovOut (FILE *pfileOut, long iter, double **pdTheta, 
                     long nSubjs, long nParms, double *pdMu, double *pdKsi, 
                     double *pdSigma, long nSigma, PANALYSIS panal, 
                     double *pdData, double *pdPred, long *plSigmaIndex, 
                     long nData);

void WriteOutHeader (FILE *pfileOut, PANALYSIS panal, long nSubjs, 
                     long *plSubjsIndex, long nSigma);

#endif /* _GIBBS_H_ */

/* End */

