/*  Motti -- a strategy game
    Copyright (C) 1999-2014 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef LOGINSERVICE_H
#define LOGINSERVICE_H
#include <string>
#include "GameDispatcher.h"
#include "SessionService.h"

class LoginService
{
  
  
public:
  
    
  
    LoginService();
    ~LoginService();
    
    static void registration(std::string json);
    static void regeneratePassword(std::string json);
    static bool login(std::string login,std::string password);
    static bool login(std::string json);
    static void remove(std::string json);

};

class CreateUser : public UnSecuredIndividualAction{
      virtual std::string internalDispatch(std::string msg,std::string session=""){
	LoginService::registration(msg);
	return "user created";
      };
    };
class RegeneratePassword: public IndividualAction{
    virtual std::string internalDispatch(std::string msg,std::string session=""){
	LoginService::regeneratePassword(msg);
	return "password regeneratePassword";
      };
};
#include <iostream>
class LoginUser: public UnSecuredIndividualAction{
      virtual std::string internalDispatch(std::string msg,std::string session=""){
	
	if (LoginService::login(msg))
	{
	  return SessionService::createFromJson(msg);
	} 
	else
	  return "user unknow or bad password";
      };
public:
    void createFromJson(std::string msg);
    };

 class Logout: public UnSecuredIndividualAction{
      virtual std::string internalDispatch(std::string msg,std::string session=""){
	return SessionService::unvalidateFromJson(msg);
	
      };
public:
    };   


#endif // LOGINSERVICE_H
