#!/bin/sh

# This program tests  the EXAMINE command.

TEMPDIR=/tmp/pspp-tst-$$
TESTFILE=$TEMPDIR/`basename $0`.sps

# ensure that top_builddir  are absolute
if [ -z "$top_builddir" ] ; then top_builddir=. ; fi
if [ -z "$top_srcdir" ] ; then top_srcdir=. ; fi
top_builddir=`cd $top_builddir; pwd`
PSPP=$top_builddir/src/ui/terminal/pspp

# ensure that top_srcdir is absolute
top_srcdir=`cd $top_srcdir; pwd`

STAT_CONFIG_PATH=$top_srcdir/config
export STAT_CONFIG_PATH

LANG=C
export LANG

cleanup()
{
     if [ x"$PSPP_TEST_NO_CLEANUP" != x ] ; then 
	echo "NOT cleaning $TEMPDIR" 
	return ; 
     fi
     cd /
     rm -rf $TEMPDIR
}


fail()
{
    echo $activity
    echo FAILED
    cleanup;
    exit 1;
}


no_result()
{
    echo $activity
    echo NO RESULT;
    cleanup;
    exit 2;
}

pass()
{
    cleanup;
    exit 0;
}

mkdir -p $TEMPDIR

cd $TEMPDIR

activity="create program"
cat > $TESTFILE <<EOF
DATA LIST LIST /QUALITY * W * BRAND * .
BEGIN DATA
3  1  1
2  2  1
1  2  1
1  1  1
4  1  1
4  1  1
5  1  2
2  1  2
4  4  2
2  1  2
3  1  2
7  1  3
4  2  3
5  3  3
3  1  3
6  1  3
END DATA

WEIGHT BY w.

VARIABLE LABELS brand   'Manufacturer'.
VARIABLE LABELS quality 'Breaking Strain'.

VALUE LABELS /brand 1 'Aspeger' 2 'Bloggs' 3 'Charlies'.

LIST /FORMAT=NUMBERED.

EXAMINE
	quality BY brand
	/STATISTICS descriptives extreme(3)
	.
EOF
if [ $? -ne 0 ] ; then no_result ; fi


activity="run program"
$SUPERVISOR $PSPP --testing-mode $TESTFILE
if [ $? -ne 0 ] ; then no_result ; fi

# NOTE:  In the following data: Only the extreme values have been checked
# The descriptives have been blindly pasted.
activity="compare results"
perl -pi -e 's/^\s*$//g' $TEMPDIR/pspp.list
diff -b  $TEMPDIR/pspp.list - << EOF
1.1 DATA LIST.  Reading free-form data from INLINE.
+--------+------+
|Variable|Format|
#========#======#
|QUALITY |F8.0  |
|W       |F8.0  |
|BRAND   |F8.0  |
+--------+------+
Case#  QUALITY        W    BRAND
----- -------- -------- --------
    1     3.00     1.00     1.00
    2     2.00     2.00     1.00
    3     1.00     2.00     1.00
    4     1.00     1.00     1.00
    5     4.00     1.00     1.00
    6     4.00     1.00     1.00
    7     5.00     1.00     2.00
    8     2.00     1.00     2.00
    9     4.00     4.00     2.00
   10     2.00     1.00     2.00
   11     3.00     1.00     2.00
   12     7.00     1.00     3.00
   13     4.00     2.00     3.00
   14     5.00     3.00     3.00
   15     3.00     1.00     3.00
   16     6.00     1.00     3.00
2.1 EXAMINE.  Case Processing Summary
#===============#===============================#
#               #             Cases             #
#               #----------+---------+----------#
#               #   Valid  | Missing |   Total  #
#               #--+-------+-+-------+--+-------#
#               # N|Percent|N|Percent| N|Percent#
#===============#==#=======#=#=======#==#=======#
#Breaking Strain#24|   100%|0|     0%|24|   100%#
#===============#==#=======#=#=======#==#=======#
2.2 EXAMINE.  Extreme Values
#=========================#===========#=====#
#                         #Case Number|Value#
#=========================#===========#=====#
#Breaking Strain Highest 1#         12| 7.00#
#                        2#         16| 6.00#
#              	         3#         14| 5.00#
#               ----------#-----------+-----#
#                 Lowest 1#          4| 1.00#
#                        2#          3| 1.00#
#                        3#          3| 1.00#
#=========================#===========#=====#
2.3 EXAMINE.  Descriptives
#============================================================#=========#==========#
#                                                            #Statistic|Std. Error#
#============================================================#=========#==========#
#Breaking Strain Mean                                        #   3.54  |   .324   #
#                95% Confidence Interval for Mean Lower Bound#  2.871  |          #
#                                                 Upper Bound#  4.212  |          #
#                5% Trimmed Mean                             #   3.50  |          #
#                Median                                      #   4.00  |          #
#                Variance                                    #  2.520  |          #
#                Std. Deviation                              #  1.587  |          #
#                Minimum                                     #  1.000  |          #
#                Maximum                                     #  7.000  |          #
#                Range                                       #  6.000  |          #
#                Interquartile Range                         #   2.75  |          #
#                Skewness                                    #   .059  |   .472   #
#                Kurtosis                                    #  -.358  |   .918   #
#============================================================#=========#==========#
2.4 EXAMINE.  Case Processing Summary
#============================#=============================#
#                            #            Cases            #
#                            #---------+---------+---------#
#                            #  Valid  | Missing |  Total  #
#                            #-+-------+-+-------+-+-------#
#                Manufacturer#N|Percent|N|Percent|N|Percent#
#============================#=#=======#=#=======#=#=======#
#Breaking Strain Aspeger     #8|   100%|0|     0%|8|   100%#
#                Bloggs      #8|   100%|0|     0%|8|   100%#
#                Charlies    #8|   100%|0|     0%|8|   100%#
#============================#=#=======#=#=======#=#=======#
2.5 EXAMINE.  Extreme Values
#======================================#===========#=====#
#                Manufacturer          #Case Number|Value#
#======================================#===========#=====#
#Breaking Strain Aspeger      Highest 1#          6| 4.00#
#                                     2#          5| 4.00#
#                                     3#          1| 3.00#
#                            ----------#-----------+-----#
#                              Lowest 1#          4| 1.00#
#                                     2#          3| 1.00#
#                                     3#          3| 1.00#
#               -----------------------#-----------+-----#
#                Bloggs       Highest 1#          7| 5.00#
#                                     2#          9| 4.00#
#                                     3#          9| 4.00#
#                            ----------#-----------+-----#
#                              Lowest 1#         10| 2.00#
#                                     2#          8| 2.00#
#                                     3#         11| 3.00#
#               -----------------------#-----------+-----#
#              	 Charlies     Highest 1#         12| 7.00#
#                                     2#         16| 6.00#
#                                     3#         14| 5.00#
#                            ----------#-----------+-----#
#                              Lowest 1#         15| 3.00#
#                                     2#         13| 4.00#
#                                     3#         13| 4.00#
#======================================#===========#=====#
2.6 EXAMINE.  Descriptives
#=========================================================================#=========#==========#
#                Manufacturer                                            #Statistic|Std. Error#
#=========================================================================#=========#==========#
#Breaking Strain Aspeger      Mean                                        #   2.25  |   .453   #
#                             95% Confidence Interval for Mean Lower Bound#  1.178  |          #
#                                                              Upper Bound#  3.322  |          #
#                             5% Trimmed Mean                             #   2.22  |          #
#                             Median                                      #   2.00  |          #
#                             Variance                                    #  1.643  |          #
#                             Std. Deviation                              #  1.282  |          #
#                             Minimum                                     #  1.000  |          #
#                             Maximum                                     #  4.000  |          #
#                             Range                                       #  3.000  |          #
#                             Interquartile Range                         #   2.75  |          #
#                             Skewness                                    #   .475  |   .752   #
#                             Kurtosis                                    #  -1.546 |   1.481  #
#               ----------------------------------------------------------#---------+----------#
#                Bloggs       Mean                                        #   3.50  |   .378   #
#                             95% Confidence Interval for Mean Lower Bound#  2.606  |          #
#                                                              Upper Bound#  4.394  |          #
#                             5% Trimmed Mean                             #   3.50  |          #
#                             Median                                      #   4.00  |          #
#                             Variance                                    #  1.143  |          #
#                             Std. Deviation                              #  1.069  |          #
#                             Minimum                                     #  2.000  |          #
#                             Maximum                                     #  5.000  |          #
#                             Range                                       #  3.000  |          #
#                             Interquartile Range                         #   1.75  |          #
#                             Skewness                                    #  -.468  |   .752   #
#                             Kurtosis                                    #  -.831  |   1.481  #
#               ----------------------------------------------------------#---------+----------#
#                Charlies     Mean                                        #   4.88  |   .441   #
#                             95% Confidence Interval for Mean Lower Bound#  3.833  |          #
#                                                              Upper Bound#  5.917  |          #
#                             5% Trimmed Mean                             #   4.86  |          #
#                             Median                                      #   5.00  |          #
#                             Variance                                    #  1.554  |          #
#                             Std. Deviation                              #  1.246  |          #
#                             Minimum                                     #  3.000  |          #
#                             Maximum                                     #  7.000  |          #
#                             Range                                       #  4.000  |          #
#                             Interquartile Range                         #   1.75  |          #
#                             Skewness                                    #   .304  |   .752   #
#                             Kurtosis                                    #   .146  |   1.481  #
#=========================================================================#=========#==========#
EOF
if [ $? -ne 0 ] ; then fail ; fi

pass
