// Copyright (C) 2006-2007 David Sugar, Tycho Softworks.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Top level include directory for GNU Telephony SIP Witch Server.
 * This is a master include file that will be used when producing
 * plugins for GNU SIP Witch.  It includes all generic library headers
 * from both SIP Witch and UCommon.
 * @file sipwitch/sipwitch.h
 */

#ifndef	_SIPWITCH_SIPWITCH_H_
#define	_SIPWITCH_SIPWITCH_H_

#include <ucommon/ucommon.h>

#include <sipwitch/namespace.h>
#include <sipwitch/mapped.h>
#include <sipwitch/service.h>
#include <sipwitch/process.h>
#include <sipwitch/digest.h>

/**
 * @short SIP Witch common library and API services.
 * SIP Witch is packaged as a server with supporting libraries which may
 * be used together to build SIP based telephony services.
 * @author David Sugar <dyfet@gnutelephony.org>
 * @license GNU GPL Version 3 or later.
 * @mainpage GNU SIP Witch
 */

#endif
