# GNU Solfege - eartraining for GNOME
# Copyright (C) 2000, 2001, 2002, 2003  Tom Cato Amundsen
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import gtk

SHORT_WAIT = 700
NORMAL_WAIT = 2000

USE_CHORD = 'chord'
USE_HARMONY = 'harmony'
USE_ID_BY_NAME = 'id-by-name'
USE_DICTATION = 'dictation'
USE_SING_CHORD = 'sing-chord'
USE_CHORD_VOICING = 'chord-voicing'

# These are the exercises that are available as icons on the toolbar
# and listed on the _File menu. 
# The list should have another name. Also, if the number of exercises
# increase, it should be configurable what exercises are available
# from the toolbar.
exercises = ('chord',
             'chord-voicing',
             'harmonic-interval',
             'melodic-interval',
             'sing-interval',
             'identify-scale',
             'id-by-name',
             'dictation',
             'twelve-tone',
             'id-tone',
             'compare-intervals',
             'sing-chord',
             'rhythm',
             'identify-bpm',
             'harmonic-progression-dictation'
             )

exercisedata = {
   # id: prettyname, menulabel, pixmap
    'chord': (_("_Chords"), 'chord24.png', gtk.keysyms.F2, 0),
    'chord-voicing': (_("Chord voicing"), 'chord24.png', gtk.keysyms.F6, gtk.gdk.CONTROL_MASK),
    'harmonic-interval': (_("_Harmonic intervals"),
        'harmonicinterval24.png', gtk.keysyms.F3, 0),
    'melodic-interval': (_("_Melodic intervals"),
        'melodicinterval24.png', gtk.keysyms.F4, 0),
    'sing-interval': (_("_Sing interval"), 'singinterval24.png', gtk.keysyms.F5, 0),
    'identify-scale': (_("_Identify scale"), 'identifyscale24.png', gtk.keysyms.F6, 0),
    'id-by-name': (_("Identify by _name"), 'idbyname24.png', gtk.keysyms.F7, 0),
    'dictation': (_("_Dictation"), 'dictation24.png', gtk.keysyms.F8, 0),
    'harmonic-progression-dictation': (_("Harmonic _progression dictation"),
        'harmonicprogression24.png', gtk.keysyms.F9, 0),
    'twelve-tone': (_("Sing _twelvetone"), 'twelvetone24.png', gtk.keysyms.F10, 0),
    'id-tone': (_("Id_entify tone"), 'idtone24.png', gtk.keysyms.F2, gtk.gdk.CONTROL_MASK),
    'compare-intervals': (_("C_ompare intervals"),
        'compareintervals24.png', gtk.keysyms.F3, gtk.gdk.CONTROL_MASK),
    'sing-chord': (_("Sin_g chord"),
        'singchord24.png', gtk.keysyms.F4, gtk.gdk.CONTROL_MASK),
    'rhythm': (_("Rh_ythm"), 'rhythm24.png', gtk.keysyms.F5, gtk.gdk.CONTROL_MASK),
    'polyrhythm': ("_Polyrhythmic", "", gtk.keysyms.F6, gtk.gdk.CONTROL_MASK),
    'identify-bpm': ("Bpm", "identify-bpm24.png", None, None),
    'intervals': ("Interval", "", None, None),
    'tuner': ("Tuner", "", None, None),
}


QSTATUS_NO = 0
QSTATUS_NEW = 1
QSTATUS_WRONG = 2
QSTATUS_SOLVED = 3
QSTATUS_GIVE_UP = 4
QSTATUS_VOICING_SOLVED = 5
QSTATUS_VOICING_WRONG = 6
QSTATUS_TYPE_WRONG = 7
QSTATUS_TYPE_SOLVED = 8

int_interval = (_("unison"), _("minor second"), _("major second"),
                 _("minor third"), _("major third"), _("fourth"),
                 _("diminished fifth"), _("perfect fifth"),
                 _("minor sixth"), _("major sixth"),
                 _("minor seventh"), _("major seventh"),
                 _("perfect octave"),
                 _("minor ninth"), _("major ninth"),
                 _("minor decim"), _("major decim"))

short_interval_name = (_i("interval|u"),
                       _i("interval|m2"), _i("interval|M2"),
                       _i("interval|m3"), _i("interval|M3"),
                       _i("interval|4"), _i("interval|d5"),
                       _i("interval|5"),
                       _i("interval|m6"), _i("interval|M6"),
                       _i("interval|m7"), _i("interval|M7"),
                       _i("interval|8"),
                       _i("interval|m9"), _i("interval|M9"),
                       _i("interval|m10"), _i("interval|M10"))

