/*
 This file is part of GNU Taler
 (C) 2022-2024 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 *
 * @author Sebastian Javier Marchano (sebasjm)
 */

import {
  AbsoluteTime,
  AmountString,
  Duration,
  TranslatedString,
} from "@gnu-taler/taler-util";
import { InternationalizationAPI } from "@gnu-taler/web-util/browser";
import * as tests from "@gnu-taler/web-util/testing";
import { getEventsFromAmlHistory } from "./CaseDetails.js";
import { ShowConsolidated as TestedComponent } from "./ShowConsolidated.js";

export default {
  title: "show consolidated",
};

const nullTranslator: InternationalizationAPI = {
  str: (str: TemplateStringsArray) => str.join() as TranslatedString,
  singular: (str: TemplateStringsArray) => str.join() as TranslatedString,
  translate: (str: TemplateStringsArray) => [str.join()] as TranslatedString[],
  Translate: () => undefined as unknown,
};

export const WithEmptyHistory = tests.createExample(TestedComponent, {
  history: getEventsFromAmlHistory([], nullTranslator, []),
  until: AbsoluteTime.now(),
});

export const WithSomeEvents = tests.createExample(TestedComponent, {
  history: getEventsFromAmlHistory(
    [
      {
        collection_time: AbsoluteTime.toProtocolTimestamp(
          AbsoluteTime.subtractDuraction(
            AbsoluteTime.now(),
            Duration.fromPrettyString("1d"),
          ),
        ),
        provider_name: "asd",
        attributes: {
          email: "sebasjm@qwdde.com",
        },
        rowid: 1,
      },
    ],
    nullTranslator,
    [],
  ),
  until: AbsoluteTime.now(),
});
