/*
 This file is part of GNU Taler
 (C) 2021-2023 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 *
 * @author Nic Eigel
 * @author Sebastian Javier Marchano (sebasjm)
 */

/**
 * Imports.
 */
import { Fragment, h, VNode } from "preact";

export function ListPage(data: any): VNode {
  let balances = data.data.data[0][4].data.balances;
  let coinBalances = [
    "Total recoup loss",
    "Coin refund fee revenue",
    "Coin deposit fee revenue",
    "Coin melt fee revenue",
    "Coin irregular loss",
    "Coins reported emergency risk by amount",
    "Coins emergencies loss by count",
    "Coins emergencies loss",
    "Coins total arithmetic delta minus",
    "Coins total arithmetic delta plus",
    "Total escrowed",
    "Total refresh hanging",
  ];
  let reserveBalances = [
    "Total balance summary delta minus",
    "Total balance reserve not closed",
    "Reserves total arithmetic delta minus",
    "Reserves total arithmetic delta plus",
    "Reserves total bad signature loss",
    "Reserves history fee revenue",
    "Reserves open fee revenue",
  ];
  let i = 0;

  return (
    <Fragment>
      <div class="columns">
        <div class="column is-half">
          <div class="columns">
            <div class="column">
              <div class="card">
                <div class="card-content">
                  <table class="table is-striped is-fullwidth is-dark">
                    <tbody>
                      <tr>
                        <th>Finding</th>
                        <td class="has-text-right">
                          <b>Count</b>
                        </td>
                        <td class="has-text-right">
                          <b>Gain/Loss</b>
                        </td>
                      </tr>
                      {data["data"]["data"][0].map((x: any) => {
                        const key = Object.keys(x.data)[0];
                        let value = Object.values(x.data)[0];
                        const paramName =
                          key[0].toUpperCase() +
                          key
                            .split("_")
                            .join(" ")
                            .split("-")
                            .join(" ")
                            .slice(1, key.length);
                        if (key == "balances") {
                          //TODO fix
                          let gains = 0;
                          if (value == null) value = 0;
                          else value = Object.keys(value).length;

                          return (
                            <tr class="is-link">
                              <td>{paramName}</td>
                              <td class="has-text-right">
                                <p
                                  class={
                                    value == 0 ? "text-success" : "text-danger"
                                  }
                                >
                                  {String(value)}
                                </p>
                              </td>
                              <td class="has-text-right">
                                <p
                                  class={
                                    gains == 0 ? "text-success" : "text-danger"
                                  }
                                >
                                  {String(gains)}
                                </p>
                              </td>
                            </tr>
                          );
                        } else {
                          <tr class="is-link">
                            <td>{paramName}</td>
                            <td class="has-text-right">
                              <p
                                class={
                                  value == 0 ? "text-success" : "text-danger"
                                }
                              >
                                {String(value)}
                              </p>
                            </td>
                            <td class="has-text-right">
                              <p>
                                {
                                  //TODO
                                }
                              </p>
                            </td>
                          </tr>;
                        }
                      })}
                    </tbody>
                  </table>
                </div>
              </div>
              <div class="card">
                <div class="card-content">
                  <table class="table is-striped is-fullwidth is-dark">
                    <tbody>
                      <tr>
                        <th>Summary</th>
                        <td class="has-text-right">
                          <b>Value</b>
                        </td>
                      </tr>
                      <tr>
                        <td>Total gain/loss</td>
                        <td class="has-text-right">
                          {
                            //TODO fix
                          }
                        </td>
                      </tr>
                      <tr>
                        <td>Pending gain/loss</td>
                        <td class="has-text-right">
                          {
                            //TODO fix
                          }
                        </td>
                      </tr>
                      <tr>
                        <td>Transaction count</td>
                        <td class="has-text-right">
                          {
                            //TODO fix
                          }
                        </td>
                      </tr>
                      <tr>
                        <td>Transactions pending</td>
                        <td class="has-text-right">
                          {
                            //TODO fix
                          }
                        </td>
                      </tr>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="column is-half">
          <div class="card">
            <div class="card-content">
              <p class="has-text-weight-bold">Helper coin</p>
              <table class="table is-striped is-fullwidth is-dark">
                <tbody>
                  <tr>
                    <th>Balance</th>
                    <td>
                      <b>Value</b>
                    </td>
                  </tr>
                  {balances.map((x: any) => {
                    let key = x.balance_key;
                    let balanceName =
                      key[0].toUpperCase() +
                      key
                        .split("_")
                        .join(" ")
                        .split("-")
                        .join(" ")
                        .slice(1, key.length);

                    if (coinBalances.includes(balanceName)) {
                      let value = balances[i].balance_value.replace(":", " ");
                      i = i + 1;
                      return (
                        <tr class="is-link">
                          <td>{balanceName}</td>
                          <td>
                            <p>{value}</p>
                          </td>
                        </tr>
                      );
                    } else {
                      return null;
                    }
                  })}
                </tbody>
              </table>
              <p class="has-text-weight-bold">Helper reserve</p>
              <table class="table is-striped is-fullwidth is-dark">
                <tbody>
                  <tr>
                    <th>Balance</th>
                    <td>
                      <b>Value</b>
                    </td>
                  </tr>
                  {balances.map((x: any) => {
                    let key = x.balance_key;
                    let balanceName =
                      key[0].toUpperCase() +
                      key
                        .split("_")
                        .join(" ")
                        .split("-")
                        .join(" ")
                        .slice(1, key.length);

                    if (reserveBalances.includes(balanceName)) {
                      let value = balances[i].balance_value.replace(":", " ");
                      i = i + 1;
                      return (
                        <tr class="is-link">
                          <td>{balanceName}</td>
                          <td>
                            <p>{value}</p>
                          </td>
                        </tr>
                      );
                    } else {
                      return null;
                    }
                  })}
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </Fragment>
  );
}
