/* term_curses.c generated by valac 0.56.17, the Vala compiler
 * generated from term_curses.vala, do not modify */

/* Curses terminal

   Copyright (c) 1997-2021 Free Software Foundation, Inc.

   This file is part of GNU Zile.

   GNU Zile is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Zile is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, see <https://www.gnu.org/licenses/>.  */

#include <gee.h>
#include <glib-object.h>
#include <glib.h>
#include <curses.h>
#include <term.h>
#include <stdlib.h>
#include <string.h>

#define FONT_REVERSE 0001
#define FONT_UNDERLINE 0002
#define KBD_CTRL ((Keystroke) 01000)
#define KBD_TAB ((Keystroke) 00402)
#define KBD_RET ((Keystroke) 00403)
#define KBD_META ((Keystroke) 02000)
#define KBD_PGUP ((Keystroke) 00404)
#define KBD_PGDN ((Keystroke) 00405)
#define KBD_HOME ((Keystroke) 00406)
#define KBD_END ((Keystroke) 00407)
#define KBD_DEL ((Keystroke) 00410)
#define KBD_BS ((Keystroke) 00411)
#define KBD_INS ((Keystroke) 00412)
#define KBD_LEFT ((Keystroke) 00413)
#define KBD_RIGHT ((Keystroke) 00414)
#define KBD_UP ((Keystroke) 00415)
#define KBD_DOWN ((Keystroke) 00416)
#define KBD_F1 ((Keystroke) 00420)
#define KBD_F2 ((Keystroke) 00421)
#define KBD_F3 ((Keystroke) 00422)
#define KBD_F4 ((Keystroke) 00423)
#define KBD_F5 ((Keystroke) 00424)
#define KBD_F6 ((Keystroke) 00425)
#define KBD_F7 ((Keystroke) 00426)
#define KBD_F8 ((Keystroke) 00427)
#define KBD_F9 ((Keystroke) 00430)
#define KBD_F10 ((Keystroke) 00431)
#define KBD_F11 ((Keystroke) 00432)
#define KBD_F12 ((Keystroke) 00433)
#define KBD_NOKEY ((Keystroke) G_MAXUINT)
#define GETKEY_DEFAULT -1
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef guint Keystroke;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

VALA_EXTERN GeeList* key_buf;
GeeList* key_buf = NULL;
VALA_EXTERN Keystroke backspace_code;
Keystroke backspace_code = (Keystroke) 0177;

VALA_EXTERN guint term_buf_len (void);
VALA_EXTERN void term_move (gsize y,
                gsize x);
VALA_EXTERN void term_clrtoeol (void);
VALA_EXTERN void term_refresh (void);
VALA_EXTERN void term_clear (void);
VALA_EXTERN void term_addch (gchar c);
VALA_EXTERN void term_addstr (const gchar* s);
VALA_EXTERN void term_attrset (gsize attr);
VALA_EXTERN void term_beep (void);
VALA_EXTERN gsize term_width (void);
VALA_EXTERN gsize term_height (void);
VALA_EXTERN void term_init (void);
VALA_EXTERN void term_close (void);
VALA_EXTERN Keystroke codetokey (guint c);
VALA_EXTERN GeeList* keytocodes (Keystroke key);
VALA_EXTERN guint get_char (gint delay);
VALA_EXTERN void resize_windows (void);
VALA_EXTERN Keystroke term_getkey (gint delay);
VALA_EXTERN guint term_getkey_unfiltered (gint delay);
VALA_EXTERN void term_ungetkey (Keystroke key);

guint
term_buf_len (void)
{
	GeeList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint result;
#line 29 "src/term_curses.vala"
	_tmp0_ = key_buf;
#line 29 "src/term_curses.vala"
	_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
#line 29 "src/term_curses.vala"
	_tmp2_ = _tmp1_;
#line 29 "src/term_curses.vala"
	result = (guint) _tmp2_;
#line 29 "src/term_curses.vala"
	return result;
#line 128 "term_curses.c"
}

void
term_move (gsize y,
           gsize x)
{
#line 33 "src/term_curses.vala"
	move ((gint) y, (gint) x);
#line 137 "term_curses.c"
}

void
term_clrtoeol (void)
{
#line 37 "src/term_curses.vala"
	clrtoeol ();
#line 145 "term_curses.c"
}

void
term_refresh (void)
{
#line 41 "src/term_curses.vala"
	refresh ();
#line 153 "term_curses.c"
}

void
term_clear (void)
{
#line 45 "src/term_curses.vala"
	clear ();
#line 161 "term_curses.c"
}

void
term_addch (gchar c)
{
#line 49 "src/term_curses.vala"
	addch ((gulong) c);
#line 169 "term_curses.c"
}

void
term_addstr (const gchar* s)
{
#line 52 "src/term_curses.vala"
	g_return_if_fail (s != NULL);
#line 53 "src/term_curses.vala"
	addstr (s);
#line 179 "term_curses.c"
}

void
term_attrset (gsize attr)
{
	gint attrs = 0;
#line 57 "src/term_curses.vala"
	attrs = 0;
#line 58 "src/term_curses.vala"
	if ((attr & FONT_REVERSE) != ((gsize) 0)) {
#line 59 "src/term_curses.vala"
		attrs |= (gint) A_REVERSE;
#line 192 "term_curses.c"
	}
#line 60 "src/term_curses.vala"
	if ((attr & FONT_UNDERLINE) != ((gsize) 0)) {
#line 61 "src/term_curses.vala"
		attrs |= (gint) A_UNDERLINE;
#line 198 "term_curses.c"
	}
#line 62 "src/term_curses.vala"
	attrset ((gulong) attrs);
#line 202 "term_curses.c"
}

void
term_beep (void)
{
#line 66 "src/term_curses.vala"
	beep ();
#line 210 "term_curses.c"
}

gsize
term_width (void)
{
	gsize result;
#line 70 "src/term_curses.vala"
	result = (gsize) COLS;
#line 70 "src/term_curses.vala"
	return result;
#line 221 "term_curses.c"
}

gsize
term_height (void)
{
	gsize result;
#line 74 "src/term_curses.vala"
	result = (gsize) LINES;
#line 74 "src/term_curses.vala"
	return result;
#line 232 "term_curses.c"
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
#line 1283 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1284 "glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1284 "glib-2.0.vapi"
	result = _tmp0_;
#line 1284 "glib-2.0.vapi"
	return result;
#line 249 "term_curses.c"
}

void
term_init (void)
{
	WINDOW* _tmp0_;
	WINDOW* _tmp1_;
	WINDOW* _tmp2_;
	GeeArrayList* _tmp3_;
	const gchar* kbs = NULL;
	const gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_;
#line 78 "src/term_curses.vala"
	initscr ();
#line 79 "src/term_curses.vala"
	noecho ();
#line 80 "src/term_curses.vala"
	nonl ();
#line 81 "src/term_curses.vala"
	raw ();
#line 82 "src/term_curses.vala"
	_tmp0_ = stdscr;
#line 82 "src/term_curses.vala"
	meta (_tmp0_, TRUE);
#line 83 "src/term_curses.vala"
	_tmp1_ = stdscr;
#line 83 "src/term_curses.vala"
	intrflush (_tmp1_, FALSE);
#line 84 "src/term_curses.vala"
	_tmp2_ = stdscr;
#line 84 "src/term_curses.vala"
	keypad (_tmp2_, TRUE);
#line 85 "src/term_curses.vala"
	_tmp3_ = gee_array_list_new (G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL);
#line 85 "src/term_curses.vala"
	_g_object_unref0 (key_buf);
#line 85 "src/term_curses.vala"
	key_buf = (GeeList*) _tmp3_;
#line 86 "src/term_curses.vala"
	_tmp4_ = tigetstr ("kbs");
#line 86 "src/term_curses.vala"
	kbs = _tmp4_;
#line 87 "src/term_curses.vala"
	_tmp6_ = kbs;
#line 87 "src/term_curses.vala"
	if (_tmp6_ != NULL) {
#line 297 "term_curses.c"
		const gchar* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
#line 87 "src/term_curses.vala"
		_tmp7_ = kbs;
#line 87 "src/term_curses.vala"
		_tmp8_ = strlen (_tmp7_);
#line 87 "src/term_curses.vala"
		_tmp9_ = _tmp8_;
#line 87 "src/term_curses.vala"
		_tmp5_ = _tmp9_ == 1;
#line 309 "term_curses.c"
	} else {
#line 87 "src/term_curses.vala"
		_tmp5_ = FALSE;
#line 313 "term_curses.c"
	}
#line 87 "src/term_curses.vala"
	if (_tmp5_) {
#line 317 "term_curses.c"
		const gchar* _tmp10_;
#line 88 "src/term_curses.vala"
		_tmp10_ = kbs;
#line 88 "src/term_curses.vala"
		backspace_code = (Keystroke) string_get (_tmp10_, (glong) 0);
#line 323 "term_curses.c"
	}
}

void
term_close (void)
{
#line 93 "src/term_curses.vala"
	endwin ();
#line 332 "term_curses.c"
}

static gint
key_F (gint n)
{
	gint result;
#line 516 "curses.vapi"
	result = (gint) (KEY_F0 + n);
#line 516 "curses.vapi"
	return result;
#line 343 "term_curses.c"
}

Keystroke
codetokey (guint c)
{
	Keystroke result;
#line 97 "src/term_curses.vala"
	switch (c) {
#line 97 "src/term_curses.vala"
		case '\0':
#line 354 "term_curses.c"
		{
#line 99 "src/term_curses.vala"
			result = KBD_CTRL | '@';
#line 99 "src/term_curses.vala"
			return result;
#line 360 "term_curses.c"
		}
#line 97 "src/term_curses.vala"
		case 01:
#line 97 "src/term_curses.vala"
		case 02:
#line 97 "src/term_curses.vala"
		case 03:
#line 97 "src/term_curses.vala"
		case 04:
#line 97 "src/term_curses.vala"
		case 05:
#line 97 "src/term_curses.vala"
		case 06:
#line 97 "src/term_curses.vala"
		case 07:
#line 97 "src/term_curses.vala"
		case 010:
#line 97 "src/term_curses.vala"
		case 012:
#line 97 "src/term_curses.vala"
		case 013:
#line 97 "src/term_curses.vala"
		case 014:
#line 97 "src/term_curses.vala"
		case 016:
#line 97 "src/term_curses.vala"
		case 017:
#line 97 "src/term_curses.vala"
		case 020:
#line 97 "src/term_curses.vala"
		case 021:
#line 97 "src/term_curses.vala"
		case 022:
#line 97 "src/term_curses.vala"
		case 023:
#line 97 "src/term_curses.vala"
		case 024:
#line 97 "src/term_curses.vala"
		case 025:
#line 97 "src/term_curses.vala"
		case 026:
#line 97 "src/term_curses.vala"
		case 027:
#line 97 "src/term_curses.vala"
		case 030:
#line 97 "src/term_curses.vala"
		case 031:
#line 97 "src/term_curses.vala"
		case 032:
#line 410 "term_curses.c"
		{
#line 124 "src/term_curses.vala"
			result = KBD_CTRL | (('a' + c) - 1);
#line 124 "src/term_curses.vala"
			return result;
#line 416 "term_curses.c"
		}
#line 97 "src/term_curses.vala"
		case 011:
#line 420 "term_curses.c"
		{
#line 126 "src/term_curses.vala"
			result = KBD_TAB;
#line 126 "src/term_curses.vala"
			return result;
#line 426 "term_curses.c"
		}
#line 97 "src/term_curses.vala"
		case 015:
#line 430 "term_curses.c"
		{
#line 128 "src/term_curses.vala"
			result = KBD_RET;
#line 128 "src/term_curses.vala"
			return result;
#line 436 "term_curses.c"
		}
#line 97 "src/term_curses.vala"
		case 037:
#line 440 "term_curses.c"
		{
#line 130 "src/term_curses.vala"
			result = KBD_CTRL | '_';
#line 130 "src/term_curses.vala"
			return result;
#line 446 "term_curses.c"
		}
#line 97 "src/term_curses.vala"
		case KEY_SUSPEND:
#line 450 "term_curses.c"
		{
#line 132 "src/term_curses.vala"
			result = KBD_CTRL | 'z';
#line 132 "src/term_curses.vala"
			return result;
#line 456 "term_curses.c"
		}
#line 97 "src/term_curses.vala"
		case 033:
#line 460 "term_curses.c"
		{
#line 134 "src/term_curses.vala"
			result = KBD_META;
#line 134 "src/term_curses.vala"
			return result;
#line 466 "term_curses.c"
		}
#line 97 "src/term_curses.vala"
		case KEY_PPAGE:
#line 470 "term_curses.c"
		{
#line 136 "src/term_curses.vala"
			result = KBD_PGUP;
#line 136 "src/term_curses.vala"
			return result;
#line 476 "term_curses.c"
		}
#line 97 "src/term_curses.vala"
		case KEY_NPAGE:
#line 480 "term_curses.c"
		{
#line 138 "src/term_curses.vala"
			result = KBD_PGDN;
#line 138 "src/term_curses.vala"
			return result;
#line 486 "term_curses.c"
		}
#line 97 "src/term_curses.vala"
		case KEY_HOME:
#line 490 "term_curses.c"
		{
#line 140 "src/term_curses.vala"
			result = KBD_HOME;
#line 140 "src/term_curses.vala"
			return result;
#line 496 "term_curses.c"
		}
#line 97 "src/term_curses.vala"
		case KEY_END:
#line 500 "term_curses.c"
		{
#line 142 "src/term_curses.vala"
			result = KBD_END;
#line 142 "src/term_curses.vala"
			return result;
#line 506 "term_curses.c"
		}
#line 97 "src/term_curses.vala"
		case KEY_DC:
#line 510 "term_curses.c"
		{
#line 144 "src/term_curses.vala"
			result = KBD_DEL;
#line 144 "src/term_curses.vala"
			return result;
#line 516 "term_curses.c"
		}
#line 97 "src/term_curses.vala"
		case KEY_BACKSPACE:
#line 520 "term_curses.c"
		{
#line 146 "src/term_curses.vala"
			result = codetokey ((guint) backspace_code);
#line 146 "src/term_curses.vala"
			return result;
#line 526 "term_curses.c"
		}
#line 97 "src/term_curses.vala"
		case 0177:
#line 530 "term_curses.c"
		{
#line 148 "src/term_curses.vala"
			result = KBD_BS;
#line 148 "src/term_curses.vala"
			return result;
#line 536 "term_curses.c"
		}
#line 97 "src/term_curses.vala"
		case KEY_IC:
#line 540 "term_curses.c"
		{
#line 150 "src/term_curses.vala"
			result = KBD_INS;
#line 150 "src/term_curses.vala"
			return result;
#line 546 "term_curses.c"
		}
#line 97 "src/term_curses.vala"
		case KEY_LEFT:
#line 550 "term_curses.c"
		{
#line 152 "src/term_curses.vala"
			result = KBD_LEFT;
#line 152 "src/term_curses.vala"
			return result;
#line 556 "term_curses.c"
		}
#line 97 "src/term_curses.vala"
		case KEY_RIGHT:
#line 560 "term_curses.c"
		{
#line 154 "src/term_curses.vala"
			result = KBD_RIGHT;
#line 154 "src/term_curses.vala"
			return result;
#line 566 "term_curses.c"
		}
#line 97 "src/term_curses.vala"
		case KEY_UP:
#line 570 "term_curses.c"
		{
#line 156 "src/term_curses.vala"
			result = KBD_UP;
#line 156 "src/term_curses.vala"
			return result;
#line 576 "term_curses.c"
		}
#line 97 "src/term_curses.vala"
		case KEY_DOWN:
#line 580 "term_curses.c"
		{
#line 158 "src/term_curses.vala"
			result = KBD_DOWN;
#line 158 "src/term_curses.vala"
			return result;
#line 586 "term_curses.c"
		}
		default:
		{
#line 160 "src/term_curses.vala"
			if (c == ((guint) key_F (1))) {
#line 161 "src/term_curses.vala"
				result = KBD_F1;
#line 161 "src/term_curses.vala"
				return result;
#line 596 "term_curses.c"
			} else {
#line 162 "src/term_curses.vala"
				if (c == ((guint) key_F (2))) {
#line 163 "src/term_curses.vala"
					result = KBD_F2;
#line 163 "src/term_curses.vala"
					return result;
#line 604 "term_curses.c"
				} else {
#line 164 "src/term_curses.vala"
					if (c == ((guint) key_F (3))) {
#line 165 "src/term_curses.vala"
						result = KBD_F3;
#line 165 "src/term_curses.vala"
						return result;
#line 612 "term_curses.c"
					} else {
#line 166 "src/term_curses.vala"
						if (c == ((guint) key_F (4))) {
#line 167 "src/term_curses.vala"
							result = KBD_F4;
#line 167 "src/term_curses.vala"
							return result;
#line 620 "term_curses.c"
						} else {
#line 168 "src/term_curses.vala"
							if (c == ((guint) key_F (5))) {
#line 169 "src/term_curses.vala"
								result = KBD_F5;
#line 169 "src/term_curses.vala"
								return result;
#line 628 "term_curses.c"
							} else {
#line 170 "src/term_curses.vala"
								if (c == ((guint) key_F (6))) {
#line 171 "src/term_curses.vala"
									result = KBD_F6;
#line 171 "src/term_curses.vala"
									return result;
#line 636 "term_curses.c"
								} else {
#line 172 "src/term_curses.vala"
									if (c == ((guint) key_F (7))) {
#line 173 "src/term_curses.vala"
										result = KBD_F7;
#line 173 "src/term_curses.vala"
										return result;
#line 644 "term_curses.c"
									} else {
#line 174 "src/term_curses.vala"
										if (c == ((guint) key_F (8))) {
#line 175 "src/term_curses.vala"
											result = KBD_F8;
#line 175 "src/term_curses.vala"
											return result;
#line 652 "term_curses.c"
										} else {
#line 176 "src/term_curses.vala"
											if (c == ((guint) key_F (9))) {
#line 177 "src/term_curses.vala"
												result = KBD_F9;
#line 177 "src/term_curses.vala"
												return result;
#line 660 "term_curses.c"
											} else {
#line 178 "src/term_curses.vala"
												if (c == ((guint) key_F (10))) {
#line 179 "src/term_curses.vala"
													result = KBD_F10;
#line 179 "src/term_curses.vala"
													return result;
#line 668 "term_curses.c"
												} else {
#line 180 "src/term_curses.vala"
													if (c == ((guint) key_F (11))) {
#line 181 "src/term_curses.vala"
														result = KBD_F11;
#line 181 "src/term_curses.vala"
														return result;
#line 676 "term_curses.c"
													} else {
#line 182 "src/term_curses.vala"
														if (c == ((guint) key_F (12))) {
#line 183 "src/term_curses.vala"
															result = KBD_F12;
#line 183 "src/term_curses.vala"
															return result;
#line 684 "term_curses.c"
														} else {
#line 184 "src/term_curses.vala"
															if (c > ((guint) 0xff)) {
#line 185 "src/term_curses.vala"
																result = KBD_NOKEY;
#line 185 "src/term_curses.vala"
																return result;
#line 692 "term_curses.c"
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
#line 186 "src/term_curses.vala"
			result = (Keystroke) c;
#line 186 "src/term_curses.vala"
			return result;
#line 710 "term_curses.c"
		}
	}
}

GeeList*
keytocodes (Keystroke key)
{
	GeeArrayList* codevec = NULL;
	GeeArrayList* _tmp0_;
	GeeList* result;
#line 191 "src/term_curses.vala"
	_tmp0_ = gee_array_list_new (G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL);
#line 191 "src/term_curses.vala"
	codevec = _tmp0_;
#line 193 "src/term_curses.vala"
	if (key == KBD_NOKEY) {
#line 194 "src/term_curses.vala"
		result = (GeeList*) codevec;
#line 194 "src/term_curses.vala"
		return result;
#line 731 "term_curses.c"
	}
#line 196 "src/term_curses.vala"
	if ((key & KBD_META) != ((Keystroke) 0)) {
#line 735 "term_curses.c"
		GeeArrayList* _tmp1_;
#line 197 "src/term_curses.vala"
		_tmp1_ = codevec;
#line 197 "src/term_curses.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, (gpointer) ((guintptr) 033));
#line 741 "term_curses.c"
	}
#line 198 "src/term_curses.vala"
	key = key & (~KBD_META);
#line 200 "src/term_curses.vala"
	switch (key) {
#line 200 "src/term_curses.vala"
		case KBD_CTRL | '@':
#line 749 "term_curses.c"
		{
			GeeArrayList* _tmp2_;
#line 202 "src/term_curses.vala"
			_tmp2_ = codevec;
#line 202 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, (gpointer) ((guintptr) '\0'));
#line 203 "src/term_curses.vala"
			break;
#line 758 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_CTRL | 'a':
#line 200 "src/term_curses.vala"
		case KBD_CTRL | 'b':
#line 200 "src/term_curses.vala"
		case KBD_CTRL | 'c':
#line 200 "src/term_curses.vala"
		case KBD_CTRL | 'd':
#line 200 "src/term_curses.vala"
		case KBD_CTRL | 'e':
#line 200 "src/term_curses.vala"
		case KBD_CTRL | 'f':
#line 200 "src/term_curses.vala"
		case KBD_CTRL | 'g':
#line 200 "src/term_curses.vala"
		case KBD_CTRL | 'h':
#line 200 "src/term_curses.vala"
		case KBD_CTRL | 'j':
#line 200 "src/term_curses.vala"
		case KBD_CTRL | 'k':
#line 200 "src/term_curses.vala"
		case KBD_CTRL | 'l':
#line 200 "src/term_curses.vala"
		case KBD_CTRL | 'n':
#line 200 "src/term_curses.vala"
		case KBD_CTRL | 'o':
#line 200 "src/term_curses.vala"
		case KBD_CTRL | 'p':
#line 200 "src/term_curses.vala"
		case KBD_CTRL | 'q':
#line 200 "src/term_curses.vala"
		case KBD_CTRL | 'r':
#line 200 "src/term_curses.vala"
		case KBD_CTRL | 's':
#line 200 "src/term_curses.vala"
		case KBD_CTRL | 't':
#line 200 "src/term_curses.vala"
		case KBD_CTRL | 'u':
#line 200 "src/term_curses.vala"
		case KBD_CTRL | 'v':
#line 200 "src/term_curses.vala"
		case KBD_CTRL | 'w':
#line 200 "src/term_curses.vala"
		case KBD_CTRL | 'x':
#line 200 "src/term_curses.vala"
		case KBD_CTRL | 'y':
#line 200 "src/term_curses.vala"
		case KBD_CTRL | 'z':
#line 808 "term_curses.c"
		{
			GeeArrayList* _tmp3_;
#line 228 "src/term_curses.vala"
			_tmp3_ = codevec;
#line 228 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp3_, (gpointer) ((guintptr) (((key & (~KBD_CTRL)) + 1) - 'a')));
#line 229 "src/term_curses.vala"
			break;
#line 817 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_TAB:
#line 821 "term_curses.c"
		{
			GeeArrayList* _tmp4_;
#line 231 "src/term_curses.vala"
			_tmp4_ = codevec;
#line 231 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, (gpointer) ((guintptr) 011));
#line 232 "src/term_curses.vala"
			break;
#line 830 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_RET:
#line 834 "term_curses.c"
		{
			GeeArrayList* _tmp5_;
#line 234 "src/term_curses.vala"
			_tmp5_ = codevec;
#line 234 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, (gpointer) ((guintptr) 015));
#line 235 "src/term_curses.vala"
			break;
#line 843 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_CTRL | '_':
#line 847 "term_curses.c"
		{
			GeeArrayList* _tmp6_;
#line 237 "src/term_curses.vala"
			_tmp6_ = codevec;
#line 237 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, (gpointer) ((guintptr) 037));
#line 238 "src/term_curses.vala"
			break;
#line 856 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_PGUP:
#line 860 "term_curses.c"
		{
			GeeArrayList* _tmp7_;
#line 240 "src/term_curses.vala"
			_tmp7_ = codevec;
#line 240 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, (gpointer) ((guintptr) KEY_PPAGE));
#line 241 "src/term_curses.vala"
			break;
#line 869 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_PGDN:
#line 873 "term_curses.c"
		{
			GeeArrayList* _tmp8_;
#line 243 "src/term_curses.vala"
			_tmp8_ = codevec;
#line 243 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, (gpointer) ((guintptr) KEY_NPAGE));
#line 244 "src/term_curses.vala"
			break;
#line 882 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_HOME:
#line 886 "term_curses.c"
		{
			GeeArrayList* _tmp9_;
#line 246 "src/term_curses.vala"
			_tmp9_ = codevec;
#line 246 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, (gpointer) ((guintptr) KEY_HOME));
#line 247 "src/term_curses.vala"
			break;
#line 895 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_END:
#line 899 "term_curses.c"
		{
			GeeArrayList* _tmp10_;
#line 249 "src/term_curses.vala"
			_tmp10_ = codevec;
#line 249 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, (gpointer) ((guintptr) KEY_END));
#line 250 "src/term_curses.vala"
			break;
#line 908 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_DEL:
#line 912 "term_curses.c"
		{
			GeeArrayList* _tmp11_;
#line 252 "src/term_curses.vala"
			_tmp11_ = codevec;
#line 252 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, (gpointer) ((guintptr) KEY_DC));
#line 253 "src/term_curses.vala"
			break;
#line 921 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_BS:
#line 925 "term_curses.c"
		{
			GeeArrayList* _tmp12_;
#line 255 "src/term_curses.vala"
			_tmp12_ = codevec;
#line 255 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, (gpointer) ((guintptr) 0177));
#line 256 "src/term_curses.vala"
			break;
#line 934 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_INS:
#line 938 "term_curses.c"
		{
			GeeArrayList* _tmp13_;
#line 258 "src/term_curses.vala"
			_tmp13_ = codevec;
#line 258 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, (gpointer) ((guintptr) KEY_IC));
#line 259 "src/term_curses.vala"
			break;
#line 947 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_LEFT:
#line 951 "term_curses.c"
		{
			GeeArrayList* _tmp14_;
#line 261 "src/term_curses.vala"
			_tmp14_ = codevec;
#line 261 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, (gpointer) ((guintptr) KEY_LEFT));
#line 262 "src/term_curses.vala"
			break;
#line 960 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_RIGHT:
#line 964 "term_curses.c"
		{
			GeeArrayList* _tmp15_;
#line 264 "src/term_curses.vala"
			_tmp15_ = codevec;
#line 264 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, (gpointer) ((guintptr) KEY_RIGHT));
#line 265 "src/term_curses.vala"
			break;
#line 973 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_UP:
#line 977 "term_curses.c"
		{
			GeeArrayList* _tmp16_;
#line 267 "src/term_curses.vala"
			_tmp16_ = codevec;
#line 267 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, (gpointer) ((guintptr) KEY_UP));
#line 268 "src/term_curses.vala"
			break;
#line 986 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_DOWN:
#line 990 "term_curses.c"
		{
			GeeArrayList* _tmp17_;
#line 270 "src/term_curses.vala"
			_tmp17_ = codevec;
#line 270 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, (gpointer) ((guintptr) KEY_DOWN));
#line 271 "src/term_curses.vala"
			break;
#line 999 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_F1:
#line 1003 "term_curses.c"
		{
			GeeArrayList* _tmp18_;
#line 273 "src/term_curses.vala"
			_tmp18_ = codevec;
#line 273 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, (gpointer) ((guintptr) key_F (1)));
#line 274 "src/term_curses.vala"
			break;
#line 1012 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_F2:
#line 1016 "term_curses.c"
		{
			GeeArrayList* _tmp19_;
#line 276 "src/term_curses.vala"
			_tmp19_ = codevec;
#line 276 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, (gpointer) ((guintptr) key_F (2)));
#line 277 "src/term_curses.vala"
			break;
#line 1025 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_F3:
#line 1029 "term_curses.c"
		{
			GeeArrayList* _tmp20_;
#line 279 "src/term_curses.vala"
			_tmp20_ = codevec;
#line 279 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, (gpointer) ((guintptr) key_F (3)));
#line 280 "src/term_curses.vala"
			break;
#line 1038 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_F4:
#line 1042 "term_curses.c"
		{
			GeeArrayList* _tmp21_;
#line 282 "src/term_curses.vala"
			_tmp21_ = codevec;
#line 282 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, (gpointer) ((guintptr) key_F (4)));
#line 283 "src/term_curses.vala"
			break;
#line 1051 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_F5:
#line 1055 "term_curses.c"
		{
			GeeArrayList* _tmp22_;
#line 285 "src/term_curses.vala"
			_tmp22_ = codevec;
#line 285 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, (gpointer) ((guintptr) key_F (5)));
#line 286 "src/term_curses.vala"
			break;
#line 1064 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_F6:
#line 1068 "term_curses.c"
		{
			GeeArrayList* _tmp23_;
#line 288 "src/term_curses.vala"
			_tmp23_ = codevec;
#line 288 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp23_, (gpointer) ((guintptr) key_F (6)));
#line 289 "src/term_curses.vala"
			break;
#line 1077 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_F7:
#line 1081 "term_curses.c"
		{
			GeeArrayList* _tmp24_;
#line 291 "src/term_curses.vala"
			_tmp24_ = codevec;
#line 291 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp24_, (gpointer) ((guintptr) key_F (7)));
#line 292 "src/term_curses.vala"
			break;
#line 1090 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_F8:
#line 1094 "term_curses.c"
		{
			GeeArrayList* _tmp25_;
#line 294 "src/term_curses.vala"
			_tmp25_ = codevec;
#line 294 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp25_, (gpointer) ((guintptr) key_F (8)));
#line 295 "src/term_curses.vala"
			break;
#line 1103 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_F9:
#line 1107 "term_curses.c"
		{
			GeeArrayList* _tmp26_;
#line 297 "src/term_curses.vala"
			_tmp26_ = codevec;
#line 297 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp26_, (gpointer) ((guintptr) key_F (9)));
#line 298 "src/term_curses.vala"
			break;
#line 1116 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_F10:
#line 1120 "term_curses.c"
		{
			GeeArrayList* _tmp27_;
#line 300 "src/term_curses.vala"
			_tmp27_ = codevec;
#line 300 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp27_, (gpointer) ((guintptr) key_F (10)));
#line 301 "src/term_curses.vala"
			break;
#line 1129 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_F11:
#line 1133 "term_curses.c"
		{
			GeeArrayList* _tmp28_;
#line 303 "src/term_curses.vala"
			_tmp28_ = codevec;
#line 303 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp28_, (gpointer) ((guintptr) key_F (11)));
#line 304 "src/term_curses.vala"
			break;
#line 1142 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_F12:
#line 1146 "term_curses.c"
		{
			GeeArrayList* _tmp29_;
#line 306 "src/term_curses.vala"
			_tmp29_ = codevec;
#line 306 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp29_, (gpointer) ((guintptr) key_F (12)));
#line 307 "src/term_curses.vala"
			break;
#line 1155 "term_curses.c"
		}
		default:
		{
#line 309 "src/term_curses.vala"
			if ((key & 0xff) == key) {
#line 1161 "term_curses.c"
				GeeArrayList* _tmp30_;
#line 310 "src/term_curses.vala"
				_tmp30_ = codevec;
#line 310 "src/term_curses.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp30_, (gpointer) ((guintptr) key));
#line 1167 "term_curses.c"
			}
#line 311 "src/term_curses.vala"
			break;
#line 1171 "term_curses.c"
		}
	}
#line 314 "src/term_curses.vala"
	result = (GeeList*) codevec;
#line 314 "src/term_curses.vala"
	return result;
#line 1178 "term_curses.c"
}

guint
get_char (gint delay)
{
	guint c = 0U;
	guint size = 0U;
	guint result;
#line 318 "src/term_curses.vala"
	c = (guint) 0;
#line 320 "src/term_curses.vala"
	size = term_buf_len ();
#line 321 "src/term_curses.vala"
	if (size > ((guint) 0)) {
#line 1193 "term_curses.c"
		GeeList* _tmp0_;
		gpointer _tmp1_;
		GeeList* _tmp2_;
#line 322 "src/term_curses.vala"
		_tmp0_ = key_buf;
#line 322 "src/term_curses.vala"
		_tmp1_ = gee_list_get (_tmp0_, ((gint) size) - 1);
#line 322 "src/term_curses.vala"
		c = (guint) ((Keystroke) ((guintptr) _tmp1_));
#line 323 "src/term_curses.vala"
		_tmp2_ = key_buf;
#line 323 "src/term_curses.vala"
		gee_list_remove_at (_tmp2_, ((gint) size) - 1);
#line 1207 "term_curses.c"
	} else {
#line 325 "src/term_curses.vala"
		timeout (delay);
#line 1211 "term_curses.c"
		{
			gboolean _tmp3_ = FALSE;
#line 327 "src/term_curses.vala"
			_tmp3_ = TRUE;
#line 327 "src/term_curses.vala"
			while (TRUE) {
#line 327 "src/term_curses.vala"
				if (!_tmp3_) {
#line 332 "src/term_curses.vala"
					if (!(c == ((guint) KEY_RESIZE))) {
#line 332 "src/term_curses.vala"
						break;
#line 1224 "term_curses.c"
					}
				}
#line 327 "src/term_curses.vala"
				_tmp3_ = FALSE;
#line 328 "src/term_curses.vala"
				c = (guint) getch ();
#line 330 "src/term_curses.vala"
				if (c == ((guint) KEY_RESIZE)) {
#line 331 "src/term_curses.vala"
					resize_windows ();
#line 1235 "term_curses.c"
				}
			}
		}
	}
#line 335 "src/term_curses.vala"
	result = c;
#line 335 "src/term_curses.vala"
	return result;
#line 1244 "term_curses.c"
}

Keystroke
term_getkey (gint delay)
{
	Keystroke key = 0U;
	Keystroke result;
#line 339 "src/term_curses.vala"
	key = codetokey (get_char (delay));
#line 340 "src/term_curses.vala"
	while (TRUE) {
#line 340 "src/term_curses.vala"
		if (!(key == KBD_META)) {
#line 340 "src/term_curses.vala"
			break;
#line 1260 "term_curses.c"
		}
#line 341 "src/term_curses.vala"
		key = codetokey (get_char (GETKEY_DEFAULT)) | KBD_META;
#line 1264 "term_curses.c"
	}
#line 342 "src/term_curses.vala"
	result = key;
#line 342 "src/term_curses.vala"
	return result;
#line 1270 "term_curses.c"
}

guint
term_getkey_unfiltered (gint delay)
{
	WINDOW* _tmp0_;
	guint key = 0U;
	WINDOW* _tmp1_;
	guint result;
#line 346 "src/term_curses.vala"
	_tmp0_ = stdscr;
#line 346 "src/term_curses.vala"
	keypad (_tmp0_, FALSE);
#line 347 "src/term_curses.vala"
	key = get_char (delay);
#line 348 "src/term_curses.vala"
	_tmp1_ = stdscr;
#line 348 "src/term_curses.vala"
	keypad (_tmp1_, TRUE);
#line 349 "src/term_curses.vala"
	result = key;
#line 349 "src/term_curses.vala"
	return result;
#line 1294 "term_curses.c"
}

void
term_ungetkey (Keystroke key)
{
	GeeList* codes = NULL;
	GeeList* _tmp0_;
#line 353 "src/term_curses.vala"
	_tmp0_ = keytocodes (key);
#line 353 "src/term_curses.vala"
	codes = _tmp0_;
#line 1306 "term_curses.c"
	{
		gint i = 0;
		GeeList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
#line 354 "src/term_curses.vala"
		_tmp1_ = codes;
#line 354 "src/term_curses.vala"
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
#line 354 "src/term_curses.vala"
		_tmp3_ = _tmp2_;
#line 354 "src/term_curses.vala"
		i = _tmp3_;
#line 1320 "term_curses.c"
		{
			gboolean _tmp4_ = FALSE;
#line 354 "src/term_curses.vala"
			_tmp4_ = TRUE;
#line 354 "src/term_curses.vala"
			while (TRUE) {
#line 1327 "term_curses.c"
				GeeList* _tmp6_;
				GeeList* _tmp7_;
				gpointer _tmp8_;
#line 354 "src/term_curses.vala"
				if (!_tmp4_) {
#line 1333 "term_curses.c"
					gint _tmp5_;
#line 354 "src/term_curses.vala"
					_tmp5_ = i;
#line 354 "src/term_curses.vala"
					i = _tmp5_ - 1;
#line 1339 "term_curses.c"
				}
#line 354 "src/term_curses.vala"
				_tmp4_ = FALSE;
#line 354 "src/term_curses.vala"
				if (!(i > 0)) {
#line 354 "src/term_curses.vala"
					break;
#line 1347 "term_curses.c"
				}
#line 355 "src/term_curses.vala"
				_tmp6_ = key_buf;
#line 355 "src/term_curses.vala"
				_tmp7_ = codes;
#line 355 "src/term_curses.vala"
				_tmp8_ = gee_list_get (_tmp7_, i - 1);
#line 355 "src/term_curses.vala"
				gee_collection_add ((GeeCollection*) _tmp6_, (gpointer) ((guintptr) _tmp8_));
#line 1357 "term_curses.c"
			}
		}
	}
#line 352 "src/term_curses.vala"
	_g_object_unref0 (codes);
#line 1363 "term_curses.c"
}

