/* Header file for Gabriel client piece.
 */


/* LITERALS */
/* These would be useful if C had stronger type checking. */
#ifndef Obj
#define Obj	void *
#endif
#ifndef List
#define List	void *
#endif
#define List_NULLP     ((List) 0)
#ifndef bool
#define bool	int
#endif
#ifndef True
#define True	1
#define False	0
#endif
#ifndef NULL
#define NULL	0
#endif


#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN	256
#endif


#define LINEBUF_SIZE	(4096)

/* Check the database every 60 seconds. */
#define CHECK_INTERVAL	(60)

/* Report ongoing attacks every 15 minutes. */
#define REPORT_INTERVAL	(15 * 60)

/* Remove host and probe records if they have been inactive */
/* for this many seconds. */
/* An attack is recognized if a source host exceeds the threholds */
/* within this many seconds. */
#define INACTIVE_INTERVAL	(5 * 60)

/* Send a heartbeat record after this many seconds. */
#define HEARTBEAT_INTERVAL	(5 * 60)

/* Thresholds for excessive probing */
#define	HIGH_THRESHOLD	(15)
#define	LOW_THRESHOLD	(9)

/* Syslog parameters. */
#define	GABRIEL_IDENT		"gabriel"
#define	GABRIEL_LOG_OPTS	(LOG_NOWAIT)
#define	GABRIEL_FACILITY	(LOG_LOCAL3)


/* Packet monitor arguments should select these packet types:
 * All tcp connection requests
 * - includes ftp-data streams
 * - includes x-window streams
 * All icmp echo requests
 * Destination port scanning
 */

/* Arguments to the solaris 1 packet monitor.
 */
#define SOL1_POPEN_ARG \
"/usr/etc/etherfind  2>&1 -v -u \
   -ip -proto tcp  byte 47=2 \
or -ip -proto icmp byte 34=8 \
or -ip dstport sunrpc \
or -ip dstport 1 \
or -ip dstport 10 \
or -ip dstport 100 \
or -ip dstport 1000 \
or -ip dstport 5000 \
or -ip dstport 10000 \
or -ip dstport 20000 \
or -ip dstport 30000 \
"

/* Arguments to the solaris 2 packet monitor.
 */
#define SOL2_POPEN_ARG \
"/usr/sbin/snoop 2>&1 \
   ip tcp  tcp[13] = 2 \
or ip icmp icmp[0] = 8 \
or ip dst port sunrpc \
or ip dst port 1000 \
or ip dst port 5000 \
"
/* These seem to make the snoop program terminate frequently.
or ip dst port 10 \
or ip dst port 100 \
or ip dst port 10000 \
or ip dst port 20000 \
or ip dst port 30000 \
*/

/* Ignore Solaris 1 pkts line that do not start with
 * one of these words.
 */
#define SOL1_START1	"TCP"
#define SOL1_START2	"UDP"
#define SOL1_START3	"ICMP"

/* Ignore Solaris 2 pkt lines that do not include this string.
 */
#define SOL2_PATTERN	" -> "

#define SERVICE_PING	"PING"

extern	time_t	last_check_time;
extern	time_t	last_heartbeat_time;
