;
; Convert to PS16 - CTOP16 v1.0
;
; Written by Joshua C. Jensen                              Last update: 04/27/93
;
; For those of you who wanted to know the file format in advance, here it is.
; Please, please, do not change and redistribute this code.  The drivers are
; more or less done.  I'll be releasing them in a few days.
;

                ideal
                P286
                model   Small
                jumps

include "music.inc"

segment MyCode

		assume	cs:MyCode,ds:MyData

include         "modload.asm"


; LoadCommandLine - Pulls the MOD and PS16 filename from the command line.
;   Out: Carry set if error.

proc            LoadCommandLine near
                ;  Setup the segment and offset.
                mov     ax, MyData
                mov     es, ax
                mov     ds, [cs:PspAddress]
                mov     si, 128
		cld

                ;  Get the length in AL.
                lodsb
                or      al, al
		je	@@noargv

@@MoreThanOne:  ;  Setup the end offset in BX.
                mov     bx, si
                inc     bx
                xor     ah, ah
                add     bx, ax

@@TopLoop:      ;  If we make it to the end, then something was wrong.
                cmp     bx, si
		je	@@noargv

                ;  Kill leading spaces.
                lodsb
                cmp     al, ' '
		je	@@TopLoop

                ;  We are at the input filename now.
                dec     si              ; Go back to pick up the character again.
                mov     di, offset ModInput
                mov     cx, 80
@@TopGet:       ;  If we reach the end, then something is wrong.
                cmp     bx, si          ; If we reach the end, then something
                je      @@noargv
                lodsb                   ; Pick up a character.
                stosb
                cmp     al,13           ; Something is wrong.
                je      @@noargv
                cmp     al,'.'          ; If it is a period, then don't store
                jne     @@NotPeriod     ;   .MOD extension.
                mov     ah,1            ; Set "." flag.
@@NotPeriod:    cmp     al,' '          ; If it is a space
                je      @@DoSpace1
                loop    @@TopGet
@@DoSpace1:     dec     di
@@StoreMod:     or      ah,ah
		jne	@@JustZero
                mov     [Byte es:di],'.'
                mov     [Byte es:di+1],'M'
                mov     [Byte es:di+2],'O'
                mov     [Byte es:di+3],'D'
                add     di,4
@@JustZero:     mov     [Byte es:di],0

@@SpLoop2:      ;  If we make it to the end, then something was wrong.
                cmp     bx, si
		je	@@noargv

                ;  Kill leading spaces.
                lodsb
                cmp     al, ' '
                je      @@SpLoop2

                ;  We are at the output filename now.
                dec     si              ; Go back to pick up the character again.
                mov     di, offset PS16Output
                mov     cx, 80
                xor     ah,ah
@@TopPS16:      ;  If we reach the end, then something is wrong.
                cmp     bx, si          ; If we reach the end, then something
                je      @@noargv
                lodsb                   ; Pick up a character.
                cmp     al,13           ; Something is wrong.
                je      @@StorePS16
                cmp     al,'.'          ; If it is a period, then don't store
                jne     @@NotPeriod2    ;   .P16 extension.
                mov     ah,1            ; Set "." flag.
@@NotPeriod2:   stosb
                loop    @@TopPS16
@@StorePS16:    or      ah,ah
                jne     @@JustZero2
                mov     [Byte es:di],'.'
                mov     [Byte es:di+1],'P'
                mov     [Byte es:di+2],'1'
                mov     [Byte es:di+3],'6'
                add     di,4
@@JustZero2:    mov     [Byte es:di],0
                clc
		ret
@@noargv:	stc
		ret
endp		LoadCommandLine

proc            Error near
                mov     ax,MyData
		mov	ds,ax
		mov	ah,9
                int     21h
		mov	ax,4C00h
		int	21h
endp            Error

PspAddress	dw	?
SizeOfProg      dw      ?
TopOfData	dw	?
proc		Main
Start:          cli
                mov     ax,stackseg
                mov     ss,ax
                mov     sp,offset EndOfStack
                sti
                mov     [cs:PspAddress],es
                mov     ax,zzzzzseg
                inc     ax
                mov     [cs:TopOfData],ax

                call    LoadCommandLine
                mov     cx,seg ModInput
                mov     dx,offset ModInput
                mov     bx,seg PS16Output
                mov     si,offset PS16Output
                mov     ax,[cs:TopOfData]
                call    MOD_Convert

@@Exit:         mov     ax,4C00h
                int     21h
endp		Main

ends		MyCode

segment         MyData
ModInput        db      80 dup (?)
PS16Output      db      80 dup (?)
ends            MyData

segment         stackseg
                db      511 dup (?)
EndOfStack      db      ?
ends            stackseg

segment zzzzzseg
	db	16 dup (?)
ends	zzzzzseg

        end     Start


