/*
 * This file has been modified as part of the FreeMiNT project. See
 * the file Changes.MH for details and dates.
 */

# ifndef _dosdir_h
# define _dosdir_h

# ifdef __TURBOC__
# include "include\mint.h"
# else
# include "include/mint.h"
# endif


long ARGS_ON_STACK d_setdrv (int d);
long ARGS_ON_STACK d_getdrv (void);
long ARGS_ON_STACK d_free (long *buf, int d);
long ARGS_ON_STACK d_create (const char *path);
long ARGS_ON_STACK d_delete (const char *path);
long ARGS_ON_STACK d_setpath (const char *path);
long ARGS_ON_STACK d_getpath (char *path, int drv);
long ARGS_ON_STACK d_getcwd (char *path, int drv, int size);
long ARGS_ON_STACK f_setdta (DTABUF *dta);
long ARGS_ON_STACK f_getdta (void);
long ARGS_ON_STACK f_sfirst (const char *path, int attrib);
long ARGS_ON_STACK f_snext (void);
long ARGS_ON_STACK f_attrib (const char *name, int rwflag, int attr);
long ARGS_ON_STACK f_delete (const char *name);
long ARGS_ON_STACK f_rename (int junk, const char *old, const char *new);
long ARGS_ON_STACK d_pathconf (const char *name, int which);
long ARGS_ON_STACK d_opendir (const char *path, int flags);
long ARGS_ON_STACK d_readdir (int len, long handle, char *buf);
long ARGS_ON_STACK d_xreaddir (int len, long handle, char *buf, XATTR *xattr, long *xret);
long ARGS_ON_STACK d_rewind (long handle);
long ARGS_ON_STACK d_closedir (long handle);
long ARGS_ON_STACK f_xattr (int flag, const char *name, XATTR *xattr);
long ARGS_ON_STACK f_link (const char *old, const char *new);
long ARGS_ON_STACK f_symlink (const char *old, const char *new);
long ARGS_ON_STACK f_readlink (int buflen, char *buf, const char *linkfile);
long ARGS_ON_STACK d_cntl (int cmd, const char *name, long arg);
long ARGS_ON_STACK f_chown (const char *name, int uid, int gid);
long ARGS_ON_STACK f_chmod (const char *name, unsigned mode);
long ARGS_ON_STACK d_lock (int mode, int drv);
long ARGS_ON_STACK d_readlabel (const char *path, char *label, int maxlen);
long ARGS_ON_STACK d_writelabel (const char *path, const char *label);

# endif /* _dosdir_h */
