/*
 * This file has been modified as part of the FreeMiNT project. See
 * the file Changes.MH for details and dates.
 */

# ifndef _filesys_h
# define _filesys_h

# ifdef __TURBOC__
# include "include\mint.h"
# else
# include "include/mint.h"
# endif


/* exported functions */
void kill_cache (fcookie *dir, char *name);
long cache_lookup (fcookie *dir, char *name, fcookie *res);
void cache_init (void);
void clobber_cookie (fcookie *fc);
void init_drive (int drv);
void init_filesys (void);
void load_filesys (void);
void load_devdriver (void);
void close_filesys (void);
long ARGS_ON_STACK s_ync (void);
void ARGS_ON_STACK changedrv (unsigned drv);
int disk_changed (int drv);
long relpath2cookie (fcookie *dir, const char *path, char *lastnm, fcookie *res, int depth);
long path2cookie (const char *path, char *lastname, fcookie *res);
void release_cookie (fcookie *fc);
void dup_cookie (fcookie *new, fcookie *old);
FILEPTR *new_fileptr (void);
void dispose_fileptr (FILEPTR *f);
int ARGS_ON_STACK denyshare (FILEPTR *list, FILEPTR *newfileptr);
int ngroupmatch (int group);
int denyaccess (XATTR *, unsigned);
LOCK * ARGS_ON_STACK denylock (LOCK *list, LOCK *newlock);
long dir_access (fcookie *, unsigned, unsigned *);
int has_wild (const char *name);
void copy8_3 (char *dest, const char *src);
int pat_match (const char *name, const char *template);
int samefile (fcookie *, fcookie *);

# endif /* _filesys_h */
