/*
 * This file has been modified as part of the FreeMiNT project. See
 * the file Changes.MH for details and dates.
 */

/*
 * Copyright 1991,1992 Eric R. Smith.
 * Copyright 1992,1993,1994 Atari Corporation.
 * All rights reserved.
 */

# ifndef _ASSERT_H
# define _ASSERT_H


# ifdef NDEBUG
# define assert(expression)
# else
# ifdef __STDC__
# define assert(expression)						\
	((expression) ? (void) 0 :					\
		FATAL ("assert (`%s') failed at line %ld of %s.",	\
			#expression, (long) __LINE__, __FILE__))
# else
# define assert(expression)						\
	if (expression)							\
		FATAL("assert (%s) failed", "expression")
# endif /* __STDC__ */
# endif /* NDEBUG */


# endif /* _ASSERT_H */
