/*
 * This file has been modified as part of the FreeMiNT project. See
 * the file Changes.MH for details and dates.
 */

/*
 * Copyright 1991,1992 Eric R. Smith.
 * Copyright 1992,1993,1994 Atari Corporation.
 * All rights reserved.
 */

# ifndef _DEBUG_H
# define _DEBUG_H

# include <stdarg.h>
# ifdef __TURBOC__
# include "include\mint.h"
# else
# include "mint.h"
# endif


extern int debug_level;		/* in debug.c */
extern int debug_logging;	/* in debug.c */

/*
 * Extra terse settings - don't even output ALERTs unless asked to.
 *
 * Things that happen in on an idle Desktop are at LOW_LEVEL:
 * Psemaphore, Pmsg, Syield.
 */

# define FORCE_LEVEL	0
# define ALERT_LEVEL	1
# define DEBUG_LEVEL	2
# define TRACE_LEVEL	3
# define LOW_LEVEL	4


# ifndef DEBUG_INFO

# define TRACELOW(x)
# define TRACE(x)
# define DEBUG(x)

# else                         

# define TRACELOW(s)	\
	do { if ((debug_level >=   LOW_LEVEL) || debug_logging) Tracelow s ; } while (0)
# define TRACE(s)	\
	do { if ((debug_level >= TRACE_LEVEL) || debug_logging) Trace s ;    } while (0)
# define DEBUG(s)	\
	do { if ((debug_level >= DEBUG_LEVEL) || debug_logging) Debug s ;    } while (0)

# endif /* DEBUG_INFO */


int vksprintf (char *buf, const char *fmt, va_list args);
int ARGS_ON_STACK ksprintf (char *, const char *, ...);
void debug_ws (const char *s);
int _ALERT (char *);
void ARGS_ON_STACK Tracelow (const char *s, ...);
void ARGS_ON_STACK Trace (const char *s, ...);
void ARGS_ON_STACK Debug (const char *s, ...);
void ARGS_ON_STACK ALERT (const char *s, ...);
void ARGS_ON_STACK FORCE (const char *s, ...);
void PAUSE (void);
EXITING ARGS_ON_STACK FATAL (const char *s, ...) NORETURN;
EXITING halt (void) NORETURN;
EXITING HALT (void) NORETURN;
void DUMPLOG (void);
void do_func_key (int);

# endif /* _DEBUG_H */
