/*
 * This file has been modified as part of the FreeMiNT project. See
 * the file Changes.MH for details and dates.
 */

/*
 * Copyright 1990,1991,1992 Eric R. Smith.
 * Copyright 1992,1993,1994 Atari Corporation.
 * All rights reserved.
 */

# ifndef _MINT_H
# define _MINT_H

# ifdef __KERNEL__
# undef __KERNEL__
# endif
# define __KERNEL__ 1

# ifndef GENMAGIC
/*
 * use our own library for the kernel:
 * -> strongly recommended
 */
# define OWN_LIB
# endif

# include <osbind.h>


/*
 * configuration options
 */

/*
 * undefine VM_EXTENSION if DCPU030 is not defined
 */
# ifndef DCPU030
# undef VM_EXTENSION
# endif

/*
 * make real processor exceptions (bus error, etc.) raise a signal
 */
# define EXCEPTION_SIGS

/*
 * deliberately fill memory with junk when allocating: used for testing
 */
# undef JUNK_MEM

/*
 * use the file cookie cache: currently discouraged
 */
# undef FCOOKIE_CACHE

/*
 * Fcreate() on pipes should not fail
 */
# define CREATE_PIPES

/*
 * try to gather the MiNT executable's name from the parent's DTA
 */
# define AUTO_FIX

/*
 * define if you want a daemon process for sync'ing (otherwise uses timeout)
 */
# undef SYSUPDATE_DAEMON

/*
 * use GEMDOS FS instead of real FAT XFS
 */
# define OLDTOSFS

/*
 * other options best set in the makefile
 */
# if 0
# define MULTITOS	/* make a MultiTOS kernel */
# define ONLY030	/* make a 68030 only version */
# define DIRSEP_SLASH	/* make forward slash a path separator in kernel filesystems */
# endif

# ifndef MULTITOS
# define FASTTEXT	/* include the u:\dev\fasttext device */
# endif

/* ST_ESCC provides additional (TT-like) MODEM2 and SERIAL2 devices for
 * ST-based hardware. Hard- and Software copyright by Harun Scheutzow 
 */
# ifdef ST_ESCC
# define ControlRegA	0xfffffa35L
# define DataRegA	0xfffffa37L
# define ControlRegB	0xfffffa31L
# define DataRegB	0xfffffa33L
# else
/* default (TT) values */
# define ControlRegA	0xffff8c81L
# define DataRegA	0xffff8c83L
# define ControlRegB	0xffff8c85L
# define DataRegB	0xffff8c87L
# endif

/* PATH_MAX is the maximum path allowed. The kernel uses this in lots of
 * places, so there isn't much point in file systems allowing longer
 * paths (they can restrict paths to being shorter if they want).
 * (This is slowly changing, actually... fewer and fewer places use
 *  PATH_MAX, and eventually we should get rid of it)
 */
# define PATH_MAX 128

/* maximum length of a string passed to ksprintf: this should be
 * no more than PATH_MAX
 */
# define SPRINTF_MAX PATH_MAX

/* NOTE: NAME_MAX is a "suggested" maximum name length only. Individual
 * file systems may choose a longer or shorter NAME_MAX, so do _not_
 * use this in the kernel for anything!
 */
# define NAME_MAX 14


# ifdef __TURBOC__
/*
 * For Turbo C/Pure C, the current directory is the one of the .c file!
 */
# ifdef OWN_LIB
#  include "include\kctype.h"
# else
#  include <ctype.h>
#  include <string.h>
# endif

# include "include\misc.h"
# include "include\default.h"
# include "include\fstring.h"
# include "include\atarierr.h"
# include "include\basepage.h"
# include "include\types.h"
# include "include\signals.h"
# include "include\mem.h"
# include "include\file.h"
# include "include\proc.h"
# include "include\xbra.h"
# include "include\debug.h"

# ifndef GENMAGIC
# include "include\assert.h"
# include "include\sproto.h"
/*
 * load some inline functions, perhaps
 */
# include "include\inline.h"
# endif /* GENMAGIC */

# else /* !__TURBOC__ */

# ifdef OWN_LIB
#  include "kctype.h"
# else
#  include <ctype.h>
#  include <string.h>
# endif

# include "misc.h"
# include "default.h"
# include "fstring.h"
# include "atarierr.h"
# include "basepage.h"
# include "types.h"
# include "signals.h"
# include "mem.h"
# include "file.h"
# include "proc.h"
# include "xbra.h"
# include "debug.h"

# ifndef GENMAGIC
# include "assert.h"
# include "sproto.h"
/*
 * load some inline functions, perhaps
 */
# include "inline.h"
# endif /* GENMAGIC */

# endif /* __TURBOC__ */


# ifndef offsetof
# include <stddef.h>
# endif

# ifndef NULL
# define NULL ((void *)0)
# endif

# ifndef TRUE
# define TRUE 1
# define FALSE 0
# endif

/*
 * is debugging info included?
 */
# ifndef MULTITOS
#  ifndef DEBUG_INFO
#   define DEBUG_INFO
#  endif
# endif

# define check_addr(x) 0
# define yield() sleep(READY_Q, 0L)

# define CTRL(x) ((x) & 0x1f)


# ifndef GENMAGIC

extern ushort timestamp, datestamp;	/* in time.c */

typedef struct kbdvbase
{
	long	midivec;
	long	vkbderr;
	long	vmiderr;
	long	statvec;
	long	mousevec;
	long	clockvec;
	long	joyvec;
	long	midisys;
	long	ikbdsys;
	short	drvstat;	/* Non-zero if a packet is currently transmitted. */
	
} KBDVEC;

extern KBDVEC *syskey;

# define ST		0
# define STE		0x00010000L
# define MEGASTE	0x00010010L
# define TT		0x00020000L
# define FALCON		0x00030000L

extern long mch;

extern int has_bconmap;	/* set in main() */
extern int curbconmap;  /* see xbios.c */

# define MAXLANG 6	/* languages supported */
extern int gl_lang;	/* set in main.c */

# endif /* GENMAGIC */


# endif /* _MINT_H */
