/*
 * This file belongs to FreeMiNT.  It's not in the original MiNT 1.12
 * distribution.  See the file Changes.MH for a detailed log of changes.
 */

/*
 * Copyright (C) 1998 by Guido Flohr.
 */

# ifndef _time_h
# define _time_h

# define CLOCKS_PER_SEC 200L

struct timeval
{
	long int	tv_sec;		/* seconds */
	long int	tv_usec;	/* microseconds */
};

struct timezone
{
	long int	tz_minuteswest;	/* minutes west of Greenwich */
	long int	tz_dsttime;	/* type of dst correction */
};

# ifdef __KERNEL__

/* Global variables exported into the kernel. */
extern struct timeval xtime;            /* Current kernel time (UTC). */
extern struct timezone sys_tz;		/* Timezone for T[gs]ettimeofday. */
extern long int clock_mode;		/* Non-zero if clock is ticking in
                                         * local time instead of UTC
                                         * (read-only).
                                         */

/* Used by filesystems and the kernel, updated once per second.  */
extern ushort timestamp;		/* Local time in TOS format. */
extern ushort datestamp;		/* Local date in TOS format. */

extern void init_time P_((void));       /* Initialize date/time stuff. */
extern void synch_timers P_((void));    /* Synchronize all os timers. */
extern void warp_clock P_((int mode));  /* Change the kernel's notion of
                                         * the time provided by the 
                                         * hardware clock according to
                                         * MODE.
                                         */
                                   
extern long ARGS_ON_STACK do_gettimeofday P_((struct timeval* tv));
extern long ARGS_ON_STACK do_settimeofday P_((struct timeval* tv));

/* GEMDOS. */
long ARGS_ON_STACK t_getdate P_ ((void));
long ARGS_ON_STACK t_setdate P_ ((ushort date));
long ARGS_ON_STACK t_gettime P_ ((void));
long ARGS_ON_STACK t_settime P_ ((ushort time));

/* New GEMDOS extensions. */
extern long ARGS_ON_STACK t_gettimeofday P_((struct timeval* tv, struct timezone* tz));
extern long ARGS_ON_STACK t_settimeofday P_((struct timeval* tv, struct timezone* tz));

/* XBIOS. */
extern long ARGS_ON_STACK gettime P_((void));
extern void ARGS_ON_STACK settime P_((ulong datetime));

# endif

# define ITIMER_REAL 0
# define ITIMER_VIRTUAL 1
# define ITIMER_PROF 2

# endif /* _time_h */
