/*
 * This file has been modified as part of the FreeMiNT project. See
 * the file Changes.MH for details and dates.
 */

# ifndef _util_h
# define _util_h

# ifdef __TURBOC__
# include "include\mint.h"
# else
# include "include/mint.h"
# endif


MEMREGION *	addr2mem	(virtaddr a);
PROC *		pid2proc	(int pid);
int		newpid		(void);
int		set_pid_1	(void);
void		zero		(char *place, long size);
# ifdef JUNK_MEM
void		fillwjunk	(long *place, long size)
# endif

void	ARGS_ON_STACK ms_time	(ulong ms, short *timeptr);
long	ARGS_ON_STACK unixtim	(ushort time, ushort date);
long	ARGS_ON_STACK dostim	(long time);

int	ARGS_ON_STACK strnicmp	(const char *str1, const char *str2, int len);
int	ARGS_ON_STACK stricmp	(const char *str1, const char *str2);
char *	ARGS_ON_STACK strlwr	(char *s);
char *	ARGS_ON_STACK strupr	(char *s);

# ifdef OWN_LIB
int	strncmp	(const char *str1, const char *str2, int len);
int	strcmp	(const char *str1, const char *str2);
char *	strcat	(char *, const char *);
char *	strcpy	(char *, const char *);
char *	strncpy	(char *, const char *, int);
int	strlen	(const char *);
char *	strrchr	(const char *, int);
int	tolower	(int);
int	toupper	(int);
long	atol	(const char *);
# endif /* OWN_LIB */

# endif /* _util_h */
