/*
 * This file belongs to FreeMiNT.  It's not in the original MiNT 1.12
 * distribution.  See the file Changes.MH for a detailed log of changes.
 */

/*
 * This file is dedicated to the FreeMiNT project.
 * It's not allowed to use this file on other projects without my explicit
 * permission.
 */

/*
 * begin:	1998-02
 * last change: 1998-06-24
 * 
 * Author: Frank Naumann - <fnaumann@cs.uni-magdeburg.de>
 * 
 * please send suggestions, patches or bug reports to me or
 * the MiNT mailing list
 *  
 */

# ifndef _fatfs_h
# define _fatfs_h

# ifdef __TURBOC__
# include "include\mint.h"
# else
# include "include/mint.h"
# endif


# ifdef OLDTOSFS
# define FATFS_TESTING
# endif

/*
 * exported data structures
 */

extern FILESYS fatfs_filesys;

/*
 * exported functions
 */

void fatfs_init (void);
long fatfs_config (const ushort drv, const long config, const long mode);

/* config: */

# define FATFS_VFAT	1	/* enable/disable VFAT extension [on drv] */
# define FATFS_VCASE	2	/* change short name handling
				 * (original/always lowercase)
				 */

# define FATFS_DEBUG	100	/* only for debugging, kernel internal */
# define FATFS_DEBUG_T	101

# ifdef FATFS_TESTING
# define FATFS_DRV	1000	/* temporary:
				 * activate or deactivate fatfs for specified drive
				 */
# endif


# endif /* _fatfs_h */
