/*
 * This file belongs to FreeMiNT.  It's not in the original MiNT 1.12
 * distribution.  See the file Changes.MH for a detailed log of changes.
 */

# ifndef _MISC_H
# define _MISC_H

# include <compiler.h>


# ifndef EXITING
# define EXITING	__EXITING
# endif

# ifndef NORETURN
# define NORETURN	__NORETURN
# endif

# ifndef ARGS_ON_STACK
# define ARGS_ON_STACK	__CDECL
# endif

/* prototype macro thingy: */
# define P_(x)		__PROTO (x)

/* define to mark a function as inline: */
# ifdef __GNUC__
# define INLINE		inline
# define FASTFN		static inline
# endif

/* default: */
# ifndef INLINE
# define INLINE
# endif

/* default: */
# ifndef FASTFN
# define FASTFN		static
# endif

/* define to indicate unused variables: */
# ifdef __TURBOC__
# define UNUSED(x)	(void)x
# endif

/* default: */
# ifndef UNUSED
# define UNUSED(x)
# endif


# ifdef __GNUC__
# ifndef Fcntl
# ifndef trap_1_wwlw

/* see osbind.h for __extension__ and AND_MEMORY */

# define trap_1_wwlw(n, a, b, c)					\
__extension__								\
({									\
	register long retvalue __asm__("d0");				\
	short _a = (short)(a);						\
	long  _b = (long) (b);						\
	short  _c = (short) (c);					\
	    								\
	__asm__ volatile						\
	(	"movw    %4,sp@-;"					\
		"movl    %3,sp@-;"					\
		"movw    %2,sp@-;"					\
		"movw    %1,sp@-;"					\
		"trap    #1;"						\
		"lea	sp@(10),sp;"					\
	: "=r"(retvalue)			/* outputs */		\
	: "g"(n), "r"(_a), "r"(_b), "r"(_c)     /* inputs  */		\
	: "d0", "d1", "d2", "a0", "a1", "a2"    /* clobbered regs */	\
	  AND_MEMORY							\
	);								\
	retvalue;							\
})
# endif /* trap_1_wwlw */

# define Fcntl(f, arg, cmd)	\
	trap_1_wwlw(0x104, (short)(f), (long)(arg), (short)(cmd))

# endif /* Fcntl */
# endif /* __GNUC__ */


# ifndef __TURBOC__
# ifndef Bconmap
extern long xbios();
# define Bconmap(dev) xbios(0x2c, dev)
# endif
# endif


/* Get headers which bind Flock (osbind) and Fcntl (mintbind) */
# ifdef LATTICE
#  include <osbind.h>
#  include <mintbind.h>
# else
/* Binding for Flock */
# ifndef __TURBOC__
# ifndef Flock
extern long gemdos();
/* this may need to be adjusted for your compiler/library */
# define Flock(handle, mode, start, len) gemdos(0x5c, handle, mode, start, len)
# endif
/* ..and Fcntl */
# ifndef Fcntl
extern long gemdos();
# define Fcntl(f, arg, cmd) gemdos(0x104, (short)(f), (long)(arg), (short)(cmd))
# endif
# endif
# endif


# ifdef SHORT_NAMES
# define dispose_fileptr	ds_fileptr
# define dispose_region		ds_region
# define dispose_proc		ds_proc
# endif

# endif /* _MISC_H */
