/*
 * This file belongs to FreeMiNT.  It's not in the original MiNT 1.12
 * distribution.  See the file Changes.MH for a detailed log of changes.
 */

/*
 * mkbuild.c - FreeMiNT.
 * Create build.h.
 * Author: Guido Flohr <gufl0000@stud.uni-sb.de>
 * Started: Mon, 30 Mar 1998.
 * Changed: Sun, 05 Apr 1998 (Draco)
 *          - Renamed output file to "build.h".
 * Changed: Sat, 18 Apr 1998 (Guido)
 *          - De-ANSIfied.
 *          - Clean-up.
 *          - Bugfix: BUILD_DAY_OF_WEEK is now 1 for Monday and 7 for Sunday
 *            and BUILD_MONTH is now 1 for January and 12 for December.  Strange,
 *            but that's the way Ssystem expects it.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <errno.h>
#include <signal.h>
#include <unistd.h>

#ifdef __STDC__
# define PARAM(param) param
#else
# define PARAM(param) ()
#endif

#define OUTNAME "build.h"
char* killfile = NULL;

void signal_handler PARAM((int sigum));

int
main (int argc, char* argv[])
{
  char* myname = argv[0];
  time_t then = time (NULL);
  /* Fixme: Should we use gmtime() instead of local time?  */
  struct tm* now = localtime (&then);
  FILE* out = fopen (OUTNAME, "wb");
  int catchsigs[] = { SIGHUP, SIGINT, SIGQUIT, SIGTERM, -1 };
  int i;
  
  for (i = 0; catchsigs[i] > 0; i++)
    if (signal (catchsigs[i], signal_handler) != 0)
      fprintf (stderr, "%s: warning: can't catch signal #%d: %s\n",
          myname, catchsigs[i], strerror (errno));
  
  if (out == NULL) {
    fprintf (stderr, "%s: error: can't open `%s' for writing: %s\n",
        myname, OUTNAME, strerror (errno));
    return 1;
  } else
    killfile = OUTNAME;
  
  fprintf (out,
	"/* Do not edit this file.  It is automatically created.  Edit\n"
	" * %s instead.\n"
	" */\n\n", __FILE__);

  fprintf (out,
	"#ifndef _MINT_BUILDTIME_H	/* Allow multiple inclusion.  */\n"
	"# define _MINT_BUILDTIME_H\n"
	"\n"
	"#define BUILD_DAY_OF_WEEK %d	/* Attention: Mon is 1, Sun is 7!  */\n"
	"#define BUILD_DAY %d\n"
	"#define BUILD_MONTH %d		/* Attention: range from 1 to 12!  */\n"
	"#define BUILD_YEAR %d\n"
	"#define BUILD_HOUR %d\n"
	"#define BUILD_MIN %d\n"
	"#define BUILD_SEC %d\n"
	"\n"
	"/* Global variables exported into the kernel. */\n"
	"extern long MiNT_date;\n"
	"extern long MiNT_time;\n"
	"\n"
	"#endif /* not _MINT_BUILDTIME_H. */\n",
	now->tm_wday == 0 ? 7 : now->tm_wday, now->tm_mday, 
	now->tm_mon + 1, 
	now->tm_year + 1900,
	now->tm_hour, 
	now->tm_min, 
	now->tm_sec);
  
  if (ferror (out) != 0) {
    fprintf (stderr, "%s: write error on `%s': %s\n",
        myname, OUTNAME, strerror (errno));
    (void) unlink (OUTNAME);
    return 1;    
  }
  
  if (fclose (out) != 0) {
    fprintf (stderr, "%s: error: can't close `%s': %s\n",
        myname, OUTNAME, strerror (errno));
    (void) unlink (OUTNAME);
    return 1;    
  }
  
  return 0;
}

void signal_handler (int signum)
{
  if (killfile != NULL)
    (void) unlink (killfile);
}
