/*
 * This file belongs to FreeMiNT.  It's not in the original MiNT 1.12
 * distribution.  See the file Changes.MH for a detailed log of changes.
 */

/*
 * begin:	1998-05
 * last change: 1998-07-25
 * 
 * Author: Frank Naumann - <fnaumann@cs.uni-magdeburg.de>
 * 
 * please send suggestions, patches or bug reports to me or
 * the MiNT mailing list
 * 
 */

# ifndef _unicode_h
# define _unicode_h

# ifdef __TURBOC__
# include "include\mint.h"
# else
# include "include/mint.h"
# endif


extern uchar *t_uni2atari [256];
extern uchar  t_atari2uni [256];

/*
 * uni2atari
 * ---------
 * Transform a Unicode character - if possible - in an Atari ST character.
 * Other characters are replaced by a '?'. Also swap bytes from Intel words.
 *
 * off: offset codepage	- wchar [0]
 * cp: codepage		- wchar [1]
 *
 *
 * atari2uni
 * ---------
 * Transform an Atari ST character to an Unicode character. Also swap bytes to
 * Intel words.
 *
 * dst: pointer to 2 bytes free space for the Unicode character
 *
 */

# ifdef USE_INLINE_FUNCS

FASTFN char
uni2atari (register uchar off, register uchar cp)
{
	register char *codepage = t_uni2atari [cp];
	return (codepage == NULL) ? '?' : codepage [off];
}

FASTFN void
atari2uni (register uchar atari_st, register uchar *dst)
{
	if (atari_st & 0x80)
	{
		atari_st &= 0x7f;
		atari_st <<= 1;
		dst[1] = t_atari2uni [atari_st]; atari_st++;
		dst[0] = t_atari2uni [atari_st];
	}
	else
	{
		dst[0] = atari_st;
		dst[1] = 0x00;
	}
}

# else

# define uni2atari(off, cp)						\
	((t_uni2atari [cp] == NULL) ? '?' : (t_uni2atari [cp] [off]))

# define atari2uni(atari_st, dst)					\
{									\
	register uchar atari_ = atari_st;				\
									\
	if (atari_ & 0x80)						\
	{								\
		atari_ &= 0x7f;						\
		atari_ <<= 1;						\
		((uchar *) dst)[1] = t_atari2uni [atari_]; atari_++;	\
		((uchar *) dst)[0] = t_atari2uni [atari_];		\
	}								\
	else								\
	{								\
		((uchar *) dst)[0] = atari_st;				\
		((uchar *) dst)[1] = 0x00;				\
	}								\
}									\

# endif

# endif /* _unicode_h */
