/*
 * This file belongs to FreeMiNT.  It's not in the original MiNT 1.12
 * distribution.  See the file Changes.MH for a detailed log of changes.
 */

/*
 * This file is dedicated to the FreeMiNT project.
 * It's not allowed to use this file on other projects without my explicit
 * permission.
 */

/*
 * begin:	1998-02
 * last change: 1998-05-25
 * 
 * Author: Frank Naumann - <fnaumann@cs.uni-magdeburg.de>
 * 
 * please send suggestions, patches or bug reports to me or
 * the MiNT mailing list
 * 
 * 
 * changes since last version:
 * 
 * 1998-05-25:
 * 
 * - initial revision
 * 
 * known bugs:
 * 
 * todo:
 * 
 */

# include "xhdi.h"

# include "ssystem.h"	/* cookie functions */
# include "welcome.h"	/* boot_printf */


/*
 * internal usage
 */

/* dummy routine */
static long
XHDIfail (ushort opcode, ...)
{
	return EINVFN;
}

/* XHDI handler function */
static long (*XHDI)(ushort opcode, ...) = XHDIfail;


ushort XHDI_installed = 0;

# define C_XHDI		0x58484449L
# define XHDIMAGIC	0x27011992L

void
XHDI_init (void)
{
	long i;
	
	i = s_system (GETCOOKIE, C_XHDI, (long) &XHDI);
	if (i == E_OK)
	{
		long *magic_test;
		
		/* check magic */
		magic_test = (long *) XHDI;
		if (magic_test)
		{
			magic_test--;
			if (*magic_test != XHDIMAGIC)
			{
				/* wrong magic */
				XHDI_installed = 0;
			}
			else
				/* check version */
				XHDI_installed = 1;
		}
		else
		{
			/* not installed */
			XHDI_installed = 0;			
		}
	}
	
	XHDI_installed = XHGetVersion ();
	
	/* we need at least XHDI 1.10 */
	if (XHDI_installed >= 0x110)
	{
		boot_printf ("This system features XHDI level %x.%x\r\n\r\n",
			XHDI_installed >> 8, XHDI_installed & 0xff
		);
	}
	else
	{
		boot_print ("This system does not feature XHDI.\r\n\r\n");
		
		XHDI = XHDIfail;
		XHDI_installed = 0;
	}
}


/*
 * XHDI wrapper routines
 */

ushort
XHGetVersion (void)
{
	ushort own_version = 0x130;
	ushort installed;
	
	installed = XHDI (0);
	if (XHDI_installed)
		return MIN (own_version, installed);
	
	return 0L;
}

long
XHInqTarget (ushort major, ushort minor, ulong *block_size, ulong *device_flags, char *product_name)
{
	return XHDI (1, major, minor, block_size, device_flags, product_name);
}

long
XHReserve (ushort major, ushort minor, ushort do_reserve, ushort key)
{
	return XHDI (2, major, minor, do_reserve, key);
}

long
XHLock (ushort major, ushort minor, ushort do_lock, ushort key)
{
	return XHDI (3, major, minor, do_lock, key);
}

long
XHStop (ushort major, ushort minor, ushort do_stop, ushort key)
{
	return XHDI (4, major, minor, do_stop, key);
}

long
XHEject (ushort major, ushort minor, ushort do_eject, ushort key)
{
	return XHDI (5, major, minor, do_eject, key);
}

ulong
XHDrvMap (void)
{
	return XHDI (6);
}

long
XHInqDev (ushort bios_device, ushort *major, ushort *minor, ulong *start_sector, __BPB *bpb)
{
	return XHDI (7, bios_device, major, minor, start_sector, bpb);
}

long
XHInqDriver (ushort bios_device, char *name, char *version, char *company, ushort *ahdi_version, ushort *maxIPL)
{
	return XHDI (8, bios_device, name, version, company, ahdi_version, maxIPL);
}

long
XHNewCookie (void *newcookie)
{
	return EINVFN; /*XHDI (9, newcookie);*/
}

long
XHReadWrite (ushort major, ushort minor, ushort rwflag, ulong recno, ushort count, void *buf)
{
	return XHDI (10, major, minor, rwflag, recno, count, buf);
}

long
XHInqTarget2 (ushort major, ushort minor, ulong *block_size, ulong *device_flags, char *product_name, ushort stringlen)
{
	return XHDI (11, major, minor, block_size, device_flags, product_name, stringlen);
}
          
long
XHInqDev2 (ushort bios_device, ushort *major, ushort *minor, ulong *start_sector, __BPB *bpb, ulong *blocks, char *partid)
{
	return XHDI (12, bios_device, major, minor, start_sector, bpb, blocks, partid);
}

long
XHDriverSpecial (ulong key1, ulong key2, ushort subopcode, void *data)
{
	return XHDI (13, key1, key2, subopcode, data);
}

long
XHGetCapacity (ushort major, ushort minor, ulong *blocks, ulong *bs)
{
	return XHDI (14, major, minor, blocks, bs);
}

long
XHMediumChanged (ushort major, ushort minor)
{
	return XHDI (15, major, minor);
}

long
XHMiNTInfo (ushort opcode, void *data)
{
	return XHDI (16, opcode, data);
}

long
XHDOSLimits (ushort which, ulong limit)
{
	return XHDI (17, which, limit);
}

long
XHLastAccess (ushort major, ushort minor, ulong *ms)
{
	return XHDI (18, major, minor, ms);
}

long
XHReaccess (ushort major, ushort minor)
{
	return XHDI (19, major, minor);
}

long
XHInqDev3 (ushort bios_device, ushort *major, ushort *minor, ulong *start_sector, __xhdi_BPB *bpb, ulong *blocks, uchar *partid, ushort stringlen)
{
	return XHDI (20, bios_device, major, minor, start_sector, bpb, blocks, partid, stringlen);
}

void
XHMakeName (ushort major, ushort minor, ulong start_sector, char *name)
{
	(void) XHDI (21, major, minor, start_sector, name);
	return;
}
