#include <cflib.h>
#include <statfs.h>
#include <mint/dcntl.h>

#include "fsetter.h"

#define UNLIMITED	0x7fffffffL
extern short _app;

#define VERSION	"0.6"

static WDIALOG		*maindial;
static OBJECT		*driveinfo, *strings;
static char			**alerts;
static GRECT		r;
static bool			gl_done = FALSE;
static char			drive_list[32][8];
static int			active_drv = -1;
static int			desktop = -2;
static char			fs_names[][7] = {"tos", "?", "minix", "minix2", "ramfs", "ext2",
											 "fat12", "fat16", "fat32",
											 "vfat12", "vfat16", "vfat32"};

#define rsc_string(a) (char *) get_obspec(strings, a)

/* Falls keine CFLIB >= 7a verfgbar */
#if 0
#include <support.h>

void tree_state(OBJECT *tree, int start_obj, int state, bool set)
{
	int	i;

	for (i = tree[start_obj].ob_head; i <= tree[start_obj].ob_tail; i++)
	{
		set_state(tree, i, state, set);
	}
}

void set_ulong(OBJECT *tree, int obj, ulong l)
{
	char	tmp[20];
	
	_ultoa(l, tmp, 10);
	set_string(tree, obj, tmp);
}
#endif

/* -------------------------------------------------------------------------- */


/*
 * Laufwerks-Daten ermitteln
*/
long get_nflops(void)
{
	return (long)(*((short *)0x4A6));
}

static bool get_drives(void)
{
	long				drive_bits;
	short				num_flops;
	int				i, j;
	char				lw[] = " A:";
	
	drive_bits = Dsetdrv(Dgetdrv());
	num_flops = Supexec(get_nflops);
	if (num_flops == 1)			/* nur eine Floppy */
		drive_bits &= ~2;			/*  -> B ausblenden */

	j = 0;
	for (i = 0; i < 32; i++)
	{
		set_state(maindial->tree, LW_A + i, DISABLED, TRUE);
		strcpy(drive_list[i], "-");

		if (drive_bits & (1L<<i))
		{
			if (i < 26)
				lw[1] = 'A' + i;
			else
				lw[1] = '1' + i - 26;

			set_state(maindial->tree, LW_A + i, DISABLED, FALSE);
			strcpy(drive_list[i], lw);
			j++;
		}
	}

	if (j == 0)
		do_walert(1, 0, alerts[NO_DRIVE], "FSetter");

	return (j > 0);
}


/*
 * Fenster-Update beim Desktop auslsen
*/
static void send_shwdraw(char lw)
{
	if (desktop == -2)
	{
		int	i, d;
		char	name[9], *p;

		if (appl_xgetinfo(4, &d, &d, &i, &d) && (i == 1))
		{
			if (appl_search(2, name, &d, &i))
				desktop = i;
		}

		if (desktop == -2)
		{
			shel_envrn(&p, "AVSERVER=");
			if (p == NULL)
				p = getenv("AVSERVER");
			if (p != NULL)
			{
				strncpy(name, p, 8);
				name[8] = EOS;
				for (i = (int)strlen(name); i < 8; i++)
					strcat(name, " ");
				i = appl_find(name);
				if (i >= 0)
					desktop = i;
				else
					desktop = -1;
			}
		}
	}
	if (desktop >= 0)
	{
		short	msg[8] = {72, 0, 0, 0, 0, 0, 0, 0};
				
		msg[1] = gl_apid;
		if (lw >= '1' && lw <= '6')
			msg[3] = lw - '1' + 27;
		else
			msg[3] = lw - 'A';
		appl_write(desktop, (int)sizeof(msg), msg);
	}
}


/*
 * Laufwerks-Daten im Fenster anzeigen
*/
static void show_data(WDIALOG *wd)
{
	if (active_drv != -1)
	{
		char	lw[] = "X:\\";
		long	l;
		struct control_FAT32	cf32;
		
		lw[0] = drive_list[active_drv][1];
	
		l = Dcntl(VFAT_CNFLN, lw, -1);
		set_state(wd->tree, A_VFAT, DISABLED, (l < 0));
		set_state(wd->tree, A_VFAT, SELECTED, (l == 1L));
	
		l = Dcntl(V_CNTR_SLNK, lw, -1);
		set_state(wd->tree, A_SLNK, DISABLED, (l < 0));
		set_state(wd->tree, A_SLNK, SELECTED, (l == 1L));
	
		l = Dcntl(V_CNTR_WB, lw, -1);
		set_state(wd->tree, A_CACHE, DISABLED, (l < 0));
		set_state(wd->tree, A_CACHE, SELECTED, (l == 1L));
	
		l = Dcntl(V_CNTR_MODE, lw, -1);
		tree_state(wd->tree, N_BOX, DISABLED, (l < 0));
		set_state(wd->tree, N_GEMDOS, SELECTED, (l == 0));
		set_state(wd->tree, N_ISO, SELECTED, (l == 1));
		set_state(wd->tree, N_MSDOS, SELECTED, (l == 2));
	
		cf32.mode = 0;
		l = Dcntl(V_CNTR_FAT32, lw, (long)&cf32);
		tree_state(wd->tree, F_BOX, DISABLED, (l < 0));
		if (l == 0)
		{
			set_state(wd->tree, F_KOPIE, SELECTED, (cf32.mirr == 0));
			set_int(wd->tree, F_ANZAHL, cf32.fats);
			set_int(wd->tree, F_AKTIV, cf32.mirr);
		}

		/* Buttons aktivieren */
		if (active_drv != -1)
		{
			set_state(wd->tree, SETZEN, DISABLED, FALSE);
			set_state(wd->tree, SETENDE, DISABLED, FALSE);
			set_state(wd->tree, LW_INFO, DISABLED, FALSE);
			redraw_wdobj(wd, LW_INFO);
			redraw_wdobj(wd, SETZEN);
			redraw_wdobj(wd, SETENDE);
		}
		redraw_wdobj(wd, A_BOX);
		redraw_wdobj(wd, N_BOX);
		redraw_wdobj(wd, F_BOX);
	}
}


/*
 * Laufwerks-Daten ndern
*/
static void set_data(WDIALOG *wd)
{
	if (active_drv != -1)
	{
		char	lw[] = "X:\\";
		struct control_FAT32	cf32;
		
		lw[0] = drive_list[active_drv][1];
		if (get_state(wd->tree, A_VFAT, SELECTED))
			Dcntl(VFAT_CNFLN, lw, 1);
		else
			Dcntl(VFAT_CNFLN, lw, 0);
			
		if (get_state(wd->tree, A_SLNK, SELECTED))
			Dcntl(V_CNTR_SLNK, lw, 1);
		else
			Dcntl(V_CNTR_SLNK, lw, 0);
	
		if (get_state(wd->tree, A_CACHE, SELECTED))
			Dcntl(V_CNTR_WB, lw, 1);
		else
			Dcntl(V_CNTR_WB, lw, 0);
	
		if (get_state(wd->tree, N_GEMDOS, SELECTED))
			Dcntl(V_CNTR_MODE, lw, 0);
		else if (get_state(wd->tree, N_ISO, SELECTED))
			Dcntl(V_CNTR_MODE, lw, 1);
		else if (get_state(wd->tree, N_MSDOS, SELECTED))
			Dcntl(V_CNTR_MODE, lw, 2);
	
		cf32.mode = 1;
		if (get_state(wd->tree, F_KOPIE, SELECTED))
			cf32.mirr = 0;
		else
			cf32.mirr = get_int(wd->tree, F_AKTIV);
		Dcntl(V_CNTR_FAT32, lw, (long)&cf32);

		cf32.mode = 0;
		if (Dcntl(V_CNTR_FAT32, lw, (long)&cf32) == 0)
		{
			if (get_state(wd->tree, F_KOPIE, SELECTED))
				cf32.mirr = 0;
			else
				cf32.mirr = get_int(wd->tree, F_AKTIV);
			cf32.mode = 1;
			Dcntl(V_CNTR_FAT32, lw, (long)&cf32);
		}
		
		send_shwdraw(lw[0]);
		show_data(wd);
	}
}


/*
 * Laufwerks-Info-Dialog anzeigen.
*/
static void show_info(void)
{
	if (active_drv != -1)
	{
		char				titel[25];
		char				lw[] = "X:\\", name[32] = "";
		long				l;
		struct statfs	st;
		struct fs_info	info;
				
		graf_mouse(BUSY_BEE, 0);

		lw[0] = drive_list[active_drv][1];

		if (statfs(lw, &st) == 0)
		{
			l = Dcntl(FS_INFO, lw, (long)&info);
			if (l == 0)
				strcpy(name, info.type_asc);
			else
			{
				if (st.f_type == 0 || gl_magx)	/* Dcntl(0x104) ist unter MagiC kein MFS_INFO!! */
				{
					l = Dcntl(MX_KER_XFSNAME, lw, (long)name);
					if (l < 0)									
						strcpy(name, fs_names[0]);
				}
				else
					strcpy(name, fs_names[st.f_type]);
			}
			name[10] = EOS;
			set_string(driveinfo, I_SYS, name);
	
			l = Dpathconf(lw, 6);
			switch ((int)l)
			{
				case 0 : set_string(driveinfo, I_CASE, rsc_string(S_JA)); break;
				case 1 : set_string(driveinfo, I_CASE, rsc_string(S_NEIN)); break;
				case 2 : set_string(driveinfo, I_CASE, rsc_string(S_HALB)); break;
				default: set_string(driveinfo, I_CASE, rsc_string(S_NEIN));
			}
	
			l = Dpathconf(lw, 3);
			if (l == -32)
				l = 12;
			if (l == UNLIMITED)
				set_string(driveinfo, I_NLEN, rsc_string(S_BEL));
			else if (l < 0)
				set_string(driveinfo, I_NLEN, rsc_string(S_UNBK));
			else
				set_int(driveinfo, I_NLEN, (int)l);
	
			l = Dpathconf(lw, 2);
			if (l == -32)
				l = 128;
			if (l == UNLIMITED)
				set_string(driveinfo, I_PLEN, rsc_string(S_BEL));
			else if (l < 0)
				set_string(driveinfo, I_PLEN, rsc_string(S_UNBK));
			else
				set_int(driveinfo, I_PLEN, (int)l);
	
			set_ulong(driveinfo, I_GESAMT, (st.f_blocks * st.f_bsize) / 1024UL);
			set_ulong(driveinfo, I_BELEGT, ((st.f_blocks-st.f_bfree) * st.f_bsize) / 1024UL);
			set_ulong(driveinfo, I_FREI, (st.f_bfree * st.f_bsize) / 1024UL);
	
			sprintf(titel, rsc_string(S_TITEL), lw);
			set_string(driveinfo, I_TITEL, titel);
			simple_mdial(driveinfo, 0);
		}
		else
			do_walert(1, 0, alerts[NO_INFO], "FSetter");
	}
}



/*
 * Callbacks des Haupt-Dialogs
*/
static void open_it(WDIALOG *wd)
{
	if (active_drv == -1)			/* nur beim ersten ffnen */
	{
		char	str[256];

		sprintf(str, rsc_string(S_VERSION), VERSION);
		set_string(wd->tree, MB_VERS, str);

		tree_state(wd->tree, A_BOX, DISABLED, TRUE);
		tree_state(wd->tree, N_BOX, DISABLED, TRUE);
		tree_state(wd->tree, F_BOX, DISABLED, TRUE);

		if (_app)
		{
			/* aktives Verzeichnis holen und LW selektieren */
			get_path(str, 0);
			active_drv = str[0] - 'A';
			set_state(wd->tree, active_drv + LW_A, SELECTED, TRUE);
			show_data(wd);
		}
		else
		{
			set_state(wd->tree, LW_INFO, DISABLED, TRUE);
			set_state(wd->tree, SETZEN, DISABLED, TRUE);
			set_state(wd->tree, SETENDE, DISABLED, TRUE);
		}
	}
}


static bool exit_it(WDIALOG *wd, int obj)
{
	bool	close = FALSE;
	int	new;
		
	switch (obj)
	{
		case SETZEN :
			set_data(wd);
			set_state(wd->tree, obj, SELECTED, FALSE);
			redraw_wdobj(wd, obj);
			break;

		case LW_INFO :
			show_info();
			set_state(wd->tree, LW_INFO, SELECTED, FALSE);
			redraw_wdobj(wd, LW_INFO);
			break;

		case SETENDE :
			set_data(wd);
			/* weiter wie bei Ende */
		case WD_CLOSER:
		case ENDE :
			close = TRUE;
			if (_app)
				gl_done = TRUE;
			break;

		default:
			if (obj >= LW_A && obj <= LW_6)
			{
				new = obj - LW_A;
				if (new != active_drv)
				{
					active_drv = new;
					show_data(wd);
				}
			}
	}
	return close;
}


/*
 * Event-Verarbeitung 
*/
static void handle_msg(int *msgbuff)
{
	if (!message_wdial(msgbuff))
	{
		switch (msgbuff[0]) 
		{
				case AC_OPEN:
					open_wdial(maindial, -1, -1);
					if (get_drives())
					{
						if (active_drv != -1)
							set_state(maindial->tree, LW_A + active_drv, SELECTED, TRUE);
						show_data(maindial);
					}
					break;
					
				case AP_TERM:
/*					if (_app)				/* wir sind kein ACC! */
						gl_done = TRUE;
					break;
		}
	}
}

static void main_loop(void)
{
	int	evset, event, msx, msy, mbutton, kstate, mbreturn, kreturn;
	int	msgbuff[8];

	do 
	{
		if (maindial->mode == WD_OPEN)
			evset = (MU_MESAG | MU_BUTTON | MU_KEYBD);
		else
			evset = MU_MESAG;
			
		event = evnt_multi(evset, 1, 1, 1,
									0, 0, 0, 0, 0,	0, 0, 0, 0, 0,
									msgbuff,	0,
									&msx, &msy, &mbutton, &kstate,
									&kreturn, &mbreturn);

		if (event & MU_MESAG) 
			handle_msg(msgbuff);
		
		if (event & MU_KEYBD) 
		{
			if (!key_wdial(kreturn, kstate))
			{
				if (kstate == K_CTRL && kreturn == 0x1011)		/* ^Q */
				{
					if (_app)
						gl_done = TRUE;
					else
						close_wdial(maindial);
				}
			}
		}
		
		if (event & MU_BUTTON) 
			click_wdial(mbreturn, msx, msy, kstate, mbutton);

	}
	while (!gl_done);
}

int main(void)
{
	OBJECT	*t, *t2;
	
/*
	debug_init("fsetter", TCon, NULL);
*/
	init_app("fsetter.rsc");

	rsrc_gaddr(R_TREE, STRINGS, &strings);

	if (gl_naes || !_app)
		menu_register(gl_apid, rsc_string(S_MENU));

	rsrc_gaddr(R_TREE, MAINBOX, &t);
	rsrc_gaddr(R_TREE, WINICON, &t2);
	fix_dial(t);
	maindial = create_wdial(t, t2, 0, open_it, exit_it);
	rsrc_gaddr(R_TREE, INFOBOX, &driveinfo);
	fix_dial(driveinfo);
	rsrc_gaddr(R_FRSTR, NO_DRIVE,	&alerts);		/* _erster_ Alert */

	/* Fr Info-Dialog und Alerts */
	set_mdial_wincb(handle_msg);

	if (_app)
	{
		open_wdial(maindial, -1, -1);
		get_drives();
	}

	main_loop();

	delete_wdial(maindial);
	exit_app(0);
	return 0;
}
