/*
 * Filename:     default.h
 * Version:      0.0
 * Author:       Frank Naumann
 * Started:      1998-08-01
 * Last Updated: 1998-
 * Target O/S:   TOS
 * Description:  useful standard types, makros, functions
 * 
 * Note:         Please send suggestions, patches or bug reports to me
 *               or the MiNT mailing list (mint@).
 * 
 * Copying:      Copyright (C) 1998 Frank Naumann
 *                                  (fnaumann@cs.uni-magdeburg.de)
 *                                  (Frank Naumann @ L2)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 * changes since last version:
 * 
 * todo:
 * 
 */

# ifndef _default_h
# define _default_h


/*
 * nice types
 */

typedef unsigned char	uchar;
typedef unsigned short	ushort;
typedef unsigned long	ulong;


/*
 * fast functions
 */

# define FASTFN		inline static


/*
 * configuration modes
 */

# define ASK	-1
# define DISABLE 0
# define ENABLE  1

# define NO	 0
# define YES	 1


/*
 * useful makros
 */

# define MAX(a,b)	(a > b ? a : b)
# define MIN(a,b)	(a > b ? b : a)


/*
 * big/little endian stuff
 */

FASTFN unsigned short
SWAP68_W (register ushort v)
{
	__asm__
	(	"rolw #8, %0"
		: "=d" (v)
		: "0" (v), "d" (v)
	);
	return v;
}

FASTFN unsigned long
SWAP68_L (register ulong v)
{
	__asm__
	(	"rolw #8, %0;"
		"swap %0;"
		"rolw #8, %0;"
		: "=d" (v)
		: "0" (v), "d" (v)
	);
	return v;
}


# define str(x)		_stringify (x)
# define _stringify(x)	#x


# endif /* _default_h */
