;# NAME
;#    mail.pl - perl function(s) to handle mail processing
;#
;# AUTHOR
;#    Michael S. Muegel (mmuegel@mot.com)
;#
;# RCS INFORMATION
;#    mmuegel
;#    /usr/local/ustart/src/mail-tools/dist/foo/libs/mail.pl,v 1.1 1993/07/28 08:07:19 mmuegel Exp

package mail;

# Mailer statement to eval. $Users, $Subject, and $Verbose are substituted 
# via eval
$BIN_MAILER 		= "/usr/ucb/mail \$Verbose -s '\$Subject' \$Users";

# Sendmail command to use when $Use_Sendmail is true.
$SENDMAIL		= '/usr/lib/sendmail $Verbose $Users';

;###############################################################################
;# Send_Mail
;#
;# Sends $Message to $Users with a subject of $Subject. If $Message_Is_File
;# is true then $Message is assumed to be a filename pointing to the mail
;# message. This is a new option and thus the backwards-compatible hack.
;# $Users should be a space separated list of mail-ids.
;#
;# If everything went OK $Status will be 1 and $Error_Msg can be ignored; 
;# otherwise, $Status will be 0 and $Error_Msg will contain an error message.
;# 
;# If $Use_Sendmail is 1 then sendmail is used to send the message. Normally
;# a mailer such as Mail is used. By specifiying this you can include 
;# headers in addition to text in either $Message or $Message_Is_File.
;# If either $Message or $Message_Is_File contain a Subject: header then
;# $Subject is ignored; otherwise, a Subject: header is automatically created.
;# Similar to the Subject: header, if a To: header does not exist one
;# is automatically created from the $Users argument. The mail is still
;# sent, however, to the recipients listed in $Users. This is keeping with
;# normal sendmail usage (header vs. envelope).
;# 
;# In both bin mailer and sendmail modes $Verbose will turn on verbose mode
;# (normally just sendmail verbose mode output).
;#
;# Arguments:
;#    $Users, $Subject, $Message, $Message_Is_File, $Verbose, $Use_Sendmail
;#
;# Returns:
;#    $Status, $Error_Msg
;###############################################################################
sub main'Send_Mail
{
   local ($Users, $Subject, $Message, $Message_Is_File, $Verbose, 
	  $Use_Sendmail) = @_;
   local ($BIN_MAILER_HANDLE, $Mailer_Command, $Header_Found, %Header_Map,
	  $Header_Extra, $Mailer);

   # If the message is contained in a file read it in so we can have one
   # consistent interface
   if ($Message_Is_File)
   {
      undef $/;
      $Message_Is_File = 0;
      open (Message) || return (0, "error reading $Message: $!");
      $Message = <Message>;
      close (Message);
   };

   # If sendmail mode see if we need to add some headers
   if ($Use_Sendmail)
   {
      # Determine if a header block is included in the message and what headers
      # are there
      foreach (split (/\n/, $Message))
      {
	 last if ($_ eq "");
	 $Header_Found = $Header_Map {$1} = 1 if (/^([A-Z]\S*): /);
      };

      # Add some headers?
      if (! $Header_Map {"To"})
      {
	 $Header_Extra .= "To: " . join (", ", $Users) . "\n";
      };
      if (($Subject ne "") && (! $Header_Map {"Subject"}))
      {
	 $Header_Extra .= "Subject: $Subject\n";
      };

      # Add the required blank line between header/body if there where no
      # headers to begin with
      if ($Header_Found)
      {
         $Message = "$Header_Extra$Message";
      }
      else
      {
	 $Message = "$Header_Extra\n$Message";
      };
   };

   # Get a string that is the mail command
   $Verbose = ($Verbose) ? "-v" : "";
   $Mailer = ($Use_Sendmail) ? $SENDMAIL : $BIN_MAILER;
   eval "\$Mailer = \"$Mailer\"";
   return (0, "error setting \$Mailer: $@") if ($@);

   # need to catch SIGPIPE in case the $Mailer call fails
   $SIG {'PIPE'} = "mail'Cleanup";

   # Open mailer
   return (0, "can not open mail program: $Mailer") if (! open (MAILER, "| $Mailer"));
   
   # Send off the mail!
   print MAILER $Message;
   close (MAILER);
   return (0, "error running mail program: $Mailer") if ($?);
   
   # Everything must have went AOK
   return (1);
};

;###############################################################################
;# Cleanup
;#
;# Simply here so we can catch SIGPIPE and not exit.
;#
;# Globals:
;#    None
;#
;# Arguments:
;#    None
;#
;# Returns:
;#    Nothing exciting
;###############################################################################
sub Cleanup
{
};

1;
