/*
 *	int __mint_read  (int, void *, unsigned int);
 *	int __mint_write (int, void *, unsigned int);
 *
 *	Q&D posix like read() and write(). They (should) return
 *	EWOULDBLOCK for nonblocking mode and no data avail / no
 *	space left. 
 *
 *	int __fork_and_exit();
 *
 *	This acts like 'if (fork()) exit();' with a nonblocking fork.
 *	But unfortunately MiNT's fork() does block the parent until
 *	child does exec() or exit(). So use fork_and_exit() as a temp.
 *	workaround.
 *
 *	12/28/93, kay roemer <roemer@rbi.informatik.uni-frankfurt.de>
 */

#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <ioctl.h>
#include <osbind.h>
#include <mintbind.h>
#include <setjmp.h>

#define UNLIMITED	1000000

int
__mint_read (int fd, void *buffer, unsigned int buflen)
{
	int r, s;
	unsigned long buf;
	extern int errno;

	r = Fread (fd, buflen, buffer);
	if (r <= 0) {
		if (r < 0) {
			errno = -r;
			return -1;
		}
		if (buflen && Fcntl (fd, 0, F_GETFL) & O_NDELAY) {
			s = Fcntl (fd, &buf, FIONREAD);
			if (!s && buf < UNLIMITED) {
				errno = EWOULDBLOCK;
				return -1;
			}
		}
	}
	return r;
}

int
__mint_write (int fd, void *buffer, unsigned int buflen)
{
	int r, s;
	unsigned long buf;
	extern int errno;

	r = Fwrite (fd, buflen, buffer);
	if (r <= 0) {
		if (r < 0) {
			errno = -r;
			return -1;
		}
		if (buflen && Fcntl (fd, 0, F_GETFL) & O_NDELAY) {
			s = Fcntl (fd, &buf, FIONWRITE);
			if (!s && buf < UNLIMITED) {
				errno = EWOULDBLOCK;
				return -1;
			}
		}
	}
	return r;
}

static int fd_flags[32];
static jmp_buf jmpbuf;

int
child_proc (long pip)
{
	char buf;
	int i;
	
	if (read (pip, &buf, 1)) exit (0);
	close (pip);
	for (i = 0; i < 32; ++i) {
		if (fd_flags[i] >= 0)
			fcntl (i, F_SETFD, fd_flags[i]);
	}
	longjmp (jmpbuf, 1);
}
	
int
__fork_and_exit (void)
{
	int i, pip[2];

	if (pipe (pip) < 0) return -1;
	for (i = 0; i < 32; ++i) {
		fd_flags[i] = fcntl (i, F_GETFD, 0);
		fcntl (i, F_SETFD, i == pip[1] ? FD_CLOEXEC : 0);
	}
	if (!setjmp (jmpbuf)) {
		tfork (child_proc, pip[0]);
		exit (0);
	}
	return 0;
}
