/*				Amadeus... The great (command line) composer
				For Atari ST range this version 26 July 1994 (1.0)
									Written in GNU.C by 
							Paul Cartwright and Paul Hamer
		
If you port this to any other machine please give us a mention!*/
		


#include<stdio.h>
#include<osbind.h>
#include<string.h>

#define DEBUG(x) printf("DEBUG: %d\n",x)

void read_line(FILE *,char*,int);
int do_file(char *, FILE *,int);
void to_lower(char *);
void build_command(char *,char*, char *);
void process_item(char *, char *, char *,int *,int *);


int main(int argc,char *argv[])
{
FILE *fp;
char *file,*extender,*slash;
char line[255],path[128];
int ss;

ss=Getshift()&3;/*Read status of shift keys*/
if(ss==3) ss=2;

if(argc==0) {
						puts("Usage: amadeus file");
						exit(1);
						}
file=argv[1];
to_lower(file);

if(!(fp=fopen("amadeus.inf","r")))
   {
   puts("Error: AMADEUS.INF not found");
   exit(1);
   }
     strcpy(path,file);
		if((slash=strrchr(path,'\\'))!=NULL) 
			{
			*slash=0;
			
			Dsetpath(path);
			Dsetdrv(path[0]-'a');/*set path and device to that of input file*/
			}
return(do_file(file,fp,ss));
}


void read_line(FILE *fp,char *string,int ss)
{
   if(feof(fp))	{
   	if(ss)
   		puts("Error: shift mode undefined");
    else
   		puts("Error: file type unknown");
   		exit(1);
   		}  
   fscanf(fp,"\n%[^\n]",string);
   to_lower(string);
}


int do_file(char *file,FILE *fp,int ss)
{
int n_items,counter,turns=-1;
long int addr;
char line[255],extender[5],path[128],*filex;
char *input = (char *) malloc(512);
char *command = (char *) malloc(512);

for(counter=0;counter<512;counter++)
	  {input[counter]=0;
	  command[counter]=0;}
	  
command[0]=127; /*ST range requires pascal style parameters 
								(Set string length to 127)*/

do
{
read_line(fp,line,ss);
n_items=sscanf(line,"%s %s %s",extender,path,&input[1]);


filex = strrchr(file,'.');
if (strcmp(filex,extender)==0) turns++;
}
while(strcmp(filex,extender)||(turns!=ss));

if(n_items<3) {
							puts("Error: bad line in AMADEUS.INF");
							exit(1);
							}

build_command(command,input,file);/*parse command line string*/
fclose(fp);
return(Pexec(0,path,command,NULL));/*execute program*/
}

void to_lower(char *str)/*ST sometimes case sensitive*/
{
int c,counter=0;

do
{
   c=str[counter];
   str[counter++]=tolower(c);

}while(c);

}

void build_command(char *command,char *input,char *file)
{
int i=1,j=1;


do
   {

   if(input[i]=='_')
   		{
   		command[j]=' ';
   		i++;
   		j++;
   		}
   		
   else
   {
   if(input[i]=='%')
   		{
   		process_item(&input[i+1],&command[j],file,&i,&j);/*process specifiers*/
  		}
   else
   		{
   	
   		command[j]=input[i];
   		i++;
   		j++;
   		}
   }
   } while(input[i]);
   command[j]=0;
}

void process_item(char *input,char * command, char *file,int *i,int *j)
{
int n_chars,counter,n_ext;
char *slash,*dot;
char temp[48];


switch(input[0]) {
	case	'p':
								if((slash=strrchr(file,'\\'))==NULL)
									{
									*i+=2;
									break;
								  }
								
			n_chars=((long int) slash - (long int) file);
			
			for(counter=0;counter<=n_chars;counter++)
				command[counter]=file[counter];
				*i+=2;
				*j+=n_chars+1;
			break;
      
	case	'f':
							if(strrchr(file,'\\')==NULL) 
								{
								strcpy(command,file);
								*i+=2;
								*j+=strlen(file);
								}
							else 
								{
								strcpy(command,(char *)(((long int)strrchr(file,'\\'))+1));
								*i+=2;
								*j+=strlen(strrchr(file,'\\'))-1;
								}

			break;
		
		
	case	'.':  n_ext=3;
							for(counter=3;counter>0;counter--)
										if(input[counter]=='_') n_ext=counter-1;
										
							if(strrchr(file,'\\')==NULL) 
								{
								strcpy(temp,file);
								}
								
							else {
						  strcpy(temp,(char *)(((long int)strrchr(file,'\\'))+1));
							
						
							}        
					
							
							if(strrchr(temp,'.')==NULL) {
									strcpy(command,temp);
									*i+=n_ext+2;
									*j+=strlen(temp);
									}
							else {
					
									dot=strrchr(temp,'.');
									for(counter=1;counter<=n_ext;counter++)
											dot[counter]=input[counter];
									dot[n_ext+1]=0;
									strcpy(command,temp);
									*i+=n_ext+2;
									*j+=strlen(temp);
									
									}
			break;
			
		case '_':		command[0]='_';
								*i+=2;
								*j+=1;
								break;
								
	  case '%':		command[0]='%';
	  						*i+=2;
	  						*j+=1;
	  						break;
	  						
	  default:		printf("Error: Unknown specifier: %%%c\n",input[0]);
	  						exit(1);
	  						break;
		}						
							
					
}
