/*-------------------------- fftout68.c --------------------------------*/
/*                                                                      */
/* Author:      Udi Finkelstein (based on code by Eyal Lebedinsky)      */
/* Date:        Aug 91                                                  */
/* Version:     26 Aug 1991                                             */
/*                                                                      */
/* called from fftg.c and generates 68K output                          */
/*                                                                      */
/* This program is released into the public domain.                     */
/*                                                                      */
/*----------------------------------------------------------------------*/

#include <stdio.h>

static int	label = 0;

void
start_fft (file_name, ep_name)
char	*file_name, *ep_name;
{
	char	fname[256];

	strcpy (fname, file_name);
	strcat (fname, ".asm");

	freopen (fname, "wt", stdout);
	printf ("%s:\n\tXDEF\t%s\n", ep_name, ep_name);
	printf ("\tXREF\t_x\n\tXREF\t\_qf\n");
	printf ("\tmovem.l\td0-d7/a0-a1,-(a7)\n");
	printf ("\tlea\t_x,a0\n");
	printf ("\tlea\t_qf,a1\n");
}

void
end_fft (file_name, ep_name)
char	*file_name, *ep_name;
{
	printf (";finished here!\n");
	printf ("\tmovem.l\t(a7)+,d0-d7/a0-a1\n");
	printf ("\trts\n\n");
	printf ("\tEND\n");
	close (stdout);
}

void
fft1 (i1)
int	i1;
{
	printf (";_fft1(%d)\n", i1);
	printf ("\tasr.w\t%d(a0)\n", 2 * i1);
}

void
fft2 (i1, i2)
int	i1, i2;
{
	printf (";_fft2(%d,%d)\n", i1, i2);
	printf ("\tmove.w\t%d(a0),d1\n", 2 * i1);
	printf ("\tmove.w\t%d(a0),d2\n", 2 * i2);
	printf ("\tasr.w\t#1,d1\n");
	printf ("\tasr.w\t#1,d2\n");
	printf ("\tmove.w\td1,d0\n");
	printf ("\tadd.w\td2,d0\n");
	printf ("\tmove.w\td0,%d(a0)\n", 2 * i1);
	printf ("\tsub.w\td2,d1\n");
	printf ("\tmove.w\td1,%d(a0)\n", 2 * i2);
}

void
fft3 (i1, i3, i4)
int	i1, i3, i4;
{
	printf (";_fft3(%d,%d,%d)\n", i1, i3, i4);
	printf ("\tmove.w\t%d(a0),d1\n", 2 * i1);
	printf ("\tmove.w\t%d(a0),d3\n", 2 * i3);
	printf ("\tmove.w\t%d(a0),d4\n", 2 * i4);
	printf ("\tasr.w\t#1,d1\n");
	printf ("\tasr.w\t#1,d3\n");
	printf ("\tasr.w\t#1,d4\n");
	printf ("\tmove.w\td4,d0\n");
	printf ("\tadd.w\td3,d0\n");
	printf ("\tasr.w\t#1,d0\n");
	printf ("\tsub.w\td3,d4\n");
	printf ("\tasr.w\t#1,d4\n");
	printf ("\tmove.w\td4,%d(a0)\n", 2 * i4);
	printf ("\tmove.w\td1,d3\n");
	printf ("\tsub.w\td0,d3\n");
	printf ("\tmove.w\td3,%d(a0)\n", 2 * i3);
	printf ("\tadd.w\td0,d1\n");
	printf ("\tmove.w\td1,%d(a0)\n", 2 * i1);
}

void
fft4 (i1, i2, i3, i4, cc1)
int	i1, i2, i3, i4, cc1;
{
	printf (";_fft4(%d,%d,%d,%d,0x%04x)\n", i1, i2, i3, i4, cc1);
	printf ("\tmove.w\t%d(a0),d1\n", 2 * i1);
	printf ("\tmove.w\t%d(a0),d2\n", 2 * i2);
	printf ("\tasr.w\t#2,d1\n");
	printf ("\tasr.w\t#1,d2\n");
	printf ("\tmove.w\t%d(a0),d3\n", 2 * i3);
	printf ("\tmove.w\t%d(a0),d4\n", 2 * i4);
	printf ("\tmuls\t#%d,d3\n", cc1);
	printf ("\tswap\td3\n");
	printf ("\tmuls\t#%d,d4\n", cc1);
	printf ("\tswap\td4\n");
	printf ("\tmove.w\td3,d0\n");
	printf ("\tsub.w\td4,d3\n");
	printf ("\tadd.w\td0,d4\n");
	printf ("\tmove.w\td2,d0\n");
	printf ("\tsub.w\td4,d0\n");
	printf ("\tmove.w\td0,%d(a0)\n", 2 * i4);
	printf ("\tadd.w\td4,d2\n");
	printf ("\tneg.w\td2\n");
	printf ("\tmove.w\td2,%d(a0)\n", 2 * i3);
	printf ("\tmove.w\td1,d0\n");
	printf ("\tsub.w\td3,d0\n");
	printf ("\tmove.w\td0,%d(a0)\n", 2 * i2);
	printf ("\tadd.w\td3,d1\n");
	printf ("\tmove.w\td1,%d(a0)\n", 2 * i1);
}

void
fft5 (i1, i2, i3, i4, i5, i6, i7, i8, sm1, sp1, cc1, sm3, sp3, cc3, ind)
int	i1, i2, i3, i4, i5, i6, i7, i8, sm1, sp1, cc1, sm3, sp3, cc3, ind;
{
	printf (";_fft5(%d,%d,%d,%d,%d,%d,%d,%d,",
		i1, i2, i3, i4, i5, i6, i7, i8);
	printf ("0x%04x,0x%04x,0x%04x,0x%04x,0x%04x,0x%04x,%d)\n",
		sm1, sp1, cc1, sm3, sp3, cc3, ind);
	printf ("\tmove.w\t%d(a0),d5\n", 2 * i7);
	printf ("\tmove.w\td5,d1\n");
	printf ("\tmuls\t#%d,d1\n", sm1);
	printf ("\tswap\td1\n");
	printf ("\tmove.w\t%d(a0),d6\n", 2 * i3);
	if (ind) printf ("\tasr.w\t#1,d6\n");
	printf ("\tadd.w\td6,d5\n");
	printf ("\tmove.w\td6,d2\n");
	printf ("\tmuls\t#%d,d2\n", sp1);
	printf ("\tswap\td2\n");
	printf ("\tmuls\t#%d,d5\n", cc1);
	printf ("\tswap\td5\n");
	printf ("\tadd.w\td5,d1\n");
	printf ("\tadd.w\td5,d2\n");

	printf ("\tmove.w\t%d(a0),d5\n", 2 * i8);
	printf ("\tmove.w\td5,d3\n");
	printf ("\tmuls\t#%d,d3\n", sm3);
	printf ("\tswap\td3\n");
	printf ("\tmove.w\t%d(a0),d6\n", 2 * i4);
	if (ind) printf ("\tasr.w\t#1,d6\n");
	printf ("\tadd.w\td6,d5\n");
	printf ("\tmove.w\td6,d4\n");
	printf ("\tmuls\t#%d,d4\n", sp3);
	printf ("\tswap\td4\n");
	printf ("\tmuls\t#%d,d5\n", cc3);
	printf ("\tswap\td5\n");
	printf ("\tadd.w\td5,d3\n");
	printf ("\tadd.w\td5,d4\n");

	printf ("\tmove.w\td3,d5\n");
	printf ("\tsub.w\td1,d5\n");

	printf ("\tmove.w\t%d(a0),d6\n", 2 * i2);
	printf ("\tasr.w\t#1,d6\n");
	printf ("\tmove.w\td5,d0\n");
	printf ("\tsub.w\td6,d0\n");
	printf ("\tmove.w\td0,%d(a0)\n", 2 * i7);
	printf ("\tadd.w\td6,d5\n");
	printf ("\tmove.w\td5,%d(a0)\n", 2 * i4);
	printf ("\tmove.w\td2,d5\n");
	printf ("\tadd.w\td4,d5\n");

	printf ("\tmove.w\t%d(a0),d6\n", 2 * i6);
	printf ("\tasr.w\t#1,d6\n");
	printf ("\tmove.w\td5,d0\n");
	printf ("\tsub.w\td6,d0\n");
	printf ("\tmove.w\td0,%d(a0)\n", 2 * i3);
	printf ("\tadd.w\td6,d5\n");
	printf ("\tmove.w\td5,%d(a0)\n", 2 * i8);
	printf ("\tmove.w\td1,d5\n");
	printf ("\tadd.w\td3,d5\n");

	printf ("\tmove.w\t%d(a0),d6\n", 2 * i1);
	printf ("\tasr.w\t#1,d6\n");
	printf ("\tmove.w\td6,d0\n");
	printf ("\tsub.w\td5,d0\n");
	printf ("\tmove.w\td0,%d(a0)\n", 2 * i6);
	printf ("\tadd.w\td6,d5\n");
	printf ("\tmove.w\td5,%d(a0)\n", 2 * i1);
	printf ("\tmove.w\td2,d5\n");
	printf ("\tsub.w\td4,d5\n");

	printf ("\tmove.w\t%d(a0),d6\n", 2 * i5);
	printf ("\tasr.w\t#1,d6\n");
	printf ("\tmove.w\td6,d0\n");
	printf ("\tsub.w\td5,d0\n");
	printf ("\tmove.w\td0,%d(a0)\n", 2 * i5);
	printf ("\tadd.w\td5,d6\n");
	printf ("\tmove.w\td6,%d(a0)\n", 2 * i2);
}

void
fft7 (i1, i2)
int	i1, i2;
{
	printf (";_fft7(%d,%d)\n", i1, i2);
	printf ("\tmove.w\t%d(a0),d0\n", 2 * i2);
	printf ("\tmuls\td0,d0\n");
	printf ("\tswap\td0\n");
	printf ("\tmove.w\td0,%d(a1)\n", 2 * i1);
}

void
fft8 (i1, i2, i3)
int	i1, i2, i3;
{
	printf (";_fft8(%d,%d,%d)\n", i1, i2, i3);
	printf ("\tmove.w\t%d(a0),d0\n", 2 * i2);
	printf ("\tmuls\td0,d0\n");
	printf ("\tmove.w\t%d(a0),d1\n", 2 * i3);
	printf ("\tmuls\td1,d1\n");
	printf ("\tadd.l\td1,d0\n");
	printf ("\tswap\td0\n");
	printf ("\tmove.w\td0,%d(a1)\n", 2 * i1);
}
