/* ---------------------- fftouta.c -----------------------------------	*/
/*									*/
/* Author:	Eyal Lebedinsky						*/
/* Date:	May 1990						*/
/* Version:	9 June 1991						*/
/*									*/
/* called from fftg.c and generates Intel 80x86 .asm macro calls	*/
/*									*/
/* This program is released into the public domain.			*/
/*									*/
/*----------------------------------------------------------------------*/

#include <stdio.h>

void
start_fft (file_name, ep_name)
char	*file_name, *ep_name;
{
	char	fname[256];

	strcpy (fname, file_name);
	strcat (fname, ".asm");

	freopen (fname, "wt", stdout);
	printf ("\tINCLUDE fftsub86.mac\n");
	printf ("_DATA\tSEGMENT WORD PUBLIC 'DATA'\n");
	printf ("\tEXTRN _x:WORD\n");
	printf ("\tEXTRN _qf:WORD\n");
	printf ("_DATA\tENDS\n");
	printf ("_TEXT\tSEGMENT WORD PUBLIC 'CODE'\n");
	printf ("\tPUBLIC _%s\n", ep_name);
	printf ("_%s\tPROC FAR\n", ep_name);

	printf (" push bp\n");
	printf (" push si\n");
	printf (" push di\n");
	printf (" push ax\n");
	printf (" push bx\n");
	printf (" push cx\n");
	printf (" push dx\n");
}

void
end_fft (file_name, ep_name)
char	*file_name, *ep_name;
{
	printf (" pop dx\n");
	printf (" pop cx\n");
	printf (" pop bx\n");
	printf (" pop ax\n");
	printf (" pop di\n");
	printf (" pop si\n");
	printf (" pop bp\n");
	printf (" retf\n");

	printf ("_%s\tENDP\n", ep_name);
	printf ("_TEXT\tENDS\n");
	printf ("\tEND\n");
	close (stdout);
}

void
fft1 (i1)
int	i1;
{
	printf (" fft1 %u\n", 2*i1);
}

void
fft2 (i1, i2)
int	i1, i2;
{
	printf (" fft2 %u,%u\n", 2*i1, 2*i2);
}

void
fft3 (i1, i3, i4)
int	i1, i3, i4;
{
	printf (" fft3 %u,%u,%u\n", 2*i1, 2*i3, 2*i4);
}

void
fft4 (i1, i2, i3, i4, cc1)
int	i1, i2, i3, i4, cc1;
{
	printf (" fft4 %u,%u,%u,%u,0%04xH\n", 2*i1, 2*i2, 2*i3, 2*i4, cc1);
}

void
fft5 (i1, i2, i3, i4, i5, i6, i7, i8, sm1, sp1, cc1, sm3, sp3, cc3, ind)
int	i1, i2, i3, i4, i5, i6, i7, i8, sm1, sp1, cc1, sm3, sp3, cc3, ind;
{
	printf (" fft5a %u,%u,0%04xH,0%04xH,0%04xH,%u\n",
		2*i3, 2*i7, sm1, sp1, cc1, ind);

	printf (" fft5b %u,%u,0%04xH,0%04xH,0%04xH,%u\n",
		2*i4, 2*i8, sm3, sp3, cc3, ind);

	printf (" fft5c %u,%u,%u,%u,%u,%u,%u,%u\n",
		2*i1, 2*i2, 2*i3, 2*i4, 2*i5, 2*i6, 2*i7, 2*i8);
}

void
fft7 (i1, i2)
int	i1, i2;
{
	printf (" fft7 %u,%u\n", 2*i1, 2*i2);
}

void
fft8 (i1, i2, i3)
int	i1, i2, i3;
{
	printf (" fft8 %u,%u,%u\n", 2*i1, 2*i2, 2*i3);
}
