/* ------------------------- fftsubs.h -------------------------------- */
/*									*/
/* Author:	Eyal Lebedinsky						*/
/* Date:	May 1990						*/
/* Version:	9 June 1991						*/
/*									*/
/* used by the output of fftgc						*/
/*									*/
/* This program is released into the public domain.			*/
/*									*/
/*----------------------------------------------------------------------*/

#define mulf(x,y) (((long)(int)(x) * (long)(int)(y)) >> 16)

extern short x[], qf[];

#define init \
	register short t1,t2,t3,t4,t5,t6,tt;\
	register long lt1,lt2;

#define _fft1(i) \
	x[i] >>= 1;

#define _fft2(i0,i1) \
	t1 = x[i0] >> 1;\
	t2 = x[i1] >> 1;\
	tt = t1; tt += t2; x[i0] = tt;\
	t1 -= t2; x[i1] = t1;

#define _fft3(i1,i3,i4) \
	t1 = x[i1] >> 1;\
	t3 = x[i3] >> 1;\
	t4 = x[i4] >> 1;\
	tt = t4; tt += t3; tt >>= 1;\
	t4 -= t3; t4 >>= 1; x[i4] = t4;\
	t3 = t1; t3 -= tt; x[i3] = t3;\
	t1 += tt; x[i1] = t1;

#define _fft4(i1,i2,i3,i4,cc1) \
	t1 = x[i1] >> 2;\
	t2 = x[i2] >> 1;\
	t3 = mulf (x[i3], cc1);\
	t4 = mulf (x[i4], cc1);\
	tt = t3; t3 -= t4; t4 += tt;\
	tt = t2; tt -= t4; x[i4] = tt;\
	t2 += t4; x[i3] = -t2;\
	tt = t1; tt -= t3; x[i2] = tt;\
	t1 += t3; x[i1] =  t1;

#define _fft5(i1,i2,i3,i4,i5,i6,i7,i8,sm1,sp1,cc1,sm3,sp3,cc3,ind) \
	t5 = x[i7];\
	t1 = mulf (t5, sm1);\
	t6 = x[i3];\
	if (ind)\
		t6 >>= 1;\
	t5 += t6;\
	t2 = mulf (t6, sp1);\
	t5 = mulf (t5, cc1);\
	t1 += t5;\
	t2 += t5;\
\
	t5 = x[i8];\
	t3 = mulf (t5, sm3);\
	t6 = x[i4];\
	if (ind)\
		t6 >>= 1;\
	t5 += t6;\
	t4 = mulf (t6, sp3);\
	t5 = mulf (t5, cc3);\
	t3 += t5;\
	t4 += t5;\
\
	t5 = t3; t5 -= t1;\
	t6 = x[i2] >> 1;\
	tt = t5; tt -= t6; x[i7] = tt;\
	         t5 += t6; x[i4] = t5;\
	t5 = t2; t5 += t4;\
	t6 = x[i6] >> 1;\
	tt = t5; tt -= t6; x[i3] = tt;\
	         t5 += t6; x[i8] = t5;\
	t5 = t1; t5 += t3;\
	t6 = x[i1] >> 1;\
	tt = t6; tt -= t5; x[i6] = tt;\
	         t5 += t6; x[i1] = t5;\
	t5 = t2; t5 -= t4;\
	t6 = x[i5] >> 1;\
	tt = t6; tt -= t5; x[i5] = tt;\
	         t6 += t5; x[i2] = t6;

#define _fft7(i1,i2) \
	lt1 = x[i2];\
	lt1 *= lt1;\
	qf[i1] = lt1 >> 16;

#define _fft8(i1,i2,i3) \
	lt1 = x[i2];\
	lt1 *= lt1;\
	lt2 = x[i3];\
	lt2 *= lt2;\
	lt1 += lt2; qf[i1] = lt1 >> 16;
