/*--------------------------- fft2.c ---------------------------------- */
/*                                                                      */
/* Author:      Eyal Lebedinsky                                         */
/* Date:        May 1990                                                */
/* Version:     9 June 1991                                             */
/*                                                                      */
/* Example for using the output of fftg.c                               */
/* To use this program you need to provide at least:                    */
/*      move(x,y)                                                       */
/*      draw(x,y,color)                                                 */
/* Where x is 0-535 and y is 0-345 (or scale the constants...) and      */
/* color is WHILE or BLACK. Then ignore the other vx*() calls.          */
/*                                                                      */
/* This program is released into the public domain.                     */
/*                                                                      */
/* Amiga modification and general cleanup by Udi Finkelstein, 26/8/91   */
/*                                                                      */
/*----------------------------------------------------------------------*/

#include <stdio.h>

#ifdef AMIGA
#include <proto/exec.h>
#include <proto/graphics.h>
#include <proto/intuition.h>
#include <intuition/intuition.h>

struct IntuitionBase *IntuitionBase;
struct GfxBase *GfxBase;
struct RastPort *rp;
struct Screen *screen;
struct Window *window;

struct NewScreen NS = {
	0,0,
	640,400,
	2,
	0,1,
	HIRES|LACE,
	CUSTOMSCREEN,
	NULL,
	"FFT demo",
	NULL,
	NULL
};

struct NewWindow NW = {
	0,1,
	640,399,
	0,1,
	GADGETDOWN+GADGETUP,
	SIMPLE_REFRESH+BORDERLESS+ACTIVATE,
	NULL,
	NULL,
	"FFT demo",
	NULL,
	NULL,
	5,5,
	-1,-1,
	CUSTOMSCREEN
};

#define BLACK 0
#define WHITE 1

#define move(x,y)	Move (rp, (long)(x), (long)((y) + 30))

void draw(x,y,c)
int x, y, c;
{
	SetAPen(rp, c);
	Draw (rp, (long)x, (long)(y + 30));
}

/*
 * Free all the resources allocated before we quit
 */
void cleanup()
{
	if (window) CloseWindow(window);
	if (screen) CloseScreen(screen);
	if (GfxBase) CloseLibrary(GfxBase);
	if (IntuitionBase) CloseLibrary(IntuitionBase);
}

/*
 * Exit with an error message
 */
void cleanexit(s, err)
UBYTE *s;
int err;
{
	if (*s) puts(s);
	cleanup();
	exit(err);
}

#else
/* presumably for MSDOS/Microsoft C */

#include <graph.h>
#define move(x,y)	_moveto (x, y)
#define draw(x,y,c)	_lineto (x, y)
static struct videoconfig vc;

#endif

#define SC15 32768

#define M 8
#define N (1 << M)

short x[N+1] = {0};				 /* fp(16,0)  */
short qf[(N/2)+1] = {0};			 /* fp(16,0)  */

static long in[N];				 /* fp(32,0)  */

main (argc)
int argc;
{
	int i, j, k, m, n;
	short dd, dh, dl, y, t ,o;			  /* fp(16,0)  */
	long qq, mf;			  /* fp(32,0)  */
	float flt;
	char ns[30], fname[35];
	FILE *fin;

	/* initialise   */

	m = M;
	n = 1 << m;

#ifdef AMIGA
	if (!(IntuitionBase = (struct IntuitionBase *)OpenLibrary("intuition.library",33)))
		cleanexit ("Open Intuition Library failed!\n", 10);

	if (!(GfxBase = (struct GfxBase *)OpenLibrary("graphics.library",33)))
		cleanexit ("Open Graphics Library failed!\n", 10);

	if (!(screen = (struct Screen *)OpenScreen(&NS)))
		cleanexit ("Open Screen failed!\n", 10);

	NW.Screen = screen;

	if (!(window = (struct Window *)OpenWindow(&NW)))
		cleanexit ("Open Window failed!\n", 10);

	rp = window->RPort;

#else

   if (_setvideomode (_HERCMONO) == 0) {
      printf ("cannot set HERCMONO mode.\n");
      exit (4);
   }

   _getvideoconfig (&vc);

#endif

	/* end initialise */

	for (;;) {
		printf ("\nWHICH DATA FILE TO BE USED ");
		scanf (" %s", ns);
		if (strcmp (ns, "end") == 0) {
#ifdef AMIGA
			cleanup();
#else
/*    vxclose ();*/
      _setvideomode (_DEFAULTMODE);
#endif
			exit (0);
		}
		if (*ns == '\0')
			strcpy (ns, "DATA1");

		strcpy (fname, ns);
		strcat (fname, ".fft");
		fin = fopen (fname, "r");
		if (fin == NULL) {
			perror (fname);
			continue;
		}

		fscanf (fin, " %u", &i);             /* ignore count */

		fscanf (fin, " %f", &flt);
		mf = dh = dl = in[0] = dd = flt * 32;

		for (i = 1; i < n; ++i) {
			fscanf (fin, " %f", &flt);
			mf += in[i] = dd = flt * 32;
			if (dd > dh) dh = dd;
			if (dd < dl) dl = dd;
		}
		fclose(fin);

		y = mf / n;

		qq = dh - dl;
		if (qq != 0) {   /* scale to maximum */
			for (i = 0; qq < SC15; ++i, qq <<= 1);
		}
		else
			i = 0;

		for (j = 0; j < n; ++j)
			x[j+1] = (in[j] - y) << i;

		/* end preprocessing */

#ifdef AMIGA
		move(0, 0);
		ClearScreen(rp);
#else
/*
   if (vxopen (NULL) < 0) {
      fprintf (stderr, "could not open vx\n");
      exit (0);
   }
*/
/* vxinit ();*/
/* vxclear (BLACK);*/
   _clearscreen (_GCLEARSCREEN);
#endif

		move (15,     40*2);
		draw (15+512, 40*2, WHITE);
		draw (15+512, 1, WHITE);
		draw (15,     1, WHITE);
		draw (15,     40*2, WHITE);

		move (15, 40);
		for (i = 0; i < n; ++i)
			draw (16 + i + i, 40 - (x[i+1] >> 10), WHITE);

		move (15,       330);  /* X axis */
		draw (15+13*40, 330, WHITE);
		for (i = 0; i <= 130*4; i += 4) {
			move (15+i, 330);
			if (i%(50*4) == 0)	       /* every 50 */
				draw (15+i, 330+15, WHITE);
			else if (i%(10*4) == 0)	       /* every 10 */
				draw (15+i, 330+10, WHITE);
			else if (i%(5*4) == 0)	       /* every 5  */
				draw (15+i, 330+5, WHITE);
			else			       /* every 1  */
				draw (15+i, 330+2, WHITE);
		}

		move (15, 330);  /* Y axis */
		draw (15, 330-220, WHITE);
		for (i = 0; i <= 220; i += 220/10) {
			move (15, 330-i);
			draw ((i%5) ? 15-5 : 15-10, 330-i, WHITE);
		}

/* end screen layout */
		if (argc > 1) {
			short	xx[256];
			long	lapse;

			memcpy (xx, x, sizeof (xx));
			lapse = time (NULL);
			for (i = 0; i < 10000; ++i) {
				memcpy (x, xx, sizeof (x));
				if (argc < 3)
					fft ();
			}
			lapse = time (NULL) - lapse;
			printf ("time: %lu\n", lapse);
			memcpy (x, xx, sizeof (x));
		}

		fft ();
/*
		for (i = 0; i <= n/2; ++i) {
			printf ("%u= %d ", i, qf[i]);
			if (!(i % 5))
			printf ("\n");
		}
		printf ("\n");
*/

		k = 0;
		for (i = 1; i <= n/2; ++i) {
			if (k < qf[i])
			k = qf[i];
		}
/*		printf ("k= %d\n", k);*/
		if (k == 0)
		k = 1;

		t = 15;   o = 1 << (10 - m);
		for (i = 1; i <= (n/2); ++i) {
			j  = (qf[i] * 220L) / k;
			t = t + o;
			move (t, 330);
			draw (t, 330 -  j, WHITE);
		}

	}
}
