/*
 * fftime.c - time the FFT routine.
 *
 * link this code with your favourite version of fft().
 */

#include <stdio.h>
#include <time.h>

#define MAXFFTSIZE 4096

short x[MAXFFTSIZE], qf[MAXFFTSIZE], xback[MAXFFTSIZE];

main()
{
int i, j;
long t1, t2, t3, t4;

	srand(time(0));
	printf("Generating data set...\n");
	for (i = 0; i < MAXFFTSIZE;) xback[i++] = rand();

/* measure the buffer copy and loop time */
	time(&t1);
	for (j = 0; j < 1000; j++)
		for (i = 0; i < MAXFFTSIZE; i++) x[i] = xback[i];
	time(&t2);

/* measure the fft() time plus the buffer copy and loop time */
	printf("Timing fft(), looping 1,000 times...\n");
	time(&t3);
	for (j = 0; j < 1000; j++) {
		for (i = 0; i < MAXFFTSIZE; i++) x[i] = xback[i];
		fft();
	}
	time(&t4);

	printf("Each fft() call took %d milli-seconds\n", ((t4 - t3) - (t2 - t1)));
}
