/* ------------------------- fftoutc.c -------------------------------- */
/*									*/
/* Author:	Eyal Lebedinsky						*/
/* Date:	May 1990						*/
/* Version:	9 June 1991						*/
/*									*/
/* called from fftg.c and generates C output				*/
/* uses the header "fftsubs.h" 						*/
/*									*/
/* This program is released into the public domain.			*/
/*									*/
/*----------------------------------------------------------------------*/

#include <stdio.h>
#define S(x) (unsigned short)((x) & 0xffff)

static int	label = 0;

void
start_fft (file_name, ep_name)
char	*file_name, *ep_name;
{
	char	fname[256];

	strcpy (fname, file_name);
	strcat (fname, ".c");

	freopen (fname, "wt", stdout);
	printf ("#include \"fftsubs.h\"\n");
	printf ("void %s(){\n", ep_name);
	printf ("init\n");
}

void
end_fft (file_name, ep_name)
char	*file_name, *ep_name;
{
	printf ("}\n");
	close (stdout);
}

void
fft1 (i1)
int	i1;
{
	printf ("_fft1(%d)\n", i1);
}

void
fft2 (i1, i2)
int	i1, i2;
{
	printf ("_fft2(%d,%d)\n", i1, i2);
}

void
fft3 (i1, i3, i4)
int	i1, i3, i4;
{
	printf ("_fft3(%d,%d,%d)\n", i1, i3, i4);
}

void
fft4 (i1, i2, i3, i4, cc1)
int	i1, i2, i3, i4, cc1;
{
	printf ("_fft4(%d,%d,%d,%d,0x%04x)\n", i1, i2, i3, i4, (short)cc1);
}

void
fft5 (i1, i2, i3, i4, i5, i6, i7, i8, sm1, sp1, cc1, sm3, sp3, cc3, ind)
int	i1, i2, i3, i4, i5, i6, i7, i8, sm1, sp1, cc1, sm3, sp3, cc3, ind;
{
	printf ("_fft5(%d,%d,%d,%d,%d,%d,%d,%d,",
		i1, i2, i3, i4, i5, i6, i7, i8);
	printf ("0x%04x,0x%04x,0x%04x,0x%04x,0x%04x,0x%04x,%d)\n",
		S(sm1), S(sp1), S(cc1), S(sm3), S(sp3), S(cc3), ind);
}

void
fft7 (i1, i2)
int	i1, i2;
{
	printf ("_fft7(%d,%d)\n", i1, i2);
}

void
fft8 (i1, i2, i3)
int	i1, i2, i3;
{
	printf ("_fft8(%d,%d,%d)\n", i1, i2, i3);
}
