/* ------------------------- fftsubs.c -------------------------------- */
/*									*/
/* Author:	Eyal Lebedinsky						*/
/* Date:	May 1990						*/
/* Version:	9 June 1991						*/
/*									*/
/* called from the output of fftgf at run time				*/
/*									*/
/* This program is released into the public domain.			*/
/*									*/
/*----------------------------------------------------------------------*/

#define mulf(x,y) (((long)(x) * (long)(y)) >> 16)
#define STATIC

extern short x[], qf[];

STATIC void
_fft1 (i)
int	i;
{
	x[i] >>= 1;
}

STATIC void
_fft2 (i0, i1)
int	i0, i1;
{
	register short	t0, t1;

	t0 = x[i0] >> 1;
	t1 = x[i1] >> 1;
	x[i0] = t0 + t1;
	x[i1] = t0 - t1;
}

STATIC void
_fft3 (i1, i3, i4)
int	i1, i3, i4;
{
	register short	tt, t1, t3, t4;

	t1 = x[i1] >> 1;
	t3 = x[i3] >> 1;
	t4 = x[i4] >> 1;
	tt    = (t4 + t3) >> 1;
	x[i4] = (t4 - t3) >> 1;
	x[i3] =  t1 - tt;
	x[i1] =  t1 + tt;
}

STATIC void
_fft4 (i1, i2, i3, i4, cc1)
int	i1, i2, i3, i4, cc1;
{
	register short	t1, t2, t3, t4, tt1, tt2;

	t1 = x[i1] >> 2;
	t2 = x[i2] >> 1;
	t3 = mulf (x[i3], cc1);
	t4 = mulf (x[i4], cc1);
	tt1 = t3 + t4;
	tt2 = t3 - t4;
	x[i4] =  t2 - tt1;
	x[i3] = -t2 - tt1;
	x[i2] =  t1 - tt2;
	x[i1] =  t1 + tt2;
}

STATIC void
_fft5 (i1, i2, i3, i4, i5, i6, i7, i8, sm1, sp1, cc1, sm3, sp3, cc3, ind)
int	i1, i2, i3, i4, i5, i6, i7, i8, sm1, sp1, cc1, sm3, sp3, cc3, ind;
{
	register short	t1, t2, t3, t4, t5, t6;

	t5 = x[i7];
	t1 = mulf (t5, sm1);
	t6 = x[i3];
	if (ind)
		t6 >>= 1;
	t5 += t6;
	t2 = mulf (t6, sp1);
	t5 = mulf (t5, cc1);
	t1 += t5;
	t2 += t5;

	t5 = x[i8];
	t3 = mulf (t5, sm3);
	t6 = x[i4];
	if (ind)
		t6 >>= 1;
	t5 += t6;
	t4 = mulf (t6, sp3);
	t5 = mulf (t5, cc3);
	t3 += t5;
	t4 += t5;

	t5	= t3 - t1;
	t6	=  x[i2] >> 1;
	x[i7] = -t6 + t5;
	x[i4] =  t6 + t5;
	t5	= t2 + t4;
	t6	=  x[i6] >> 1;
	x[i3] = -t6 + t5;
	x[i8] =  t6 + t5;
	t5	= t1 + t3;
	t6	=  x[i1] >> 1;
	x[i6] =  t6 - t5;
	x[i1] =  t6 + t5;
	t5	= t2 - t4;
	t6	=  x[i5] >> 1;
	x[i5] =  t6 - t5;
	x[i2] =  t6 + t5;
}

STATIC void
_fft7 (i1, i2)
int	i1, i2;
{
	register long	t1;

	t1 = x[i2] << 1;
	t1 = t1 * t1;
	qf[i1] = t1 >> 16;
}

STATIC void
_fft8 (i1, i2, i3)
int	i1, i2, i3;
{
	register long	t1, t2;

	t1 = x[i2] << 1;
	t1 = t1 * t1;
	t2 = x[i3] << 1;
	t2 = t2 * t2;
	qf[i1] = (t1 + t2) >> 16;
}
