;****************************************************************
;**           :
;** Project   : Personal Logic Debugger (PLD)
;** Filename  : MACROS.ASM
;** Author    : Don Lekei
;** Status    : Experimental
;** Date      : 08/27/93
;** Purpose   : Misc macros needed by this application
;**           :
;****************************************************************
;

;**********************************************************************
;*  
;* Usage:  DISPLAY "string"  
;* Macro to display a string on the LCD. Setsup and calls DISPLAY_STR 
;* Places string into seg ROMDATA.
;*  
;**********************************************************************
DISPLAY .macro *[1]		;display 8 digit message on LCD
	.seg	ROMDATA		;area for string
..sos:          		;start of string
	.TEXTL	[1]		;user message LEN, STRING
..los	= *-..sos		;length of string

	.if (..los>9)
	 .error "String > 8 digits"
	.endif
	.oldseg			;back to code area

	movlw	<..sos		;start of string
	call	DISPLAY_STR	;call display routine
	.endm

