/* tab.h - interface to tab.c
   Copyright (C) 2001 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.  */

/* Written by Marc Tardif <intmktg@cam.org>.  */

#ifndef TAB_H
#define TAB_H

#define MAX(a,b) ((a)>(b) ? (a) : (b))
#define MIN(a,b) ((a)<(b) ? (a) : (b))

#define nop ((void)0)

#define find_first()                                                         \
  do                                                                         \
    {                                                                        \
      ret = ac_first (c);                                                    \
      if (ret > 0)                                                           \
        goto fin;                                                            \
    }                                                                        \
  while (0)

#define find_maybe()                                                         \
  do                                                                         \
    {                                                                        \
      ret = ac_maybe (c);                                                    \
      if (ret > 0)                                                           \
        goto fin;                                                            \
    }                                                                        \
  while (0)

#define find_next()                                                          \
  do                                                                         \
    {                                                                        \
      ret = ac_next (c);                                                     \
      if (ret < 0)                                                           \
        table = word;                                                        \
      else if (ret > 0)                                                      \
        goto fin;                                                            \
    }                                                                        \
  while (0)

#define find_space()                                                         \
  do                                                                         \
    {                                                                        \
      ret = ac_next (' ');                                                   \
      if (ret < 0)                                                           \
        table = space;                                                       \
      else if (ret > 0)                                                      \
        goto fin;                                                            \
    }                                                                        \
  while (0)

#define find_last()                                                          \
  do                                                                         \
    {                                                                        \
      ret = 0;                                                               \
      goto fin;                                                              \
    }                                                                        \
  while (0)

extern unsigned char tab[];

#endif

