/* LocaleInformation_nn.java --
   Copyright (C) 2004  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_nn extends ListResourceBundle
{
  private static final String currenciesDisplayNameKeys = "NOK";

  private static final String currenciesDisplayNameValues = "NOK";

  private static final Hashtable currenciesDisplayName;
  static
  {
    currenciesDisplayName = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesDisplayNameKeys, "|");
    Enumeration values = new StringTokenizer(currenciesDisplayNameValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesDisplayName.put(key, value);
      }
  }

  private static final String currenciesSymbolKeys = "NOK";

  private static final String currenciesSymbolValues = "kr";

  private static final Hashtable currenciesSymbol;
  static
  {
    currenciesSymbol = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesSymbolKeys, "|");
    Enumeration values = new StringTokenizer(currenciesSymbolValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesSymbol.put(key, value);
      }
  }

  private static final String[] shortMonths = {
    "jan",
    "feb",
    "mar",
    "apr",
    "mai",
    "jun",
    "jul",
    "aug",
    "sep",
    "okt",
    "nov",
    "des",
    null,
  };

  private static final String[] months = {
    "januar",
    "februar",
    "mars",
    "april",
    "mai",
    "juni",
    "juli",
    "august",
    "september",
    "oktober",
    "november",
    "desember",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "su",
    "m\u00e5",
    "ty",
    "on",
    "to",
    "fr",
    "la",
  };

  private static final String[] weekdays = {
    null,
    "sundag",
    "m\u00e5ndag",
    "tysdag",
    "onsdag",
    "torsdag",
    "fredag",
    "laurdag",
  };

  private static final String[] eras = {
    "f.Kr.",
    "e.Kr.",
  };

  private static final String territoriesKeys = "TL|TK|TJ|TH|TG|TF|GY|TD|TC|GW|GU|GT|GS|GR|GQ|GP|SZ|SY|GN|GM|GL|SV|ST|GI|GH|SR|GF|SP|GE|SO|GD|SN|SM|GB|SL|GA|SK|SJ|SI|SH|SG|SE|SD|SC|SB|SA|FR|FO|FM|RW|FK|RU|FJ|FI|RO|RE|ET|ES|ER|EH|EG|EE|EC|DZ|QA|DO|PY|DM|PW|DK|DJ|PT|PS|PR|DE|PN|PM|PL|PK|PH|PG|PF|CZ|PE|CY|CX|CV|PA|CU|CR|CO|CN|CM|CL|CK|CI|CH|CG|CF|CD|CC|OM|CA|BZ|BY|BW|BV|BT|BS|BR|NZ|BO|BN|BM|NU|BJ|BI|BH|NR|BG|BF|NP|BE|NO|BD|BB|ZW|NL|BA|NI|NG|NF|AZ|NE|NC|AW|ZM|NA|AU|AT|AS|AR|AQ|MZ|AO|MY|AN|MX|AM|MW|AL|MV|ZA|MU|MT|AI|MS|MR|AG|MQ|AF|MP|AE|MO|AD|MN|MM|ML|MK|YU|YT|MH|MG|MD|MC|MA|YE|LY|LV|LU|LT|LS|LR|LK|LI|LC|LB|LA|KZ|KY|KW|KR|KP|KN|KM|KI|WS|KH|KG|KE|WF|JP|JO|JM|VU|VN|VI|VG|VE|VC|VA|IT|IS|IR|IQ|UZ|IO|UY|IN|IL|US|IE|ID|UM|UG|UA|HU|HT|HR|TZ|HN|HM|TW|TV|HK|TT|TR|TO|TN|TM";

  private static final String territoriesValues = "\u00d8st-Timor|Tokelau|Tadsjikistan|Thailand|Togo|Franske s\u00f8romr\u00e5der|Guyana|Tchad|Turks- og Caicos\u00f8yene|Guinea-Bissau|Guam|Guatemala|S\u00f8r-Georgia og S\u00f8r-Sandwich-\u00f8yene|Hellas|Ekvatorial-Guinea|Guadeloupe|Swaziland|Syria|Guinea|Gambia|Gr\u00f8nland|El Salvador|Sao Tome og Principe|Gibraltar|Ghana|Surinam|Fransk Guyana|Serbia|Georgia|Somalia|Grenada|Senegal|San Marino|Storbritannia|Sierra Leone|Gabon|Slovakia|Svalbard og Jan Mayen|Slovenia|Saint Helena|Singapore|Sverige|Sudan|Seychellene|Salomon\u00f8yene|Saudi Arabia|Frankrike|F\u00e6r\u00f8yene|Mikronesiaf\u00f8derasjonen|Rwanda|Falklands\u00f8yene (Malvinas)|Den russiske f\u00f8derasjon|Fiji|Finland|Romania|Reunion|Etiopia|Spania|Eritrea|Vest-Sahara|Egypt|Estland|Ecuador|Algerie|Qatar|Den dominikanske republikk|Paraguay|Dominica|Palau|Danmark|Djibouti|Portugal|Palestinsk territorium|Puerto Rico|Tyskland|Pitcairn|St. Pierre og Miquelon|Polen|Pakistan|Filippinene|Papua Ny-Guinea|Fransk Polynesia|Tsjekkia|Peru|Kypros|Christmas\u00f8ya|Kapp Verde|Panama|Cuba|Costa Rica|Colombia|Kina|Kamerun|Chile|Cook\u00f8yene|Elfenbenskysten|Sveits|Kongo|Den sentralafrikanske republikk|Kongo, Den demokratiske republikken|Kokos\u00f8yene (Keeling\u00f8yene)|Oman|Canada|Belize|Hviterussland|Botswana|Bouvet\u00f8ya|Bhutan|Bahamas|Brasil|New Zealand|Bolivia|Brunei Darussalam|Bermuda|Niue|Benin|Burundi|Bahrain|Nauru|Bulgaria|Burkina Faso|Nepal|Belgia|Noreg|Bangladesh|Barbados|Zimbabwe|Nederland|Bosnia og Hercegovina|Nicaragua|Nigeria|Norfolk\u00f8yene|Aserbajdsjan|Niger|Ny-Caledonia|Aruba|Zambia|Namibia|Australia|\u00d8sterrike|Amerikansk Samoa|Argentina|Antarktis|Mosambik|Angola|Malaysia|De nederlandske antiller|Mexico|Armenia|Malawi|Albania|Maldivene|S\u00f8r-Afrika|Mauritius|Malta|Anguilla|Montserrat|Mauritania|Antigua og Barbuda|Martinique|Afghanistan|Nord-Marianene|De forente arabiske emiratene|Macao S.A.R. (Kina)|Andorra|Mongolia|Myanmar|Mali|Makedonia, Republikken|Jugoslavia|Mayotte|Marshall\u00f8yene|Madagaskar|Moldova|Monaco|Marokko|Yemen|Libya|Latvia|Luxembourg|Litauen|Lesotho|Liberia|Sri Lanka|Liechtenstein|St. Lucia|Libanon|Laos, Den folkedemokratiske republikken|Kasakhstan|Cayman\u00f8yene|Kuwait|S\u00f8r-Korea|Nord-Korea|St. Christopher og Nevis|Komorene|Kiribati|Samoa|Kambodsja|Kirgisistan|Kenya|Wallis og Futuna|Japan|Jordan|Jamaica|Vanuatu|Vietnam|Jomfru\u00f8yene (USA)|Jomfru\u00f8yene (britisk)|Venezuela|St. Vincent og Grenadinene|Vatikanstaten|Italia|Island|Iran|Irak|Usbekistan|Britiske omr\u00e5der i det indiske hav|Uruguay|India|Israel|USA|Irland|Indonesia|USAs mindre \u00f8yer|Uganda|Ukraina|Ungarn|Haiti|Kroatia|Tanzania|Honduras|Heard- og McDonalds\u00f8yene|Taiwan|Tuvalu|Hong Kong S.A.R. (Kina)|Trinidad og Tobago|Tyrkia|Tonga|Tunisia|Turkmenistan";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "|");
    Enumeration values = new StringTokenizer(territoriesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "nb|no|nn";

  private static final String languagesValues = "norsk bokm\u00e5l|norsk|norsk nynorsk";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "|");
    Enumeration values = new StringTokenizer(languagesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "decimalSeparator", "," },
    { "groupingSeparator", "\u00a0" },
    { "currenciesDisplayName", currenciesDisplayName },
    { "currenciesSymbol", currenciesSymbol },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "eras", eras },
    { "shortDateFormat", "dd.MM.yy" },
    { "mediumDateFormat", "d. MMM. yyyy" },
    { "longDateFormat", "d. MMMM yyyy" },
    { "fullDateFormat", "EEEE d. MMMM yyyy" },
    { "shortTimeFormat", "HH.mm" },
    { "mediumTimeFormat", "HH.mm.ss" },
    { "longTimeFormat", "HH.mm.ss z" },
    { "fullTimeFormat", "'kl. 'HH.mm.ss z" },
    { "territories", territories },
    { "languages", languages },
  };

  public Object[][] getContents() { return contents; }
}
