/*
 * EDMA: Entorno de Desarrollo Modular y Abierto
 * Object Oriented and Componetware Framework
 * Copyright (C) 1998, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2010, 2013
 *    David Martnez Oliveira
 *
 * This file is part of EDMA.
 *
 * EDMA is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * EDMA is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with EDMA.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
**************************************************
    Entorno de Desarrollo Modular y Abierto (EDMA)
    EDMA 0.5.1r1
    (c) David Martnez Oliveira
    File generated by : EDMA IDF Wizard Gnomized 0.1
------------------------------------------------------
    Module Type : CLASS IMPLEMENTATION
    Class List  : FD_SET
    Description : File Descriptor Set
    Author      : David Martnez Oliviera
    Date        : October 15, 2000
-----------------------------------------------------
  REVISIONS :
***************************************************
*/
 
/*
***************************************************
  General Header Files
***************************************************
*/
 
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
/*
***************************************************
  EDMA Header Files
***************************************************
*/
 
#include <edma.h>

#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>

/*
***************************************************
  Private Data Struct for class FD_SET
***************************************************
*/
 
typedef struct
  {
    fd_set		*write;
    fd_set		*read;
    fd_set		*exception;
    ESint32		max_fd;
    EUint32             sec;
    EUint32             usec;
}DtFD_SET;
/*
***************************************************
  Method Declaration for class max_fd
***************************************************
*/
 
ESint32 EDMAPROC 
FD_SETreset (OBJID IdObj)
{
  DtFD_SET	*m;

  m = (DtFD_SET*) edma_get_data_ref (IdObj);
  /*Build dynamically fd_sets*/

  if (m->read)
    free (m->read);
  if (m->write)
    free (m->write);
  if (m->exception)
    free (m->exception);

  m->read = (fd_set *) malloc (sizeof(fd_set));
  m->write = (fd_set *) malloc (sizeof(fd_set));
  m->exception = (fd_set *) malloc (sizeof(fd_set));
  FD_ZERO(m->read);
  FD_ZERO(m->write);
  FD_ZERO(m->exception);
  m->max_fd = 0;
  m->sec = 0;
  m->usec = 0;

  return 0;
}


ESint32 EDMAPROC 
FD_SETselect (OBJID IdObj)
{
  DtFD_SET	*m;
  struct timeval *t,to;
  ESint32        n;

  m = (DtFD_SET*) edma_get_data_ref (IdObj);
  if ((m->sec == 0) && (m->usec == 0))
    t = NULL;
  else
    {
      to.tv_sec = m->sec;
      to.tv_usec = m->usec;
      t = &to;
    }
   n = select (m->max_fd + 1, m->read, m->write, m->exception, t);
  return n;
}


ESint32 EDMAPROC 
FD_SETcheck4readO (OBJID IdObj,OBJID obj)
{
  DtFD_SET	*m;
  ESint32       s;

  m = (DtFD_SET*) edma_get_data_ref (IdObj);
  edma_rprop3 (obj, "s", &s);
  if (FD_ISSET(s,m->read))
    return 1;
  else
    return 0;
}


ESint32 EDMAPROC 
FD_SETcheck4writeO (OBJID IdObj, OBJID obj)
{
  DtFD_SET	*m;
  ESint32       s;
  
  m = (DtFD_SET*) edma_get_data_ref (IdObj);
  edma_rprop3 (obj, "s", &s);

  if (FD_ISSET(s,m->write))
    return 1;
  else
    return 0;
}


ESint32 EDMAPROC 
FD_SETcheck4exceptionO (OBJID IdObj, OBJID obj)
{
  DtFD_SET	*m;
  ESint32       s;
  
  m = (DtFD_SET*) edma_get_data_ref (IdObj);
  edma_rprop3 (obj, "s", &s);
  if (FD_ISSET(s,m->write))
    return 1;
  else
    return 0;
}


ESint32 EDMAPROC 
FD_SETadd4readO (OBJID IdObj, OBJID obj)
{
  DtFD_SET	*m;
  ESint32       s;
  
  m = (DtFD_SET*) edma_get_data_ref (IdObj);
  edma_rprop3 (obj, "s", &s);

  FD_SET(s,m->read);
  if (s > m->max_fd)
    m->max_fd = s;

  return 0;
}


ESint32 EDMAPROC 
FD_SETadd4writeO (OBJID IdObj, OBJID obj)
{
  DtFD_SET	*m;
  ESint32       s;
  
  m = (DtFD_SET*) edma_get_data_ref (IdObj);
  edma_rprop3 (obj, "s", &s);
  FD_SET(s,m->write);

  if (s > m->max_fd)
    m->max_fd = s;

  return 0;
}


ESint32 EDMAPROC 
FD_SETadd4exceptionO (OBJID IdObj, OBJID obj)
{
  DtFD_SET	*m;
  ESint32       s;

  m = (DtFD_SET*) edma_get_data_ref (IdObj);

  edma_rprop3 (obj, "s", &s);
  FD_SET(s,m->write);

  if (s > m->max_fd)
    m->max_fd = s;

  return 0;
}


ESint32 EDMAPROC 
FD_SETset_timeoutS32S32 (OBJID IdObj, ESint32 s, ESint32 us)
{
  DtFD_SET	*m;
  
  m = (DtFD_SET*) edma_get_data_ref (IdObj);
  
  m->sec = s;
  m->usec = us;

  return 0;
}


ESint32 EDMAPROC 
FD_SETrip (OBJID IdObj)
{
  DtFD_SET	*m;
  
  m = (DtFD_SET*) edma_get_data_ref (IdObj);

  free (m->read);
  free (m->write);
  free (m->exception);

  return 0;
}
/********** END C IMPLEMENTATION SKELETON ******************/
