#!/bin/sh
#
#  DO NOT EDIT THIS FILE - it has been generated
#
# Install modified versions of certain ANSI-incompatible system header
# files which are fixed to work correctly with ANSI C and placed in a
# directory that GNU C will search.
#
# This script contains 103 fixup scripts.
#
# See README-fixinc for more information.
#
#  fixincludes copyright (c) 1999 The Free Software Foundation, Inc.
#
# fixincludes is free software.
# 
# You may redistribute it and/or modify it under the terms of the
# GNU General Public License, as published by the Free Software
# Foundation; either version 2, or (at your option) any later version.
# 
# fixincludes is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with fixincludes.  See the file "COPYING".  If not,
# write to:  The Free Software Foundation, Inc.,
#            59 Temple Place - Suite 330,
#            Boston,  MA  02111-1307, USA.
#
# # # # # # # # # # # # # # # # # # # # #
#
# Directory in which to store the results.
# Fail if no arg to specify a directory for the output.
if [ "x$1" = "x" ]
then echo fixincludes: no output directory specified
exit 1
fi

LIB=${1}
shift

# Make sure it exists.
if [ ! -d $LIB ]; then
  mkdir $LIB || {
    echo fixincludes:  output dir '`'$LIB"' cannot be created"
    exit 1
  }
else
  ( cd $LIB && touch DONE && rm DONE ) || {
    echo fixincludes:  output dir '`'$LIB"' is an invalid directory"
    exit 1
  }
fi

# Define what target system we're fixing.
#
if test -r ./Makefile; then
  target_canonical="`sed -n -e 's,^target[ 	]*=[ 	]*\(.*\)$,\1,p' < Makefile`"
fi

# If not from the Makefile, then try config.guess
#
if test -z "${target_canonical}" ; then
  if test -x ./config.guess ; then
    target_canonical="`config.guess`" ; fi
  test -z "${target_canonical}" && target_canonical=unknown
fi
export target_canonical

# # # # # # # # # # # # # # # # # # # # #
#
# Define PWDCMD as a command to use to get the working dir
# in the form that we want.
PWDCMD=pwd

case "`$PWDCMD`" in
//*)
    # On an Apollo, discard everything before `/usr'.
    PWDCMD="eval pwd | sed -e 's,.*/usr/,/usr/,'"
    ;;
esac

# Original directory.
ORIGDIR=`${PWDCMD}`

# Make LIB absolute only if needed to avoid problems with the amd.
case $LIB in
/*)
    ;;
*)
    cd $LIB; LIB=`${PWDCMD}`
    ;;
esac

echo Fixing headers into ${LIB} for ${target_canonical} target

# Determine whether this system has symbolic links.
if ln -s X $LIB/ShouldNotExist 2>/dev/null; then
  rm -f $LIB/ShouldNotExist
  LINKS=true
elif ln -s X /tmp/ShouldNotExist 2>/dev/null; then
  rm -f /tmp/ShouldNotExist
  LINKS=true
else
  LINKS=false
fi

# # # # # # # # # # # # # # # # # # # # #
#
#  Search each input directory for broken header files.
#  This loop ends near the end of the file.
#
if test $# -eq 0
then
    INPUTLIST="/usr/include"
else
    INPUTLIST="$@"
fi

for INPUT in ${INPUTLIST} ; do

cd ${ORIGDIR}

cd ${INPUT} || continue
INPUT=`${PWDCMD}`

#
# # # # # # # # # # # # # # # # # # # # #
#
echo Finding directories and links to directories

# Find all directories and all symlinks that point to directories.
# Put the list in $all_dirs.
# Each time we find a symlink, add it to newdirs
# so that we do another find within the dir the link points to.
# Note that $all_dirs may have duplicates in it;
# later parts of this file are supposed to ignore them.
dirs="."
levels=2
all_dirs=""
search_dirs=""

while [ -n "$dirs" ] && [ $levels -gt 0 ]
do
  levels=`expr $levels - 1`
  newdirs=
  for d in $dirs
  do
    echo " Searching $INPUT/$d"

    # Find all directories under $d, relative to $d, excluding $d itself.
    # (The /. is needed after $d in case $d is a symlink.)
    all_dirs="$all_dirs `find $d/. -type d -print | \
               sed -e '/\/\.$/d' -e 's@/./@/@g'`"
    # Find all links to directories.
    # Using `-exec test -d' in find fails on some systems,
    # and trying to run test via sh fails on others,
    # so this is the simplest alternative left.
    # First find all the links, then test each one.
    theselinks=
    $LINKS && \
      theselinks=`find $d/. -type l -print | sed -e 's@/./@/@g'`
    for d1 in $theselinks --dummy--
    do
      # If the link points to a directory,
      # add that dir to $newdirs
      if [ -d $d1 ]
      then
        all_dirs="$all_dirs $d1"
        if [ "`ls -ld $d1 | sed -n 's/.*-> //p'`" != "." ]
        then
          newdirs="$newdirs $d1"
          search_dirs="$search_dirs $d1"
        fi
      fi
    done
  done

  dirs="$newdirs"
done

# # # # # # # # # # # # # # # # # # # # #
#
dirs=
echo "All directories (including links to directories):"
echo $all_dirs

for file in $all_dirs; do
  rm -rf $LIB/$file
  if [ ! -d $LIB/$file ]
  then mkdir $LIB/$file
  fi
done
mkdir $LIB/root

# # # # # # # # # # # # # # # # # # # # #
#
# treetops gets an alternating list
# of old directories to copy
# and the new directories to copy to.
treetops=". ${LIB}"

if $LINKS; then
  echo 'Making symbolic directory links'
  cwd=`${PWDCMD}`

  for sym_link in $search_dirs; do
    cd ${INPUT}
    dest=`ls -ld ${sym_link} | sed -n 's/.*-> //p'`

    # In case $dest is relative, get to ${sym_link}'s dir first.
    #
    cd ./`echo ${sym_link} | sed 's;/[^/]*$;;'`

    # Check that the target directory exists.
    # Redirections changed to avoid bug in sh on Ultrix.
    #
    (cd $dest) > /dev/null 2>&1
    if [ $? = 0 ]; then
      cd $dest

      # full_dest_dir gets the dir that the link actually leads to.
      #
      full_dest_dir=`${PWDCMD}`

      # Canonicalize ${INPUT} now to minimize the time an
      # automounter has to change the result of ${PWDCMD}.
      #
      cinput=`cd ${INPUT}; ${PWDCMD}`

      # If a link points to ., make a similar link to .
      #
      if [ ${full_dest_dir} = ${cinput} ]; then
        echo ${sym_link} '->' . ': Making self link'
        rm -fr ${LIB}/${sym_link} > /dev/null 2>&1
        ln -s . ${LIB}/${sym_link} > /dev/null 2>&1

      # If link leads back into ${INPUT},
      # make a similar link here.
      #
      elif expr ${full_dest_dir} : "${cinput}/.*" > /dev/null; then
        # Y gets the actual target dir name, relative to ${INPUT}.
        y=`echo ${full_dest_dir} | sed -n "s&${cinput}/&&p"`
        # DOTS is the relative path from ${LIB}/${sym_link} back to ${LIB}.
        dots=`echo "${sym_link}" |
          sed -e 's@^./@@' -e 's@/./@/@g' -e 's@[^/][^/]*@..@g' -e 's@..$@@'`
        echo ${sym_link} '->' $dots$y ': Making local link'
        rm -fr ${LIB}/${sym_link} > /dev/null 2>&1
        ln -s $dots$y ${LIB}/${sym_link} > /dev/null 2>&1

      else
        # If the link is to a dir $target outside ${INPUT},
        # repoint the link at ${INPUT}/root$target
        # and process $target into ${INPUT}/root$target
        # treat this directory as if it actually contained the files.
        #
        echo ${sym_link} '->' root${full_dest_dir} ': Making rooted link'
        if [ -d $LIB/root${full_dest_dir} ]
        then true
        else
          dirname=root${full_dest_dir}/
          dirmade=.
          cd $LIB
          while [ x$dirname != x ]; do
            component=`echo $dirname | sed -e 's|/.*$||'`
            mkdir $component >/dev/null 2>&1
            cd $component
            dirmade=$dirmade/$component
            dirname=`echo $dirname | sed -e 's|[^/]*/||'`
          done
        fi

        # Duplicate directory structure created in ${LIB}/${sym_link} in new
        # root area.
        #
        for file2 in $all_dirs; do
          case $file2 in
            ${sym_link}/*)
              dupdir=${LIB}/root${full_dest_dir}/`echo $file2 |
                      sed -n "s|^${sym_link}/||p"`
              echo "Duplicating ${sym_link}'s ${dupdir}"
              if [ -d ${dupdir} ]
              then true
              else
                mkdir ${dupdir}
              fi
              ;;
            *)
              ;;
          esac
        done

        # Get the path from ${LIB} to ${sym_link}, accounting for symlinks.
        #
        parent=`echo "${sym_link}" | sed -e 's@/[^/]*$@@'`
        libabs=`cd ${LIB}; ${PWDCMD}`
        file2=`cd ${LIB}; cd $parent; ${PWDCMD} | sed -e "s@^${libabs}@@"`

        # DOTS is the relative path from ${LIB}/${sym_link} back to ${LIB}.
        #
        dots=`echo "$file2" | sed -e 's@/[^/]*@../@g'`
        rm -fr ${LIB}/${sym_link} > /dev/null 2>&1
        ln -s ${dots}root${full_dest_dir} ${LIB}/${sym_link} > /dev/null 2>&1
        treetops="$treetops ${sym_link} ${LIB}/root${full_dest_dir}"
      fi
    fi
  done
fi

# # # # # # # # # # # # # # # # # # # # #
#
required=
set x $treetops
shift
while [ $# != 0 ]; do
  # $1 is an old directory to copy, and $2 is the new directory to copy to.
  #
  SRCDIR=`cd ${INPUT} ; cd $1 ; ${PWDCMD}`
  export SRCDIR

  FIND_BASE=$1
  export FIND_BASE
  shift

  DESTDIR=`cd $1;${PWDCMD}`
  export DESTDIR
  shift

  # The same dir can appear more than once in treetops.
  # There's no need to scan it more than once.
  #
  if [ -f ${DESTDIR}/DONE ]
  then continue ; fi

  touch ${DESTDIR}/DONE
  echo Fixing directory ${SRCDIR} into ${DESTDIR}

  # Check files which are symlinks as well as those which are files.
  #
  cd ${INPUT}
  files=`if $LINKS; then
    find ${FIND_BASE}/. -name '*.h' \( -type f -o -type l \) -print
  else
    find ${FIND_BASE}/. -name '*.h' -type f -print
  fi | \
    sed -e 's;/\./;/;g' -e 's;//*;/;g' `

  echo Checking header files
  for file in $files; do

    # Skip unreadable files, symlinks to directories and glibc files
    if test ! -r "${file}" || test -d "${file}/." \
       || fgrep 'This file is part of the GNU C Library' "${file}" \
	    > /dev/null 2>&1; then
      continue
    fi

    fixlist=""
    DESTFILE=${DESTDIR}/`echo ${file} | sed "s;${FIND_BASE}/;;" `

    #
    # Fix   1:  Aix_Syswait
    #
    case "${file}" in ./sys/wait.h )
    if ( test -n "`egrep 'bos325,' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      aix_syswait"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e '/^extern pid_t wait3();$/i\
struct rusage;
' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix   2:  Aix_Volatile
    #
    case "${file}" in ./sys/signal.h )
    if ( test -n "`egrep 'typedef volatile int sig_atomic_t' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      aix_volatile"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's/typedef volatile int sig_atomic_t/typedef int sig_atomic_t/' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix   3:  Alpha_Getopt
    #
    case "${file}" in ./stdio.h | \
	./stdlib.h )
    if ( test -n "`egrep 'getopt\\(int, char \\*\\[' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      alpha_getopt"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's/getopt(int, char \*\[\],[ ]*char \*)/getopt(int, char *const[], const char *)/' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix   4:  Alpha_Parens
    #
    case "${file}" in ./sym.h )
    if ( test -n "`egrep '#ifndef\\(__mips64\\)' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      alpha_parens"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's/#ifndef(__mips64)/#ifndef __mips64/' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix   5:  Alpha_Sbrk
    #
    case "${file}" in ./unistd.h )
    if ( test -n "`egrep 'char[ 	]*\\*[	 ]*sbrk[ 	]*\\(' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      alpha_sbrk"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's/char\([ 	]*\*[	 ]*sbrk[ 	]*(\)/void\1/' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix   6:  Arm_Norcroft_Hint
    #
    case "${file}" in ./X11/Intrinsic.h )
    if ( test -n "`egrep '___type p_type' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      arm_norcroft_hint"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's/___type p_type/p_type/' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix   7:  Arm_Wchar
    #
    case "${file}" in ./stdlib.h )
    if ( test -n "`egrep '#[ 	]*define[ 	]*__wchar_t' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      arm_wchar"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's/\(#[ 	]*ifndef[ 	]*\)__wchar_t/\1_GCC_WCHAR_T/' \
        -e 's/\(#[ 	]*define[ 	]*\)__wchar_t/\1_GCC_WCHAR_T/' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix   8:  Aux_Asm
    #
    case "${file}" in ./sys/param.h )
    if ( test -n "`egrep '#ifndef NOINLINE' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      aux_asm"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's|#ifndef NOINLINE|#if !defined(NOINLINE) \&\& !defined(__GNUC__)|' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix   9:  Avoid_Bool
    #
    case "${file}" in ./curses.h | \
	./curses_colr/curses.h | \
	./term.h | \
	./tinfo.h )
    fixlist="${fixlist}
      avoid_bool"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e '/^#[ 	]*define[ 	][ 	]*bool[ 	][ 	]*char[ 	]*$/i\
#ifndef __cplusplus
' \
        -e '/^#[ 	]*define[ 	][ 	]*bool[ 	][ 	]*char[ 	]*$/a\
#endif
' \
        -e '/^typedef[ 	][ 	]*char[ 	][ 	]*bool[ 	]*;/i\
#ifndef __cplusplus
' \
        -e '/^typedef[ 	][ 	]*char[ 	][ 	]*bool[ 	]*;/a\
#endif
' \
        -e '/^[ ]*typedef[ 	][ 	]*unsigned char[ 	][ 	]*bool[ 	]*;/i\
#ifndef __cplusplus
' \
        -e '/^[ ]*typedef[ 	][ 	]*unsigned char[ 	][ 	]*bool[ 	]*;/a\
#endif
' \
        -e '/^typedef[ 	][ 	]*int[ 	][ 	]*bool[ 	]*;/i\
#ifndef __cplusplus
' \
        -e '/^typedef[ 	][ 	]*int[ 	][ 	]*bool[ 	]*;/a\
#endif
' \
        -e '/^[ ]*typedef[ 	][ 	]*unsigned int[ 	][ 	]*bool[ 	]*;/i\
#ifndef __cplusplus
' \
        -e '/^[ ]*typedef[ 	][ 	]*unsigned int[ 	][ 	]*bool[ 	]*;/a\
#endif
' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    ;; # case end for file name test
    esac


    #
    # Fix  10:  Bad_Struct_Term
    #
    case "${file}" in ./curses.h )
    if ( test -n "`egrep '^[ 	]*typedef[ 	]+struct[ 	]+term[ 	]*;' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      bad_struct_term"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's/^[ 	]*typedef[ 	][ 	]*\(struct[ 	][ 	]*term[ 	]*;[ 	]*\)$/\1/' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  11:  Badquote
    #
    case "${file}" in ./sundev/vuid_event.h )
    fixlist="${fixlist}
      badquote"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's/doesn'\''t/does not/' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    ;; # case end for file name test
    esac


    #
    # Fix  12:  Bad_Lval
    #
    case "${file}" in ./libgen.h | \
	./dirent.h | \
	./ftw.h | \
	./grp.h | \
	./ndbm.h | \
	./pthread.h | \
	./pwd.h | \
	./signal.h | \
	./standards.h | \
	./stdlib.h | \
	./string.h | \
	./stropts.h | \
	./time.h | \
	./unistd.h )
    fixlist="${fixlist}
      bad_lval"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's/^[ 	]*#[ 	]*define[ 	]*\([^(]*\)\(([^)]*)\)[ 	]*\(_.\)\1\2[ 	]*$/#define \1 \3\1/' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    ;; # case end for file name test
    esac


    #
    # Fix  13:  Broken_Assert_Stdio
    #
    case "${file}" in ./assert.h )
    if ( test -n "`egrep 'stderr' ${file}`" -a \
              -z "`egrep 'include.*stdio.h' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      broken_assert_stdio"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e '1i\
#include <stdio.h>
' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  14:  Broken_Assert_Stdlib
    #
    case "${file}" in ./assert.h )
    if ( test -n "`egrep 'exit *\\(|abort *\\(' ${file}`" -a \
              -z "`egrep 'include.*stdlib.h' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      broken_assert_stdlib"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e '1i\
#ifdef __cplusplus\
#include <stdlib.h>\
#endif
' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  15:  Bsd43_Io_Macros
    #
    if ( test -n "`egrep 'BSD43__IO' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      bsd43_io_macros"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e '/[ 	]BSD43__IO[A-Z]*[ 	]*(/s/(\(.\),/('\''\1'\'',/' \
        -e '/#[ 	]*define[ 	]*[ 	]BSD43__IO/s/'\''\([cgx]\)'\''/\1/g' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'


    #
    # Fix  16:  Dec_Intern_Asm
    #
    case "${file}" in ./c_asm.h )
    fixlist="${fixlist}
      dec_intern_asm"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e '/^[ 	]*float[ 	]*fasm/i\
#ifdef __DECC
' \
        -e '/^[ 	]*#[ 	]*pragma[ 	]*intrinsic([ 	]*dasm/a\
#endif
' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    ;; # case end for file name test
    esac


    #
    # Fix  17:  No_Double_Slash
    #
    if ( test -n "`egrep '(^|[^:])//[^\"*]' ${file}`" -a \
              '('  -z "`echo ${file} | egrep '(CC|cxx|\+\+)/'`" ')'
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      no_double_slash"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's,^//.*$,,' \
        -e 's,[^:]//[^"].*$,,' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'


    #
    # Fix  18:  Ecd_Cursor
    #
    case "${file}" in ./sunwindow/win_lock.h | \
	./sunwindow/win_cursor.h )
    fixlist="${fixlist}
      ecd_cursor"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's/ecd.cursor/ecd_cursor/' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    ;; # case end for file name test
    esac


    #
    # Fix  19:  Sco5_Stat_Wrappers
    #
    case "${file}" in ./sys/stat.h )
    case "$target_canonical" in i*86-*-sco3.2v5* )
    fixlist="${fixlist}
      sco5_stat_wrappers"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e '/^static int[ 	]*[a-z]*stat(/i\
#ifdef __cplusplus\
extern "C"\
{\
#endif\
' \
        -e '/^}$/a\
#ifdef __cplusplus\
}\
#endif /* __cplusplus */\
' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    ;; # case end for machine type test
    esac
    ;; # case end for file name test
    esac


    #
    # Fix  20:  End_Else_Label
    #
    if ( test -n "`egrep '^[ 	]*#[ 	]*(else|endif)[ 	]+([!-.0-z\\{\\|\\}\\~]|/[^\\*])' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      end_else_label"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e ':loop
/\\$/N
s/\\$/\\+++fixinc_eol+++/
/\\$/b loop
s/\\+++fixinc_eol+++/\\/g
s%^\([ 	]*#[ 	]*else\)[ 	][ 	]*/[^*].*%\1%
s%^\([ 	]*#[ 	]*else\)[ 	][ 	]*[^/ 	].*%\1%
s%^\([ 	]*#[ 	]*endif\)[ 	][ 	]*/[^*].*%\1%
s%^\([ 	]*#[ 	]*endif\)[ 	][ 	]**[^/].*%\1%
s%^\([ 	]*#[ 	]*endif\)[ 	][ 	]*[^/* 	].*%\1%' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'


    #
    # Fix  21:  Hp_Inline
    #
    case "${file}" in ./sys/spinlock.h )
    if ( test -n "`egrep 'include.*\"\\.\\./machine/' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      hp_inline"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's,"../machine/inline.h",<machine/inline.h>,' \
        -e 's,"../machine/psl.h",<machine/psl.h>,' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  22:  Hp_Sysfile
    #
    case "${file}" in ./sys/file.h )
    if ( test -n "`egrep 'HPUX_SOURCE' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      hp_sysfile"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's/(\.\.\.)/(struct file * ...)/' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  23:  Cxx_Unready
    #
    case "${file}" in ./sys/mman.h | \
	./rpc/types.h )
    if ( test -z "`egrep '\"C\"|__BEGIN_DECLS' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      cxx_unready"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e '1i\
#ifdef __cplusplus\
extern "C" {\
#endif\

' \
        -e '$a\
#ifdef __cplusplus\
}\
#endif
' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  24:  Hpux_Maxint
    #
    case "${file}" in ./sys/param.h )
    fixlist="${fixlist}
      hpux_maxint"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e '/^#[ 	]*define[ 	]*MAXINT[ 	]/i\
#ifndef MAXINT
' \
        -e '/^#[ 	]*define[ 	]*MAXINT[ 	]/a\
#endif
' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    ;; # case end for file name test
    esac


    #
    # Fix  25:  Hpux_Systime
    #
    case "${file}" in ./sys/time.h )
    if ( test -n "`egrep '^extern struct sigevent;' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      hpux_systime"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's/^extern struct sigevent;/struct sigevent;/' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  26:  Interactv_Add1
    #
    case "${file}" in ./stdio.h | \
	./math.h | \
	./ctype.h | \
	./sys/limits.h | \
	./sys/fcntl.h | \
	./sys/dirent.h )
    if ( test '('  -d /etc/conf/kconfig.d ')' -a \
              '('  -n "`grep _POSIX_VERSION /usr/include/sys/unistd.h`" ')'
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      interactv_add1"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's/!defined(__STDC__) && !defined(_POSIX_SOURCE)/!defined(_POSIX_SOURCE)/' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  27:  Interactv_Add2
    #
    case "${file}" in ./math.h )
    if ( test '('  -d /etc/conf/kconfig.d ')' -a \
              '('  -n "`grep _POSIX_VERSION /usr/include/sys/unistd.h`" ')'
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      interactv_add2"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's/fmod(double)/fmod(double, double)/' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  28:  Interactv_Add3
    #
    case "${file}" in ./sys/limits.h )
    if ( test '('  -d /etc/conf/kconfig.d ')' -a \
              '('  -n "`grep _POSIX_VERSION /usr/include/sys/unistd.h`" ')'
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      interactv_add3"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e '/CHILD_MAX/s,/\* Max, Max,' \
        -e '/OPEN_MAX/s,/\* Max, Max,' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  29:  Io_Def_Quotes
    #
    if ( test -n "`egrep '[ 	]*[ 	](_|DES)IO[A-Z]*[ 	]*\\( *[^,'\\'']' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      io_def_quotes"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's/\([ 	]*[ 	]_IO[A-Z]*[ 	]*(\)\([^,'\'']\),/\1'\''\2'\'',/' \
        -e 's/\([ 	]*[ 	]DESIO[A-Z]*[ 	]*(\)\([^,'\'']\),/\1'\''\2'\'',/' \
        -e '/#[ 	]*define[ 	]*[ 	]_IO/s/'\''\([cgxtf]\)'\''/\1/g' \
        -e '/#[ 	]*define[ 	]*[ 	]DESIOC/s/'\''\([cdgx]\)'\''/\1/g' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'


    #
    # Fix  30:  Ioctl_Fix_Ctrl
    #
    if ( test -n "`egrep 'CTRL[ 	]*\\(' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      ioctl_fix_ctrl"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e '/[^A-Z0-9_]CTRL[ 	]*(/s/\([^'\'']\))/'\''\1'\'')/' \
        -e '/[^A-Z0-9]_CTRL[ 	]*(/s/\([^'\'']\))/'\''\1'\'')/' \
        -e '/#[ 	]*define[ 	]*[ 	]CTRL/s/'\''\([cgx]\)'\''/\1/g' \
        -e '/#[ 	]*define[ 	]*[ 	]_CTRL/s/'\''\([cgx]\)'\''/\1/g' \
        -e '/#[ 	]*define[ 	]*[ 	]BSD43_CTRL/s/'\''\([cgx]\)'\''/\1/g' \
        -e '/#[ 	]*define[ 	]*[ 	]_*ISCTRL/s/'\''\([cgx]\)'\''/\1/g' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'


    #
    # Fix  31:  Ip_Missing_Semi
    #
    case "${file}" in ./netinet/ip.h )
    fixlist="${fixlist}
      ip_missing_semi"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e '/^struct/,/^};/s/}$/};/' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    ;; # case end for file name test
    esac


    #
    # Fix  32:  Irix_Multiline_Cmnt
    #
    case "${file}" in ./sys/types.h )
    fixlist="${fixlist}
      irix_multiline_cmnt"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's@type of the result@type of the result */@' \
        -e 's@of the sizeof@/* of the sizeof@' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    ;; # case end for file name test
    esac


    #
    # Fix  33:  Irix_Sockaddr
    #
    case "${file}" in ./rpc/auth.h )
    if ( test -n "`egrep 'authdes_create.*struct sockaddr' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      irix_sockaddr"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e '/authdes_create.*struct sockaddr/i\
struct sockaddr;
' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  34:  Irix_Struct__File
    #
    case "${file}" in ./rpc/xdr.h )
    fixlist="${fixlist}
      irix_struct__file"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e '/xdrstdio_create.*struct __file_s/i\
struct __file_s;
' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    ;; # case end for file name test
    esac


    #
    # Fix  35:  Isc_Fmod
    #
    case "${file}" in ./math.h )
    if ( test -n "`egrep 'fmod\\(double\\)' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      isc_fmod"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's/fmod(double)/fmod(double, double)/' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  36:  Motorola_Nested
    #
    case "${file}" in ./limits.h | \
	./sys/limits.h )
    case "$target_canonical" in m68k-motorola-sysv* )
    fixlist="${fixlist}
      motorola_nested"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's@^\(#undef[ 	][ 	]*PIPE_BUF[ 	]*/\* max # bytes atomic in write to a\)$@\1 */@' \
        -e 's@\(/\*#define	HUGE_VAL	3.40282346638528860e+38 \)\(/\*error value returned by Math lib\*/\)$@\1*/ \2@' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    ;; # case end for machine type test
    esac
    ;; # case end for file name test
    esac


    #
    # Fix  37:  Isc_Sys_Limits
    #
    case "${file}" in ./sys/limits.h )
    if ( test -n "`egrep 'CHILD_MAX' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      isc_sys_limits"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e '/CHILD_MAX/s,/\* Max, Max,' \
        -e '/OPEN_MAX/s,/\* Max, Max,' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  38:  Kandr_Concat
    #
    case "${file}" in ./sparc/asm_linkage.h | \
	./sun3/asm_linkage.h | \
	./sun3x/asm_linkage.h | \
	./sun4/asm_linkage.h | \
	./sun4c/asm_linkage.h | \
	./sun4m/asm_linkage.h | \
	./sun4c/debug/asm_linkage.h | \
	./sun4m/debug/asm_linkage.h | \
	./arm/as_support.h | \
	./arm/mc_type.h | \
	./arm/xcb.h | \
	./dev/chardefmac.h | \
	./dev/ps_irq.h | \
	./dev/screen.h | \
	./dev/scsi.h | \
	./sys/tty.h | \
	./Xm.acorn/XmP.h | \
	./bsd43/bsd43_.h )
    if ( test -n "`egrep '/\\*\\*/' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      kandr_concat"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's|/\*\*/|##|g' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  39:  Limits_Ifndefs
    #
    case "${file}" in ./limits.h | \
	./sys/limits.h )
    if ( test -z "`egrep 'ifndef[ 	]+FLT_MIN' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      limits_ifndefs"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e '/[ 	]FLT_MIN[ 	]/i\
#ifndef FLT_MIN
' \
        -e '/[ 	]FLT_MIN[ 	]/a\
#endif
' \
        -e '/[ 	]FLT_MAX[ 	]/i\
#ifndef FLT_MAX
' \
        -e '/[ 	]FLT_MAX[ 	]/a\
#endif
' \
        -e '/[ 	]FLT_DIG[ 	]/i\
#ifndef FLT_DIG
' \
        -e '/[ 	]FLT_DIG[ 	]/a\
#endif
' \
        -e '/[ 	]DBL_MIN[ 	]/i\
#ifndef DBL_MIN
' \
        -e '/[ 	]DBL_MIN[ 	]/a\
#endif
' \
        -e '/[ 	]DBL_MAX[ 	]/i\
#ifndef DBL_MAX
' \
        -e '/[ 	]DBL_MAX[ 	]/a\
#endif
' \
        -e '/[ 	]DBL_DIG[ 	]/i\
#ifndef DBL_DIG
' \
        -e '/[ 	]DBL_DIG[ 	]/a\
#endif
' \
        -e '/^\(\/\*#define	HUGE_VAL	3\.[0-9e+]* *\)\/\*/s//\1/' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  40:  Lynx_Void_Int
    #
    case "${file}" in ./curses.h )
    if ( test -n "`egrep '#[ 	]*define[ 	]+void[ 	]+int' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      lynx_void_int"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e '/#[ 	]*define[ 	][ 	]*void[ 	]int/d' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  41:  Lynxos_Fcntl_Proto
    #
    case "${file}" in ./fcntl.h )
    if ( test -n "`egrep 'fcntl.*\\(int, int, int\\)' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      lynxos_fcntl_proto"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's/\(fcntl.*(int, int, \)int)/\1...)/' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  42:  M88k_Bad_Hypot_Opt
    #
    case "${file}" in ./math.h )
    case "$target_canonical" in m88k-motorola-sysv3* )
    fixlist="${fixlist}
      m88k_bad_hypot_opt"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's/extern double floor(), ceil(), fmod(), fabs();/extern double floor(), ceil(), fmod(), fabs _PARAMS((double));/' \
        -e '/^extern double hypot();$/a\
\/* Workaround a stupid Motorola optimization if one\
   of x or y is 0.0 and the other is negative!  *\/\
#ifdef __STDC__\
static __inline__ double fake_hypot (double x, double y)\
#else\
static __inline__ double fake_hypot (x, y)\
	double x, y;\
#endif\
{\
	return fabs (hypot (x, y));\
}\
#define hypot	fake_hypot
' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    ;; # case end for machine type test
    esac
    ;; # case end for file name test
    esac


    #
    # Fix  43:  M88k_Bad_S_If
    #
    case "${file}" in ./sys/stat.h )
    case "$target_canonical" in m88k-*-sysv3* )
    if ( test -n "`egrep '#define[ 	]+S_IS[A-Z]*(m)[ 	]' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      m88k_bad_s_if"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's/^\(#define[ 	]*S_IS[A-Z]*(m)\)[ 	]*(m[ 	]*&[ 	]*\(S_IF[A-Z][A-Z][A-Z][A-Z]*\)[ 	]*)/\1 (((m)\&S_IFMT)==\2)/' \
        -e 's/^\(#define[ 	]*S_IS[A-Z]*(m)\)[ 	]*(m[ 	]*&[ 	]*\(0[0-9]*\)[ 	]*)/\1 (((m)\&S_IFMT)==\2)/' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for machine type test
    esac
    ;; # case end for file name test
    esac


    #
    # Fix  44:  M88k_Multi_Incl
    #
    case "${file}" in ./time.h )
    case "$target_canonical" in m88k-tektronix-sysv3* )
    if ( test -z "`egrep '#ifndef' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      m88k_multi_incl"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 
    ( echo Fixing $file, to protect against multiple inclusion. >&2
      cpp_wrapper=`echo $file | sed -e 's,\.,_,g' -e 's,/,_,g'`
      echo "#ifndef __GCC_GOT_${cpp_wrapper}_"
      echo "#define __GCC_GOT_${cpp_wrapper}_"
      cat
      echo "#endif /* ! __GCC_GOT_${cpp_wrapper}_ */" ) < $infile > ${DESTDIR}/fixinc.tmp

    #  Shell scripts have the potential of removing the output
    #  We interpret that to mean the file is not to be altered
    #
    if test ! -f ${DESTDIR}/fixinc.tmp
    then continue ; fi 
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for machine type test
    esac
    ;; # case end for file name test
    esac


    #
    # Fix  45:  Machine_Name
    #
    if ( test -n "`egrep '^#[ 	]*(if|elif).*[^a-zA-Z0-9_](_*[MSRrhim]|[Mbimnpstuv])[a-zA-Z0-9_]' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      machine_name"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e ':loop
/\\$/N
s/\\$/\\+++fixinc_eol+++/
/\\$/b loop
s/\\+++fixinc_eol+++/\\/g
/#[	 ]*[el]*if/ {
	s/[a-zA-Z0-9_][a-zA-Z0-9_]*/ & /g
	s/ M32 / __M32__ /g
	s/ _*MIPSE\([LB]\) / __MIPSE\1__ /g
	s/ _*SYSTYPE_\([A-Z0-9]*\) / __SYSTYPE_\1__ /g
	s/ _*\([Rr][34]\)000 / __\1000__ /g
	s/ _*host_mips / __host_mips__ /g
	s/ _*i386 / __i386__ /g
	s/ _*mips / __mips__ /g
	s/ bsd4\([0-9]\) / __bsd4\1__ /g
	s/ is68k / __is68k__ /g
	s/ m68k / __m68k__ /g
	s/ m88k / __m88k__ /g
	s/ mc680\([0-9]\)0 / __mc680\10__ /g
	s/ news\([0-9]*\) / __news\1__ /g
	s/ ns32000 / __ns32000__ /g
	s/ pdp11 / __pdp11__ /g
	s/ pyr / __pyr__ /g
	s/ sel / __sel__ /g
	s/ sony_news / __sony_news__ /g
	s/ sparc / __sparc__ /g
	s/ sun\([a-z0-9]*\) / __sun\1__ /g
	s/ tahoe / __tahoe__ /g
	s/ tower\([_0-9]*\) / __tower\1__ /g
	s/ u370 / __u370__ /g
	s/ u3b\([0-9]*\) / __u3b\1__ /g
	s/ unix / __unix__ /g
	s/ vax / __vax__ /g
	s/ \([a-zA-Z0-9_][a-zA-Z0-9_]*\) /\1/g
	}' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'


    #
    # Fix  46:  Math_Exception
    #
    case "${file}" in ./math.h )
    if ( test -n "`egrep 'struct exception' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      math_exception"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e '/struct exception/i\
#ifdef __cplusplus\
#define exception __math_exception\
#endif
' \
        -e '/struct exception/a\
#ifdef __cplusplus\
#undef exception\
#endif
' \
        -e '/matherr/i\
#ifdef __cplusplus\
#define exception __math_exception\
#endif
' \
        -e '/matherr/a\
#ifdef __cplusplus\
#undef exception\
#endif
' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  47:  Math_Gcc_Ifndefs
    #
    case "${file}" in ./math.h )
    fixlist="${fixlist}
      math_gcc_ifndefs"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 
    ( 	dbl_max_def=`egrep 'define[ 	]+DBL_MAX[ 	]+.*' float.h 2>/dev/null`

	if ( test -n "${dbl_max_def}" \
		-a -n "`egrep '#define[ 	]*HUGE_VAL[ 	]+DBL_MAX' $file`" \
		-a -z "`egrep '#define[ 	]+DBL_MAX[ 	]+' $file`"
	   ) > /dev/null 2>&1
	then sed -e '/define[ 	]HUGE_VAL[ 	]DBL_MAX/s/DBL_MAX/$dbl_max_def/'
	else cat ; fi |
	sed -e '/define[ 	]HUGE_VAL[ 	]/i\
#ifndef HUGE_VAL
' -e '/define[ 	]HUGE_VAL[ 	]/a\
#endif
' ) < $infile > ${DESTDIR}/fixinc.tmp

    #  Shell scripts have the potential of removing the output
    #  We interpret that to mean the file is not to be altered
    #
    if test ! -f ${DESTDIR}/fixinc.tmp
    then continue ; fi 
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    ;; # case end for file name test
    esac


    #
    # Fix  48:  Nested_Comment
    #
    case "${file}" in ./rpc/rpc.h )
    fixlist="${fixlist}
      nested_comment"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's@^\(/\*.*rpc/auth_des.h>.*\)/\*@\1*/ /*@' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    ;; # case end for file name test
    esac


    #
    # Fix  49:  News_Os_Recursion
    #
    case "${file}" in ./stdlib.h )
    if ( test -n "`egrep '#include <stdlib.h>' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      news_os_recursion"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e '/^#include <stdlib.h>/i\
#ifdef BOGUS_RECURSION
' \
        -e '/^#include <stdlib.h>/a\
#endif
' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  50:  Next_Math_Prefix
    #
    case "${file}" in ./ansi/math.h )
    if ( test -n "`egrep '^extern.*double.*__const__.*' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      next_math_prefix"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e '/^extern.*double.*__const__.*sqrt(/s/__const__//' \
        -e '/^extern.*double.*__const__.*fabs(/s/__const__//' \
        -e '/^extern.*double.*__const__.*cos(/s/__const__//' \
        -e '/^extern.*double.*__const__.*hypot(/s/__const__//' \
        -e '/^extern.*double.*__const__.*sin(/s/__const__//' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  51:  Next_Template
    #
    case "${file}" in ./bsd/libc.h )
    if ( test -n "`egrep 'template' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      next_template"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e '/\(.*template\)/s/template//' \
        -e '/extern.*volatile.*void.*abort/s/volatile//' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  52:  Next_Volitile
    #
    case "${file}" in ./ansi/stdlib.h )
    if ( test -n "`egrep 'volatile' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      next_volitile"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e '/extern.*volatile.*void.*exit/s/volatile//' \
        -e '/extern.*volatile.*void.*abort/s/volatile//' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  53:  Next_Wait_Union
    #
    case "${file}" in ./sys/wait.h )
    if ( test -n "`egrep 'wait\\(union wait' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      next_wait_union"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's@wait(union wait@wait(void@' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  54:  Nodeent_Syntax
    #
    case "${file}" in ./netdnet/dnetdb.h )
    fixlist="${fixlist}
      nodeent_syntax"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's/char.*na_addr *$/char *na_addr;/' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    ;; # case end for file name test
    esac


    #
    # Fix  55:  Osf_Namespace_A
    #
    case "${file}" in ./reg_types.h | \
	./sys/lc_core.h )
    if ( test '('  -r reg_types.h ')' -a \
              '('  -r sys/lc_core.h ')' -a \
              '('  -n "`grep '} regex_t;' reg_types.h`" ')' -a \
              '('  -z "`grep __regex_t regex.h`" ')'
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      osf_namespace_a"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's/regex_t/__regex_t/g' \
        -e 's/regoff_t/__regoff_t/g' \
        -e 's/regmatch_t/__regmatch_t/g' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  56:  Osf_Namespace_B
    #
    case "${file}" in ./regex.h )
    if ( test '('  -r reg_types.h ')' -a \
              '('  -r sys/lc_core.h ')' -a \
              '('  -n "`grep '} regex_t;' reg_types.h`" ')' -a \
              '('  -z "`grep __regex_t regex.h`" ')'
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      osf_namespace_b"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e '/#include <reg_types.h>/a\
typedef __regex_t	regex_t;\
typedef __regoff_t	regoff_t;\
typedef __regmatch_t	regmatch_t;
' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  57:  Pthread_Page_Size
    #
    case "${file}" in ./pthread.h )
    if ( test -n "`egrep '^int __page_size' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      pthread_page_size"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's/^int __page_size/extern int __page_size/' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  58:  Rs6000_Double
    #
    case "${file}" in ./math.h )
    if ( test -n "`egrep '[^a-zA-Z_]class\\(' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      rs6000_double"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e '/class[(]/i\
#ifndef __cplusplus
' \
        -e '/class[(]/a\
#endif
' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  59:  Rs6000_Fchmod
    #
    case "${file}" in ./sys/stat.h )
    if ( test -n "`egrep 'fchmod\\(char' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      rs6000_fchmod"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's/fchmod(char \*/fchmod(int/' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  60:  Rs6000_Param
    #
    case "${file}" in ./stdio.h | \
	./unistd.h )
    fixlist="${fixlist}
      rs6000_param"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's@rename(const char \*old, const char \*new)@rename(const char *_old, const char *_new)@' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    ;; # case end for file name test
    esac


    #
    # Fix  61:  Sony_Include
    #
    case "${file}" in ./machine/machparam.h )
    if ( test -n "`egrep '\"\\.\\./machine/endian.h\"' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      sony_include"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's@"../machine/endian.h"@<machine/endian.h>@' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  62:  Statsswtch
    #
    case "${file}" in ./rpcsvc/rstat.h )
    if ( test -n "`egrep 'boottime$' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      statsswtch"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's/boottime$/boottime;/' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  63:  Stdio_Va_List
    #
    case "${file}" in ./stdio.h )
    fixlist="${fixlist}
      stdio_va_list"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 
    ( if ( egrep "__need___va_list" $file ) > /dev/null 2>&1 ; then
    :
  else
    echo "#define __need___va_list"
    echo "#include <stdarg.h>"
  fi

  sed -e 's@ va_list @ __gnuc_va_list @' \
      -e 's@ va_list)@ __gnuc_va_list)@' \
      -e 's@ _BSD_VA_LIST_));@ __gnuc_va_list));@' \
      -e 's@ _VA_LIST_));@ __gnuc_va_list));@' \
      -e 's@ va_list@ __va_list__@' \
      -e 's@\*va_list@*__va_list__@' \
      -e 's@ __va_list)@ __gnuc_va_list)@' \
      -e 's@GNUC_VA_LIST@GNUC_Va_LIST@' \
      -e 's@_NEED___VA_LIST@_NEED___Va_LIST@' \
      -e 's@VA_LIST@DUMMY_VA_LIST@' \
      -e 's@_Va_LIST@_VA_LIST@' ) < $infile > ${DESTDIR}/fixinc.tmp

    #  Shell scripts have the potential of removing the output
    #  We interpret that to mean the file is not to be altered
    #
    if test ! -f ${DESTDIR}/fixinc.tmp
    then continue ; fi 
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    ;; # case end for file name test
    esac


    #
    # Fix  64:  Sun_Bogus_Ifdef
    #
    case "${file}" in ./hsfs/hsfs_spec.h | \
	./hsfs/iso_spec.h )
    if ( test -n "`egrep '#ifdef __i386__ || __vax__' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      sun_bogus_ifdef"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's/\#ifdef __i386__ || __vax__/\#if __i386__ || __vax__/g' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  65:  Sun_Bogus_Ifdef_Sun4c
    #
    case "${file}" in ./hsfs/hsnode.h )
    if ( test -n "`egrep '#ifdef __i386__ || __sun4c__' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      sun_bogus_ifdef_sun4c"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's/\#ifdef __i386__ || __sun4c__/\#if __i386__ || __sun4c__/g' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  66:  Sun_Catmacro
    #
    case "${file}" in ./pixrect/memvar.h )
    if ( test -n "`egrep '^#define[ 	]+CAT\\(a,b\\)' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      sun_catmacro"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e '/^#define[ 	]CAT(a,b)/ i\
#ifdef __STDC__ \
#define CAT(a,b) a##b\
#else
' \
        -e '/^#define[ 	]CAT(a,b)/ a\
#endif
' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  67:  Sun_Malloc
    #
    case "${file}" in ./malloc.h )
    fixlist="${fixlist}
      sun_malloc"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's/typedef[ 	]char \*	malloc_t/typedef void \*	malloc_t/g' \
        -e 's/int[ 	][ 	]*free/void	free/g' \
        -e 's/char\([ 	]*\*[ 	]*malloc\)/void\1/g' \
        -e 's/char\([ 	]*\*[ 	]*realloc\)/void\1/g' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    ;; # case end for file name test
    esac


    #
    # Fix  68:  Sun_Memcpy
    #
    case "${file}" in ./memory.h )
    if ( test -n "`egrep '/\\*	@\\(#\\)(head/memory.h	50.1	 |memory\\.h 1\\.[2-4] 8./../.. SMI; from S5R2 1\\.2	)\\*/' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      sun_memcpy"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e '1i\
/* This file was generated by fixincludes */\
#ifndef __memory_h__\
#define __memory_h__\
\
#ifdef __STDC__\
extern void *memccpy();\
extern void *memchr();\
extern void *memcpy();\
extern void *memset();\
#else\
extern char *memccpy();\
extern char *memchr();\
extern char *memcpy();\
extern char *memset();\
#endif /* __STDC__ */\
\
extern int memcmp();\
\
#endif /* __memory_h__ */
' \
        -e '1,$d' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  69:  Sun_Rusers_Semi
    #
    case "${file}" in ./rpcsvc/rusers.h )
    if ( test -n "`egrep '_cnt$' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      sun_rusers_semi"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e '/^struct/,/^};/s/_cnt$/_cnt;/' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  70:  Sun_Signal
    #
    case "${file}" in ./sys/signal.h | \
	./signal.h )
    if ( test -n "`egrep '^void	\\(\\*signal\\(\\)\\)\\(\\);' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      sun_signal"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e '/^void	(\*signal())();$/i\
#ifdef __cplusplus\
void	(*signal(...))(...);\
#else
' \
        -e '/^void	(\*signal())();$/a\
#endif
' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  71:  Sun_Auth_Proto
    #
    case "${file}" in ./rpc/auth.h | \
	./rpc/clnt.h | \
	./rpc/svc.h | \
	./rpc/xdr.h )
    if ( test -n "`egrep '\\(\\*[a-z][a-z_]*\\)\\(\\)' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      sun_auth_proto"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's/^\(.*(\*[a-z][a-z_]*)(\)\();.*\)/\
#ifdef __cplusplus\
\1...\2\
#else\
\1\2\
#endif/' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  72:  Sunos_Matherr_Decl
    #
    case "${file}" in ./math.h )
    fixlist="${fixlist}
      sunos_matherr_decl"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e '/^struct exception/,$b' \
        -e '/matherr/i\
struct exception;
' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    ;; # case end for file name test
    esac


    #
    # Fix  73:  Sunos_Strlen
    #
    case "${file}" in ./strings.h )
    fixlist="${fixlist}
      sunos_strlen"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's/int[ 	]*strlen();/__SIZE_TYPE__ strlen();/' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    ;; # case end for file name test
    esac


    #
    # Fix  74:  Systypes
    #
    case "${file}" in ./sys/types.h | \
	./stdlib.h | \
	./sys/stdtypes.h | \
	./stddef.h | \
	./memory.h | \
	./unistd.h )
    if ( test -n "`egrep 'typedef[ 	]+[a-z_][ 	a-z_]*[ 	](size|ptrdiff|wchar)_t' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      systypes"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e '/^[ 	]*\*[ 	]*typedef unsigned int size_t;/N' \
        -e 's/^\([ 	]*\*[ 	]*typedef unsigned int size_t;\n[ 	]*\*\/\)/\1\
#ifndef __SIZE_TYPE__\
#define __SIZE_TYPE__ long unsigned int\
#endif\
typedef __SIZE_TYPE__ size_t;\
/' \
        -e '/typedef[ 	][ 	]*[a-z_][ 	a-z_]*[ 	]size_t/i\
#ifndef __SIZE_TYPE__\
#define __SIZE_TYPE__ long unsigned int\
#endif
' \
        -e 's/typedef[ 	][ 	]*[a-z_][ 	a-z_]*[ 	]size_t/typedef __SIZE_TYPE__ size_t/' \
        -e '/typedef[ 	][ 	]*[a-z_][ 	a-z_]*[ 	]ptrdiff_t/i\
#ifndef __PTRDIFF_TYPE__\
#define __PTRDIFF_TYPE__ long int\
#endif
' \
        -e 's/typedef[ 	][ 	]*[a-z_][ 	a-z_]*[ 	]ptrdiff_t/typedef __PTRDIFF_TYPE__ ptrdiff_t/' \
        -e '/typedef[ 	][ 	]*[a-z_][ 	a-z_]*[ 	]wchar_t/i\
#ifndef __WCHAR_TYPE__\
#define __WCHAR_TYPE__ int\
#endif\
#ifndef __cplusplus
' \
        -e '/typedef[ 	][ 	]*[a-z_][ 	a-z_]*[ 	]wchar_t/a\
#endif
' \
        -e 's/typedef[ 	][ 	]*[a-z_][ 	a-z_]*[ 	]wchar_t/typedef __WCHAR_TYPE__ wchar_t/' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  75:  Systypes_For_Aix
    #
    case "${file}" in ./sys/types.h )
    if ( test -n "`egrep 'typedef[ 	][ 	]*[A-Za-z_][ 	A-Za-z_]*[ 	]size_t' ${file}`" -a \
              -z "`egrep '_GCC_SIZE_T' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      systypes_for_aix"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e '/typedef[ 	][ 	]*[A-Za-z_][ 	A-Za-z_]*[ 	]size_t/i\
#ifndef _GCC_SIZE_T\
#define _GCC_SIZE_T
' \
        -e '/typedef[ 	][ 	]*[A-Za-z_][ 	A-Za-z_]*[ 	]size_t/a\
#endif
' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  76:  Sysv68_String
    #
    case "${file}" in ./string.h )
    fixlist="${fixlist}
      sysv68_string"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's/extern[ 	]*int[ 	]*strlen();/extern unsigned int strlen();/' \
        -e 's/extern[ 	]*int[ 	]*ffs[ 	]*(long);/extern int ffs(int);/' \
        -e 's/strdup(char \*s1);/strdup(const char *s1);/' \
        -e '/^extern char$/N' \
        -e 's/^extern char\(\n	\*memccpy(),\)$/extern void\1/' \
        -e '/^	strncmp(),$/N' \
        -e 's/^\(	strncmp()\),\n\(	strlen(),\)$/\1;\
extern unsigned int\
\2/' \
        -e '/^extern int$/N' \
        -e 's/^extern int\(\n	strlen(),\)/extern size_t\1/' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    ;; # case end for file name test
    esac


    #
    # Fix  77:  Sysz_Stdlib_For_Sun
    #
    case "${file}" in ./stdlib.h )
    fixlist="${fixlist}
      sysz_stdlib_for_sun"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's/int	abort/void	abort/g' \
        -e 's/int	free/void	free/g' \
        -e 's/char[ 	]*\*[ 	]*calloc/void \*	calloc/g' \
        -e 's/char[ 	]*\*[ 	]*malloc/void \*	malloc/g' \
        -e 's/char[ 	]*\*[ 	]*realloc/void \*	realloc/g' \
        -e 's/char[ 	]*\*[ 	]*bsearch/void \*	bsearch/g' \
        -e 's/int[ 	][ 	]*exit/void	exit/g' \
        -e '/typedef[ 	a-zA-Z_]*[ 	]size_t[ 	]*;/i\
#ifndef _GCC_SIZE_T\
#define _GCC_SIZE_T
' \
        -e '/typedef[ 	a-zA-Z_]*[ 	]size_t[ 	]*;/a\
#endif
' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    ;; # case end for file name test
    esac


    #
    # Fix  78:  Sysz_Stdtypes_For_Sun
    #
    case "${file}" in ./sys/stdtypes.h )
    fixlist="${fixlist}
      sysz_stdtypes_for_sun"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e '/[	 ]size_t.*;/i\
#ifndef _GCC_SIZE_T\
#define _GCC_SIZE_T
' \
        -e '/[	 ]size_t.*;/a\
#endif
' \
        -e '/[	 ]ptrdiff_t.*;/i\
#ifndef _GCC_PTRDIFF_T\
#define _GCC_PTRDIFF_T
' \
        -e '/[	 ]ptrdiff_t.*;/a\
#endif
' \
        -e '/[	 ]wchar_t.*;/i\
#ifndef _GCC_WCHAR_T\
#define _GCC_WCHAR_T
' \
        -e '/[	 ]wchar_t.*;/a\
#endif
' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    ;; # case end for file name test
    esac


    #
    # Fix  79:  Tinfo_Cplusplus
    #
    case "${file}" in ./tinfo.h )
    fixlist="${fixlist}
      tinfo_cplusplus"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's/[ 	]_cplusplus/ __cplusplus/' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    ;; # case end for file name test
    esac


    #
    # Fix  80:  Ultrix_Ansi_Compat
    #
    case "${file}" in ./ansi_compat.h )
    if ( test -n "`egrep 'ULTRIX' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      ultrix_ansi_compat"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e '1i\
/* This file intentionally left blank. */
' \
        -e '1,$d' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  81:  Ultrix_Fix_Fixproto
    #
    case "${file}" in ./sys/utsname.h )
    if ( test -n "`egrep 'ULTRIX' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      ultrix_fix_fixproto"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e '/^[ 	]*extern[ 	]*int[ 	]*uname();$/i\
struct utsname;
' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  82:  Ultrix_Atof_Param
    #
    case "${file}" in ./math.h )
    fixlist="${fixlist}
      ultrix_atof_param"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's@atof(\([ 	]*char[ 	]*\*[^)]*\))@atof(const \1)@' \
        -e 's@inline int abs(int [a-z][a-z]*) {.*}@extern "C" int abs(int);@' \
        -e 's@inline double abs(double [a-z][a-z]*) {.*}@@' \
        -e 's@inline int sqr(int [a-z][a-z]*) {.*}@@' \
        -e 's@inline double sqr(double [a-z][a-z]*) {.*}@@' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    ;; # case end for file name test
    esac


    #
    # Fix  83:  Ultrix_Const
    #
    case "${file}" in ./stdio.h )
    fixlist="${fixlist}
      ultrix_const"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's@perror( char \*__s );@perror( const char *__s );@' \
        -e 's@fputs( char \*__s,@fputs( const char *__s,@' \
        -e 's@fopen( char \*__filename, char \*__type );@fopen( const char *__filename, const char *__type );@' \
        -e 's@fwrite( void \*__ptr,@fwrite( const void *__ptr,@' \
        -e 's@fscanf( FILE \*__stream, char \*__format,@fscanf( FILE *__stream, const char *__format,@' \
        -e 's@scanf( char \*__format,@scanf( const char *__format,@' \
        -e 's@sscanf( char \*__s, char \*__format,@sscanf( const char *__s, const char *__format,@' \
        -e 's@popen(char \*, char \*);@popen(const char *, const char *);@' \
        -e 's@tempnam(char\*,char\*);@tempnam(const char*,const char*);@' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    ;; # case end for file name test
    esac


    #
    # Fix  84:  Ultrix_Ifdef
    #
    case "${file}" in ./sys/file.h )
    if ( test -n "`egrep '#ifdef KERNEL' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      ultrix_ifdef"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's/#ifdef KERNEL/#if defined(KERNEL)/' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  85:  Ultrix_Nested_Cmnt
    #
    case "${file}" in ./rpc/svc.h )
    fixlist="${fixlist}
      ultrix_nested_cmnt"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's@^\( \*	int protocol;  \)/\*@\1*/ /*@' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    ;; # case end for file name test
    esac


    #
    # Fix  86:  Ultrix_Static
    #
    case "${file}" in ./machine/cpu.h )
    if ( test -n "`egrep '#include \"r[34]_cpu' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      ultrix_static"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's/^static struct tlb_pid_state/struct tlb_pid_state/' \
        -e 's/^#include "r3_cpu\.h"$/#include <machine\/r3_cpu\.h>/' \
        -e 's/^#include "r4_cpu\.h"$/#include <machine\/r4_cpu\.h>/' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  87:  Undefine_Null
    #
    if ( test -n "`egrep '^#[ 	]*define[ 	]*[ 	]NULL[ 	]' ${file}`" -a \
              -z "`egrep '#[ 	]*(ifn|un)def[ 	]*[ 	]NULL($|[ 	])' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      undefine_null"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e '/^#[ 	]*define[ 	][ 	]*NULL[ 	]/i\
#undef NULL
' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'


    #
    # Fix  88:  Va_I960_Macro
    #
    case "${file}" in ./arch/i960/archI960.h )
    if ( test -n "`egrep '__(vsiz|vali|vpad|alignof__)' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      va_i960_macro"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's/__vsiz/__vxvsiz/' \
        -e 's/__vali/__vxvali/' \
        -e 's/__vpad/__vxvpad/' \
        -e 's/__alignof__/__vxalignof__/' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  89:  Void_Null
    #
    case "${file}" in ./curses.h | \
	./dbm.h | \
	./locale.h | \
	./stdio.h | \
	./stdlib.h | \
	./string.h | \
	./time.h | \
	./unistd.h | \
	./sys/dir.h | \
	./sys/param.h | \
	./sys/types.h )
    if ( test -n "`egrep '#[ 	]*define[ 	][ 	]*NULL[ 	].*void' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      void_null"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's/^#[ 	]*define[ 	]*NULL[ 	]*((void[ 	]*\*)0)/#define NULL 0/' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  90:  Vxworks_Gcc_Problem
    #
    case "${file}" in ./types/vxTypesBase.h )
    if ( test -n "`egrep '__GNUC_TYPEOF_FEATURE_BROKEN_USE_DEFAULT_UNTIL_FIXED__' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      vxworks_gcc_problem"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's/#ifdef __GNUC_TYPEOF_FEATURE_BROKEN_USE_DEFAULT_UNTIL_FIXED__/#if 1/' \
        -e '/[ 	]size_t/i\
#ifndef _GCC_SIZE_T\
#define _GCC_SIZE_T
' \
        -e '/[ 	]size_t/a\
#endif
' \
        -e '/[ 	]ptrdiff_t/i\
#ifndef _GCC_PTRDIFF_T\
#define _GCC_PTRDIFF_T
' \
        -e '/[ 	]ptrdiff_t/a\
#endif
' \
        -e '/[ 	]wchar_t/i\
#ifndef _GCC_WCHAR_T\
#define _GCC_WCHAR_T
' \
        -e '/[ 	]wchar_t/a\
#endif
' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  91:  Vxworks_Needs_Vxtypes
    #
    case "${file}" in ./time.h )
    if ( test -n "`egrep 'uint_t[ 	][ 	]*_clocks_per_sec' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      vxworks_needs_vxtypes"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's/uint_t/unsigned int/' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  92:  Vxworks_Needs_Vxworks
    #
    case "${file}" in ./sys/stat.h )
    if ( test -n "`egrep '#[ 	]define[ 	][ 	]*__INCstath' ${file}`" -a \
              '('  -r types/vxTypesOld.h ')' -a \
              '('  -n "`egrep '#include' $file`" ')' -a \
              '('  -n "`egrep ULONG $file`" ')'
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      vxworks_needs_vxworks"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e '/#[ 	]define[ 	][ 	]*__INCstath/a\
#include <types/vxTypesOld.h>
' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  93:  Vxworks_Time
    #
    case "${file}" in ./time.h )
    if ( test -n "`egrep 'VOIDFUNCPTR' ${file}`" -a \
              '('  -r vxWorks.h ')'
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      vxworks_time"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e '/VOIDFUNCPTR/i\
#ifndef __gcc_VOIDFUNCPTR_defined\
#ifdef __cplusplus\
typedef void (*__gcc_VOIDFUNCPTR) (...);\
#else\
typedef void (*__gcc_VOIDFUNCPTR) ();\
#endif\
#define __gcc_VOIDFUNCPTR_defined\
#endif
' \
        -e 's/VOIDFUNCPTR/__gcc_VOIDFUNCPTR/g' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  94:  X11_Class
    #
    case "${file}" in ./X11/ShellP.h )
    if ( test -z "`egrep '__cplusplus' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      x11_class"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e '/char \*class;/i\
#ifdef __cplusplus\
	char *c_class;\
#else
' \
        -e '/char \*class;/a\
#endif
' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  95:  X11_Class_Usage
    #
    case "${file}" in ./Xm/BaseClassI.h )
    if ( test -z "`egrep '__cplusplus' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      x11_class_usage"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's/ class[)]/ c_class)/g' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  96:  X11_New
    #
    case "${file}" in ./Xm/Traversal.h )
    if ( test -z "`egrep '__cplusplus' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      x11_new"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e '/Widget	old, new;/i\
#ifdef __cplusplus\
	Widget	old, c_new;\
#else
' \
        -e '/Widget	old, new;/a\
#endif
' \
        -e 's/Widget new,/Widget c_new,/g' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  97:  X11_Sprintf
    #
    case "${file}" in ./X11*/Xmu.h )
    fixlist="${fixlist}
      x11_sprintf"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 

    sed -e 's,^extern char \*	sprintf();$,#ifndef __STDC__\
extern char *	sprintf();\
#endif /* !defined __STDC__ */,' \
          < $infile > ${DESTDIR}/fixinc.tmp
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    ;; # case end for file name test
    esac


    #
    # Fix  98:  Zzz_Ki_Iface
    #
    case "${file}" in ./sys/ki_iface.h )
    if ( test -n "`egrep 'These definitions are for HP Internal developers' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      zzz_ki_iface"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 
    ( echo "Removing incorrect fix to <$file>" >&2
rm -f ${DESTDIR}/$file ${DESTDIR}/fixinc.tmp
cat > /dev/null ) < $infile > ${DESTDIR}/fixinc.tmp

    #  Shell scripts have the potential of removing the output
    #  We interpret that to mean the file is not to be altered
    #
    if test ! -f ${DESTDIR}/fixinc.tmp
    then continue ; fi 
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix  99:  Zzz_Ki
    #
    case "${file}" in ./sys/ki.h )
    if ( test -n "`egrep '11.00 HP-UX LP64' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      zzz_ki"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 
    ( echo "Removing incorrect fix to <$file>" >&2
rm -f ${DESTDIR}/$file ${DESTDIR}/fixinc.tmp
cat > /dev/null ) < $infile > ${DESTDIR}/fixinc.tmp

    #  Shell scripts have the potential of removing the output
    #  We interpret that to mean the file is not to be altered
    #
    if test ! -f ${DESTDIR}/fixinc.tmp
    then continue ; fi 
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix 100:  Zzz_Ki_Calls
    #
    case "${file}" in ./sys/ki_calls.h )
    if ( test -n "`egrep 'kthread_create_caller_t' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      zzz_ki_calls"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 
    ( echo "Removing incorrect fix to <$file>" >&2
rm -f ${DESTDIR}/$file ${DESTDIR}/fixinc.tmp
cat > /dev/null ) < $infile > ${DESTDIR}/fixinc.tmp

    #  Shell scripts have the potential of removing the output
    #  We interpret that to mean the file is not to be altered
    #
    if test ! -f ${DESTDIR}/fixinc.tmp
    then continue ; fi 
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix 101:  Zzz_Ki_Defs
    #
    case "${file}" in ./sys/ki_defs.h )
    if ( test -n "`egrep 'Kernel Instrumentation Definitions' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      zzz_ki_defs"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 
    ( echo "Removing incorrect fix to <$file>" >&2
rm -f ${DESTDIR}/$file ${DESTDIR}/fixinc.tmp
cat > /dev/null ) < $infile > ${DESTDIR}/fixinc.tmp

    #  Shell scripts have the potential of removing the output
    #  We interpret that to mean the file is not to be altered
    #
    if test ! -f ${DESTDIR}/fixinc.tmp
    then continue ; fi 
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac


    #
    # Fix 102:  Zzz_Bad_Fixes
    #
    case "${file}" in ./sundev/ipi_error.h )
    fixlist="${fixlist}
      zzz_bad_fixes"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 
    ( echo "Removing incorrect fix to <$file>" >&2
rm -f ${DESTDIR}/$file ${DESTDIR}/fixinc.tmp
cat > /dev/null ) < $infile > ${DESTDIR}/fixinc.tmp

    #  Shell scripts have the potential of removing the output
    #  We interpret that to mean the file is not to be altered
    #
    if test ! -f ${DESTDIR}/fixinc.tmp
    then continue ; fi 
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    ;; # case end for file name test
    esac


    #
    # Fix 103:  Zzz_Time
    #
    case "${file}" in ./sys/time.h )
    if ( test -n "`egrep '11.0 and later representation of ki time' ${file}`"
       ) > /dev/null 2>&1 ; then
    fixlist="${fixlist}
      zzz_time"
    if [ ! -r ${DESTFILE} ]
    then infile=${file}
    else infile=${DESTFILE} ; fi 
    ( echo "Removing incorrect fix to <$file>" >&2
rm -f ${DESTDIR}/$file ${DESTDIR}/fixinc.tmp
cat > /dev/null ) < $infile > ${DESTDIR}/fixinc.tmp

    #  Shell scripts have the potential of removing the output
    #  We interpret that to mean the file is not to be altered
    #
    if test ! -f ${DESTDIR}/fixinc.tmp
    then continue ; fi 
    rm -f ${DESTFILE}
    mv -f ${DESTDIR}/fixinc.tmp ${DESTFILE}
    fi # end of selection 'if'
    ;; # case end for file name test
    esac
    #  IF the output has been removed OR it is unchanged,
    #  THEN ensure the output is gone
    #  ELSE look for local directory include syntax
    #
    if ( test ! -f ${DESTFILE} || \
         cmp ${file} ${DESTFILE} ) > /dev/null 2>&1
    then
      rm -f ${DESTFILE}
    else
      echo "Fixed ${file}:${fixlist}"

      # Find any include directives that use "file".
      #
      dir=`echo ${file} | sed -e s';/[^/]*$;;'`
      ddir=${DESTDIR}/$dir

      for include in `
         egrep '^[      ]*#[    ]*include[      ]*"[^/]' ${DESTFILE} |
         sed -e 's/^[   ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`
      do
        required="$required ${SRCDIR} $dir/$include ${ddir}/$include"
      done
    fi
  done # for file in $files

done

## Make sure that any include files referenced using double quotes
## exist in the fixed directory.  This comes last since otherwise
## we might end up deleting some of these files "because they don't
## need any change."
set x `echo $required`
shift
while [ $# != 0 ]; do
  newreq=
  while [ $# != 0 ]; do
    # $1 is the directory to copy from,
    # $2 is the unfixed file,
    # $3 is the fixed file name.
    #
    cd ${INPUT}
    cd $1
    if [ -f $2 ] ; then
      if [ -r $2 ] && [ ! -r $3 ]; then
        cp $2 $3 >/dev/null 2>&1 || echo "Can't copy $2" >&2
        chmod +w $3 2>/dev/null
        chmod a+r $3 2>/dev/null
        echo Copied $2
        for include in `egrep '^[ 	]*#[ 	]*include[ 	]*"[^/]' $3 |
             sed -e 's/^[ 	]*#[ 	]*include[ 	]*"\([^"]*\)".*$/\1/'`
        do
	  dir=`echo $2 | sed -e s'|/[^/]*$||'`
	  dir2=`echo $3 | sed -e s'|/[^/]*$||'`
	  newreq="$newreq $1 $dir/$include $dir2/$include"
        done
      fi
    fi
    shift; shift; shift
  done
  set x $newreq
  shift
done

echo 'Cleaning up DONE files.'
cd $LIB
find . -name DONE -exec rm -f '{}' ';'

echo 'Removing unneeded directories:'
cd $LIB
all_dirs=`find . -type d \! -name '.' -print | sort -r`
for file in $all_dirs; do
  rmdir $LIB/$file > /dev/null 2>&1
done

# # # # # # # # # # # # # # # # # # # # #
#
# End of for INPUT directories
#
done
#
# # # # # # # # # # # # # # # # # # # # #

if [ x${INSTALL_ASSERT_H} != x ] && [ -f ${srcdir}/assert.h ]
then
  cd $ORIGDIR
  rm -f include/assert.h
  cp ${srcdir}/assert.h include/assert.h || exit 1
  chmod a+r include/assert.h
fi
