/* Configuration processing routines for GNATS -*- C -*-
   Copyright (C) 1993, 1994, 1995 Free Software Foundation, Inc.

This file is part of GNU GNATS.

GNU GNATS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU GNATS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU GNATS; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* The basic idea here is to be able to use the same configuration file for
   sh scripts and C programs; the sh script just uses `.', but the C program
   has to be a bit more trickier.  And a lot uglier.  */

/* FIXME, maybe: Use hash table for more option-ridden programs.  */

#include "config.h"
#include "gnats.h"
#include "pathmax.h"

char *gnats_root = NULL;

static char _gnats_addr[STR_MAX] = GNATS_ADDR;
char *gnats_addr = _gnats_addr;
static char _gnats_server[STR_MAX] = GNATS_SERVER;
char *gnats_server = _gnats_server;
int gnats_server_port = GNATS_SERVER_PORT;
static char _gnats_service[STR_MAX] = GNATS_SERVICE;
char *gnats_service = _gnats_service;
static char _gnats_user[STR_MAX] = GNATS_USER;
char *gnats_user = _gnats_user;
static char _gnats_admin[STR_MAX] = GNATS_ADMIN;
char *gnats_admin = _gnats_admin;
static char _def_subm[STR_MAX] = DEFAULT_SUBMITTER;
char *def_subm = _def_subm;
static char _def_release[STR_MAX] = DEFAULT_RELEASE;
char *def_release = _def_release;
int flag_notify = NOTIFY;
int flag_ack = ACKNOWLEDGE;
int keep_rec = KEEP_RECEIVED_HEADERS;
int debug_mode = DEBUG_MODE;
int bday_start = BDAY_START;
int bday_end = BDAY_END;
int bweek_start = BWEEK_START;
int bweek_end = BWEEK_END;
static char _mail_agent[STR_MAX] = MAIL_AGENT;
char *mail_agent = _mail_agent;
static char _bindir[STR_MAX] = BINDIR;
char *bindir = _bindir;
#define DEFAULT_CATEGORY "pending"
static char _default_category[STR_MAX] = DEFAULT_CATEGORY;
char *default_category = _default_category;

struct conf
{
  char* key;
  char* val;
};

#ifdef __STDC__
#define STDCINIT
#endif
   
#ifdef STDCINIT
static struct conf confs[] = {
  { "GNATS_ADDR", _gnats_addr },
  { "GNATS_SERVER", _gnats_server },
  { "GNATS_SERVER_PORT", (char *) &gnats_server_port },
  { "GNATS_SERVICE", _gnats_service },
  { "GNATS_USER", _gnats_user },
  { "GNATS_ADMIN", _gnats_admin },
  { "DEFAULT_SUBMITTER", _def_subm },
  { "DEFAULT_RELEASE", _def_release },
  { "NOTIFY", (char *) &flag_notify },
  { "ACKNOWLEDGE", (char *) &flag_ack },
  { "KEEP_RECEIVED_HEADERS", (char *) &keep_rec },
  { "DEBUG_MODE", (char *) &debug_mode },
  { "BDAY_START", (char *) &bday_start },
  { "BDAY_END", (char *) &bday_end },
  { "BWEEK_START", (char *) &bweek_start },
  { "BWEEK_END", (char *) &bweek_end },
  { "MAIL_AGENT", _mail_agent },
  { "BINDIR", _bindir },
  { "DEFAULT_CATEGORY", _default_category },
};
#else
static struct conf confs[19];
#endif

static char *fname = NULL;
static char *string_extract_double_quoted ();
static char *safe_strtok ();

/* Read in and set the above configuration parameters */
void
configure()
{
  FILE *fp;
  char line[STR_MAX];

#ifndef STDCINIT
  confs[0].key = "GNATS_ADDR"; confs[0].val = gnats_addr;
  confs[1].key = "GNATS_SERVER"; confs[1].val = gnats_server;
  confs[2].key = "GNATS_SERVER_PORT"; confs[2].val = (char *) &gnats_server_port;
  confs[3].key = "GNATS_SERVICE"; confs[3].val = gnats_service;
  confs[4].key = "GNATS_USER"; confs[4].val = gnats_user;
  confs[5].key = "GNATS_ADMIN"; confs[5].val = gnats_admin;
  confs[6].key = "DEFAULT_SUBMITTER"; confs[6].val = def_subm;
  confs[7].key = "DEFAULT_RELEASE"; confs[7].val = def_release;
  confs[8].key = "NOTIFY"; confs[8].val = (char *) &flag_notify;
  confs[9].key = "ACKNOWLEDGE"; confs[9].val = (char *) &flag_ack;
  confs[10].key = "KEEP_RECEIVED_HEADERS"; confs[10].val = (char *) &keep_rec;
  confs[11].key = "DEBUG_MODE"; confs[11].val = (char *) &debug_mode;
  confs[12].key = "BDAY_START"; confs[12].val = (char *) &bday_start;
  confs[13].key = "BDAY_END"; confs[13].val = (char *) &bday_end;
  confs[14].key = "BWEEK_START"; confs[14].val = (char *) &bweek_start;
  confs[15].key = "BWEEK_END"; confs[15].val = (char *) &bweek_end;
  confs[16].key = "MAIL_AGENT"; confs[16].val = mail_agent;
  confs[17].key = "BINDIR"; confs[17].val = bindir;
  confs[18].key = "DEFAULT_CATEGORY"; confs[18].val = default_category;
#endif
  
  if (! gnats_root)
    {
      gnats_root = getenv ("GNATS_ROOT");
      if (! gnats_root)
	gnats_root = X_GNATS_ROOT;
    }
  
  if (fname)
    xfree (fname);
  
#define CONFSTR "%s/gnats-adm/config"
  fname = xmalloc (strlen (gnats_root) + sizeof (CONFSTR) - 1);
  sprintf (fname, CONFSTR, gnats_root);
  
  fp = fopen (fname, "r");
  
  if (fp == NULL)		/* no config file; no problem */
    return;
  
  while (fgets (line, STR_MAX, fp) != NULL)
    {
      int i;
      if (*line == '#') continue; /* comment */
      for (i=0; i < sizeof(confs)/sizeof(struct conf); i++) {
	int n = strlen(confs[i].key);
	if (! strncmp(confs[i].key, line, n) && line[n] == '=') {
	  char *p = line+n+1;
	  int d;
	  if (sscanf (p, "%d", &d) > 0)	/* NOTIFY=1 */
	    *((int *) confs[i].val) = d;
	  else			/* string parameter */
	    {
	      /* Mimic somewhat the sh interpretation of the line.  */
	      if (*p == '\'')
		strcpy (confs[i].val, safe_strtok(p+1, "'"));
	      else if (*p == '"')
		strcpy (confs[i].val, string_extract_double_quoted(p+1));
	      else strcpy (confs[i].val, safe_strtok(p, " \t\n"));
	    }
	  break;
	}
      }
    }

  fclose (fp);
}

static char *
safe_strtok (s, d)
     char *s, *d;
{
  char *r = strtok (s, d);
  if (!r && *s != '\n')
    r = strtok (s, "\n");
  if (!r)
    r = "";
  return r;
}

/* Lifted largely from bash/subst.c */
static char *
string_extract_double_quoted (string)
     char *string;
{
  register int c, j, i;		/* character, temp pos, str pos */
  char *temp;			/* The new string we return. */
  int pass_next;		/* State variables for the machine. */

  pass_next = 0;
  temp = (char *)xmalloc (strlen (string) + 1);

  for (j = 0, i = 0; (c = string[i]) != '\0'; i++)
    {
      /* Process a character that was quoted by a backslash. */
      if (pass_next)
	{
	  /* Posix.2 sez:

	     ``The backslash shall retain its special meaning as an escape
	     character only when followed by one of the characters:
	     	$	`	"	\	<newline>''.  */
	  if (c != '$' && c != '`' && c != '"' && c != '\\' && c != '\n')
	    temp[j++] = '\\';
          temp[j++] = c;
          pass_next = 0;
          continue;
	}

      /* A backslash protects the next character.  The code just above
         handles preserving the backslash in front of any character but
         a double quote. */
      if (c == '\\')
	{
	  pass_next++;
	  continue;
	}

      /* An unescaped double quote serves to terminate the string. */
      if (c == '"')
        break;

      /* Add the character to the quoted string we're accumulating. */
      temp[j++] = c;
    }
  temp[j] = '\0';
  strcpy (string, temp);
  xfree (temp);
  return (string);
}
