/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.construct;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.gnunet.construct.UnionCase;

@SupportedAnnotationTypes(value={"org.gnunet.construct.UnionCase"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class MessageIdAnnotationProcessor
extends AbstractProcessor {
    private final Table<String, Integer, String> idToMember = HashBasedTable.create();

    @Override
    public boolean process(Set<? extends TypeElement> typeElements, RoundEnvironment roundEnvironment) {
        if (roundEnvironment.errorRaised()) {
            return false;
        }
        Types types = this.processingEnv.getTypeUtils();
        Elements elements = this.processingEnv.getElementUtils();
        if (roundEnvironment.processingOver()) {
            FileObject fileObject;
            Filer filer = this.processingEnv.getFiler();
            try {
                fileObject = filer.createResource(StandardLocation.SOURCE_OUTPUT, "org.gnunet.construct", "MsgMap.txt", new Element[0]);
            }
            catch (IOException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Could not create MsgMap.txt");
                return false;
            }
            try {
                Writer w = fileObject.openWriter();
                for (Table.Cell cell : this.idToMember.cellSet()) {
                    w.write((String)cell.getRowKey() + '|' + cell.getColumnKey() + '=' + (String)cell.getValue() + '\n');
                }
                SimpleDateFormat fmt = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                w.write("# generated " + fmt.format(new Date()) + '\n');
                w.close();
            }
            catch (IOException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Could not write MsgMap.txt");
            }
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "message map written to " + fileObject.toUri());
        } else {
            for (Element element : roundEnvironment.getElementsAnnotatedWith(UnionCase.class)) {
                UnionCase ann = element.getAnnotation(UnionCase.class);
                List<? extends TypeMirror> parents = this.processingEnv.getTypeUtils().directSupertypes(element.asType());
                TypeMirror msg = elements.getTypeElement("org.gnunet.construct.MessageUnion").asType();
                TypeMirror unionInterface = null;
                for (TypeMirror typeMirror : parents) {
                    if (!types.isSubtype(typeMirror, msg)) continue;
                    unionInterface = typeMirror;
                    break;
                }
                if (unionInterface == null) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("class %s annotated with @UnionCase does not implement an interface inheriting MessageUnion", element.getSimpleName()));
                    return false;
                }
                String unionName = this.getClassName(types.asElement(unionInterface));
                if (this.idToMember.contains((Object)unionName, (Object)ann.value())) {
                    String string = (String)this.idToMember.get((Object)unionName, (Object)ann.value());
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("duplicate message id %s for union '%s: '%s' and '%s'", ann.value(), unionName, this.getClassName(element), string));
                    return false;
                }
                this.idToMember.put((Object)unionName, (Object)ann.value(), (Object)this.getClassName(element));
            }
        }
        return false;
    }

    private String getClassName(Element e) {
        assert (e.getKind().isClass());
        String name = e.getSimpleName().toString();
        String pkg = this.processingEnv.getElementUtils().getPackageOf(e).getQualifiedName().toString() + '.';
        String outer = "";
        while ((e = e.getEnclosingElement()) != null && e.getKind().isClass()) {
            outer = String.format("%s$%s", e.getSimpleName(), outer);
        }
        return pkg + outer + name;
    }
}

