/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.secretsharing;

import java.util.Arrays;
import org.gnunet.construct.FixedSizeIntegerArray;
import org.gnunet.construct.Message;
import org.gnunet.util.Strings;

public class ThresholdPublicKey
implements Message {
    @FixedSizeIntegerArray(signed=true, bitSize=8, length=128)
    public byte[] bits;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThresholdPublicKey that = (ThresholdPublicKey)o;
        return Arrays.equals(this.bits, that.bits);
    }

    public int hashCode() {
        return this.bits != null ? Arrays.hashCode(this.bits) : 0;
    }

    public static ThresholdPublicKey fromString(String value) {
        ThresholdPublicKey pk = new ThresholdPublicKey();
        pk.bits = new byte[128];
        Strings.stringToData(value, pk.bits);
        return pk;
    }

    public String toString() {
        return Strings.dataToString(this.bits);
    }
}

