/* -*- c++ -*- */
/*
 * Copyright 2002 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * Unwinds a file formatted as a circular buffer.
 * Dumps the contents to standard out, oldest to newest.
 */

#include <cstdio>
#include <cstdlib>
#include <gr_circular_file.h>

int main (int argc, char **argv)
{
  if (argc != 2){
    fprintf (stderr, "usage: dump_circfile input_filename\n");
    exit (1);
  }

  const char *filename = argv[1];

  gr_circular_file *cf = new gr_circular_file (filename);
  
  static const int BUFSIZE = 64*1024;
  unsigned char buf[BUFSIZE];

  int n;
  while ((n = cf->read (buf, BUFSIZE)) > 0){
    fwrite (buf, 1, n, stdout);
  }

  delete cf;
  exit (0);
}
