/* -*- c++ -*- */
/*
 * Copyright 2002 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _GRIIRFILTER_H_
#define _GRIIRFILTER_H_

#include <VrDecimatingSigProc.h>
#include <gr_iir.h>

/*!
 * \brief IIR filter
 *
 * Uses a single input array to produce a single output array.
 * Additional inputs and/or outputs are ignored.
 */

template<class iType, class oType, class taptype>
class GrIIRfilter : public VrDecimatingSigProc<iType,oType>
{
 public:
  /*!
   * Construct an IIR filter with the given taps
   */
  GrIIRfilter (int decimation_factor,const vector<taptype> intaps,
		  const vector<taptype> outtaps);

  virtual const char *name () { return "GrIIRfilter"; }
  virtual void initialize ();
  virtual int work (VrSampleRange output, void *o[],
		    VrSampleRange inputs[], void *i[]);

 protected:
  gr_iir<oType,iType,taptype>	_iir;
};


template<class iType, class oType, class taptype>
GrIIRfilter<iType, oType, taptype>::GrIIRfilter (int decimation_factor,
						const vector <taptype> intaps,
						const vector <taptype> outtaps)
  : VrDecimatingSigProc<iType, oType>(1, decimation_factor),
    _iir (intaps,outtaps)
   // _builder (0),
{
}

template<class iType, class oType, class taptype> void
GrIIRfilter<iType, oType, taptype>::initialize ()
{
}

template<class iType, class oType, class taptype> int
GrIIRfilter<iType, oType, taptype>::work (VrSampleRange output, void *ao[],
				     VrSampleRange inputs[], void *ai[])
{
  iType *in = (iType *) ai[0];
  oType *out = (oType *) ao[0];

  _iir.filterN (out, in, output.size);

  return output.size;
}


#endif /* _GRIIRFILTER_H_ */
