/* -*- c++ -*- */
/*
 * Copyright 2002 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <cppunit/TestCase.h>
#include <cppunit/TestCaller.h>
#include <cppunit/TestSuite.h>
#include <cppunit/TextTestResult.h>
#include <iostream>

#include <qa_gr.h>
#include <qa_dtv.h>

int 
main (int argc, char **argv)
{
  
  CppUnit::TestSuite	  top_level ("Top Level Suite");
  CppUnit::TextTestResult result;


  top_level.addTest (qa_gr::suite ());
  top_level.addTest (qa_dtv::suite ());
  
  top_level.run (&result);
  std::cout << result << std::endl;

  return result.wasSuccessful () ? 0 : 1;
}
