/* -*- Mode: c++ -*-
 *
 *  Copyright 1997 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 */

#ifndef _VRPERFGRAPH_H_
#define _VRPERFGRAPH_H_

#ifdef PERFMON
#include <VrCycleCount.h>
#define  MAXGRAPHMODULES 50

class VrSigProc;

class VrPerfGraph {
private:

  VrSigProc **modules;
  const char *labels[MAXGRAPHMODULES];
  int num_modules;
  char *title;

public: 
  VrPerfGraph() : num_modules(0), title("Performance Numbers") {};
  VrPerfGraph(char *t) : num_modules(0), title(t) {};
  void setTitle(char *t) {title=t;}
  void add(const char *name, VrSigProc *m);
  void outputGraph(double seconds);
  void print_stats();
};

extern VrCycleCount *overhead;

#endif /* PERFMON */

#endif  /* _VRPERFGRAPH_H_ */
